﻿// $Id$

#ifndef INCLUDE_ccc_iceman_DecodeUrl_h
#define INCLUDE_ccc_iceman_DecodeUrl_h

#include <ccc/base/PushbackIFilter.h>
#include <ccc/iceman/Iceman.h>

CCC_NAMESPACE_START(CCC);

/*!
 * URLエンコーディングされたデータをデコードします。
 */
class DecodeUrl
  : public Int8PushbackIFilter
{
 public:
  /*!
   * コンストラクタ
   */
  DecodeUrl();
  /*!
   * デストラクタ
   */
  ~DecodeUrl();
  /*!
   * デコードした結果を得ます。
   */
  virtual Int8 getInt8() CCC_RAISES(IOException);
  /*!
   * このクラスのオブジェクトを生成します。
   * \return DecodeUrlクラスのオブジェクト
   */
  static IFilter* createIFilter();
  /*!
   * URLデコードを行います。
   * \param src エンコード元
   * \param result エンコード結果
   */
  static void decode(const BString* src, BString* result);
};

CCC_NAMESPACE_END(CCC);

#endif /* INCLUDE_ccc_iceman_DecodeUrl_h */
