﻿// @@DISTHDR@@
// $Id$

#ifndef INCLUDE_ccc_iceman_Detector_h
#define INCLUDE_ccc_iceman_Detector_h

#include <ccc/iceman/Iceman.h>

CCC_NAMESPACE_START(CCC);

/*!
 * 文字セット、エンコーディング判定のインターフェース
 */
class Detector
  : public Object
{
 public:
  /*!
   * コンストラクタ
   */
  Detector() { }
  /*!
   * デストラクタ
   */
  virtual ~Detector() { }
  /*!
   * エンコーディングを判定します。
   * \param in 入力フロー
   * \return 判定結果
   */
  virtual CeId detect(IFlow* in) = 0;
  /*!
   * エンコーディング判定のステータスを一旦クリアします。
   * \retval true 正常にクリアできました。
   * \retval false 正常にクリアできませんでした。
   */
  virtual bool rewind() { return true; }
};

CCC_NAMESPACE_END(CCC);

#endif /* INCLUDE_ccc_iceman_Detector_h */
