﻿// @@DISTHDR@@
// $Id$

#include <ccc/iceman/Detector.h>
#include <ccc/iceman/DetectorDictionary.h>
#include <ccc/iceman/JaDetector.h>
#include <ccc/iceman/XmlDetector.h>
#include <ccc/iceman/HtmlDetector.h>

CCC_NAMESPACE_START(CCC);

DetectorEntry detectors[] =
{
  { CEID_JADETECTOR, &JaDetector::createDetector },
  { CEID_XMLDETECTOR, &XmlDetector::createDetector },
  { CEID_HTMLDETECTOR, &HtmlDetector::createDetector },
  { CEID_NULL, 0 },
};

DetectorEntry*
DetectorDictionary::search(CeId id)
{
  DetectorEntry* de = detectors;
  while (de->id != CEID_NULL)
  {
    if (de->id == id)
    {
      return de;
    }
    de++;
  }
  return 0;
}

CCC_NAMESPACE_END(CCC);
