﻿// $Id$

#ifndef INCLUDE_ccc_iceman_DetectorDictionary_h
#define INCLUDE_ccc_iceman_DetectorDictionary_h

CCC_NAMESPACE_START(CCC);

/*!
 * ディテクタを生成する関数の型
 */
typedef Detector* (*CreateDetectorFunc)();

/*!
 * ディテクタの種別と、ディテクタを生成する関数が登録された辞書のエントリを示します。
 */
struct DetectorEntry
{
  /*! ディテクタの種別 */
  CeId id;
  /*! ディテクタを生成する関数 */
  CreateDetectorFunc func;
};

/*!
 * ディテクタの種別と、ディテクタを生成する関数が登録された辞書を示します。
 */
class DetectorDictionary
  : public Object
{
 public:
  /*!
   * 辞書から指定されたディテクタのエントリを探して、ディテクタを生成します。
   * \param id ディテクタの種別
   * \return ディテクタ, 0が返った場合には該当のディテクタが存在しなかった
   * ことを示します。
   */
  static DetectorEntry* search(CeId id);
};

CCC_NAMESPACE_END(CCC);

#endif /* INCLUDE_ccc_iceman_DetectorDictionary_h */
