﻿// $Id$

#include <ctype.h>
#include <ccc/iceman/EncodeUrl.h>
#include <ccc/base/StringIFlow.h>
#include <ccc/base/StringOFlow.h>
#include <ccc/base/Conveyer.h>

CCC_NAMESPACE_START(CCC);

EncodeUrl::EncodeUrl()
{
}

EncodeUrl::~EncodeUrl()
{
}

Int8
EncodeUrl::getInt8() CCC_RAISES(IOException)
{
  if (getQueueLength())
  {
    Int8 ret = pop();
    return ret;
  }
  UInt8 c = (UInt8)src->getInt8();
  if (c == ' ')
  {
    return '+';
  }
  else if (isalnum(c) ||
	   (c == '*') ||
	   (c == '-') ||
	   (c == '.') ||
	   (c == '_'))
  {
    return (Int8)c;
  }
  else
  {
    Int8 buf[4];
    sprintf(buf, "%02X", c);
    push(buf[1]);
    push(buf[0]);
    return '%';
  }
}

IFilter*
EncodeUrl::createIFilter()
{
  return new EncodeUrl();
}

void
EncodeUrl::encode(const BString* src, BString* result)
{
  BStringIFlow iflow(src);
  EncodeUrl encoder;
  encoder.setSrc(&iflow);
  BStringOFlow oflow(result);
  Conveyer conv(&encoder, &oflow);
  try
  {
    conv.carry(IOTYPE_INT8);
  }
  catch (IOException /* ioe */)
  {
  }
}

CCC_NAMESPACE_END(CCC);
