﻿// $Id$

#ifndef INCLUDE_ccc_iceman_EncodeUrl_h
#define INCLUDE_ccc_iceman_EncodeUrl_h

#include <ccc/base/PushbackIFilter.h>
#include <ccc/iceman/Iceman.h>
#include <ccc/base/TString.h>

CCC_NAMESPACE_START(CCC);

/*!
 * 8ビットのデータをURLエンコーディングします。
 */
class EncodeUrl
  : public Int8PushbackIFilter
{
 public:
  /*!
   * コンストラクタ
   */
  EncodeUrl();
  /*!
   * デストラクタ
   */
  ~EncodeUrl();
  /*!
   * URLエンコーディングした結果を得ます。
   */
  virtual Int8 getInt8() CCC_RAISES(IOException);
  /*!
   * このクラスのオブジェクトを生成します。
   * \return EncodeUrlクラスのオブジェクト
   */
  static IFilter* createIFilter();
  /*!
   * URLエンコードを行います。
   * \param src エンコード元
   * \param result エンコード結果
   */
  static void encode(const BString* src, BString* result);
};

CCC_NAMESPACE_END(CCC);

#endif /* INCLUDE_ccc_iceman_EncodeUrl_h */
