﻿// @@DISTHDR@@
// $Id$

#ifndef INCLUDE_ccc_iceman_HtmlDetector_h
#define INCLUDE_ccc_iceman_HtmlDetector_h

#include <ccc/iceman/Detector.h>

CCC_NAMESPACE_START(CCC);

/*!
 * HTMLを対象とするディテクタ
 */
class HtmlDetector
  : public Detector
{
 public:
  /*!
   * コンストラクタ
   */
  HtmlDetector();
  /*!
   * デストラクタ
   */
  virtual ~HtmlDetector();
  /*!
   * エンコーディングを判定します。
   * \param in 入力フロー
   * \return 判定結果
   */
  virtual CeId detect(IFlow* in);
  /*!
   * エンコーディング判定のステータスを一旦クリアします。
   * \retval true 正常にクリアできました。
   * \retval false 正常にクリアできませんでした。
   */
  virtual bool rewind();
  /*!
   * ディテクタのインスタンスを生成します。
   * \return HtmlDetectorのインスタンス
   */
  static Detector* createDetector();
};

CCC_NAMESPACE_END(CCC);

#endif /* INCLUDE_ccc_iceman_HtmlDetector_h */
