﻿// @@DISTHDR@@
// $Id$

#include <stdio.h>
#include <ccc/iceman/IFilterDictionary.h>
#include <ccc/iceman/unitfilter.h>

CCC_NAMESPACE_START(CCC);

IFilterDictionary* IFilterDictionary::filter_dictionary = 0;

const int*
IFilterDictionary::getKey(const IFilterDictionaryEntry* entry) const
{
  return entry->getKey();
}

int
IFilterDictionary::compare(const int* key1, const int* key2) const
{
  return *key1 - *key2;
}

IFilterDictionary::IFilterDictionary()
{
}

IFilterDictionary::~IFilterDictionary()
{
}

void
IFilterDictionary::initialize()
{
  filter_dictionary = new IFilterDictionary();
  for (CompositIFilterEntry* cf = composit_filters;
       cf->from != CEID_NULL;
       cf++)
  {
    IFilterDictionaryEntry* fde = new IFilterDictionaryEntry(cf->from, cf->to, cf->lost);
    for (int i = 0; i < ICEMAN_MAX_COMPOSIT_PATH; i++)
    {
      (*fde)[i] = cf->path[i];
    }
    filter_dictionary->add(fde);
  }
}

void
IFilterDictionary::unInitialize()
{
  // TODO: remove all elements
  Iterator<IFilterDictionaryEntry>* itr = filter_dictionary->createIterator();
  IFilterDictionaryEntry* e;
  while ((e = itr->next()))
  {
    delete e;
  }
  delete itr;
  delete filter_dictionary;
}

IFilterDictionaryEntry*
IFilterDictionary::searchId(CeId from, CeId to)
{
  int key = CCC_MAKE_FILTERDICTIONARY_KEY(from, to);
  IFilterDictionaryEntry* entry = filter_dictionary->search(&key);
  return entry;
}

void
IFilterDictionary::test()
{
  for (CompositIFilterEntry* cf = composit_filters;
       cf->from != CEID_NULL;
       cf++)
  {
    IFilterDictionaryEntry* fde = searchId(cf->from, cf->to);
    printf("Search: from:%d, to:%d\n", cf->from, cf->to);
    fde->dump();
    printf("\n");
  }
}

CCC_NAMESPACE_END(CCC);
