﻿// @@DISTHDR@@
// $Id$

#ifndef INCLUDE_ccc_iceman_IFilterDictionary_h
#define INCLUDE_ccc_iceman_IFilterDictionary_h

#include <ccc/base/AVLDict.h>
#include <ccc/iceman/IFilterDictionaryEntry.h>

CCC_NAMESPACE_START(CCC);

class IFilterDictionary
  : protected AVLDict<IFilterDictionaryEntry, int>
{
  static IFilterDictionary* filter_dictionary;

 protected:
  virtual const int* getKey(const IFilterDictionaryEntry* entry) const;
  virtual int compare(const int* key1, const int* key2) const;
  IFilterDictionary();
  ~IFilterDictionary();

 public:
  static void initialize();
  static void unInitialize();
  static IFilterDictionaryEntry* searchId(CeId from, CeId to);
  static void test();
};

CCC_NAMESPACE_END(CCC);

#endif /* INCLUDE_ccc_iceman_IFilterDictionary_h */
