﻿// $Id$

#include <stdio.h>
#include <ccc/iceman/IFilterDictionaryEntry.h>

CCC_NAMESPACE_START(CCC);

IFilterDictionaryEntry::IFilterDictionaryEntry(CeId from_, CeId to_, int lost_)
 : from(from_), to(to_), lost(lost_)
{
  // key is composed by from and to.
  key = CCC_MAKE_FILTERDICTIONARY_KEY(from, to);
}

void
IFilterDictionaryEntry::dump()
{
  printf("IFilterDictionaryEntry: from:%d, to:%d, lost:%d, unitfilters:", from, to, lost);
  int len = getLength();
  for (int i = 0; i < len; i++)
  {
    printf("%d, ", (*this)[i]);
  }
  printf("\n");
}

CCC_NAMESPACE_END(CCC);
