﻿// $Id$

#ifndef INCLUDE_ccc_iceman_IFilterDictionaryEntry_h
#define INCLUDE_ccc_iceman_IFilterDictionaryEntry_h

#include <ccc/iceman/Iceman.h>
#include <ccc/iceman/CenDictionary.h>
#include <ccc/iceman/IFilterPath.h>

CCC_NAMESPACE_START(CCC);

class IFilterDictionaryEntry
  : public IFilterPath
{
  CeId from;
  CeId to;
  int lost;
  int key;

 public:
  IFilterDictionaryEntry(CeId from, CeId to, int lost);
  const int* getKey() const { return &key; }
  CeId getFrom() { return from; }
  CeId getTo() { return to; }
  void dump();
};

#define CCC_MAKE_FILTERDICTIONARY_KEY(from, to) (((int)from << 16) + (int)to)

CCC_NAMESPACE_END(CCC);

#endif /* INCLUDE_ccc_iceman_IFilterDictionaryEntry_h */
