﻿// @@DISTHDR@@
// $Id$

#include <assert.h>
#include <ccc/iceman/Iceman.h>
#include <ccc/iceman/Unicode.h>

CCC_NAMESPACE_START(CCC);

UInt32
Unicode::convertSurrogatePairToUcs4(UInt16 high_surrogate, UInt16 low_surrogate)
{
  if (!(highSurrogateP(high_surrogate) && lowSurrogateP(low_surrogate)))
  {
    return 0;
  }
  UInt32 hi = high_surrogate;
  UInt32 lo = low_surrogate;
  UInt32 ret = (((hi - ICEMAN_UNICODE_SURROGATE_HIGH_MIN) << 10) +
		(lo - ICEMAN_UNICODE_SURROGATE_LOW_MIN) + 0x10000);
  return ret;
}

bool
Unicode::convertUcs4ToSurrogatePair(UInt32 ucs4, UInt16* high_surrogate, UInt16* low_surrogate)
{
  if ((ucs4 < 0x10000) || (ucs4 > 0x10ffff))
  {
    return false;
  }
  ucs4 -= 0x10000;
  UInt32 hi = (UInt32)(ucs4 >> 10) + ICEMAN_UNICODE_SURROGATE_HIGH_MIN;
  UInt32 lo = (ucs4 & 0x3ff) + ICEMAN_UNICODE_SURROGATE_LOW_MIN;
  *high_surrogate = (UInt16)hi;
  *low_surrogate = (UInt16)lo;
  return true;
}

CCC_NAMESPACE_END(CCC);

// ------------------------------------------------------------------------
// code test block

#ifdef CODE_TEST1
// convertSurrogatePairToUcs4, convertUcs4ToSurrogatePair test
bool
code_test1()
{
  bool ret = true;
  Iceman::UInt32 x = 0x10000;
  Iceman::UInt16 hi;
  Iceman::UInt16 lo;
  Iceman::UInt16 hi2;
  Iceman::UInt16 lo2;
  Iceman::UInt32 ucs4;
  printf("stage1\n");
  for (hi = ICEMAN_UNICODE_SURROGATE_HIGH_MIN; hi <= ICEMAN_UNICODE_SURROGATE_HIGH_MAX; hi++)
  {
    for (lo = ICEMAN_UNICODE_SURROGATE_LOW_MIN; lo <= ICEMAN_UNICODE_SURROGATE_LOW_MAX; lo++)
    {
      ucs4 = Iceman::Unicode::convertSurrogatePairToUcs4(hi, lo);
      // printf("UTF16 hi:%04x lo:%04x -> ucs4:%08x\n", hi, lo, ucs4);
      if (x != ucs4)
      {
	fprintf(stderr, "ERROR: UTF16 hi:%04x lo:%04x -> ucs4:%08x. ucs4 should be %08x\n", hi, lo, ucs4, x);
	ret = false;
      }
      else
      {
	bool p = Iceman::Unicode::convertUcs4ToSurrogatePair(ucs4, &hi2, &lo2);
	if (p)
	{
	  if (!((hi == hi2) && (lo == lo2)))
	  {
	    fprintf(stderr, "ERROR: Iceman::Unicode::convertUcs4ToSurrogatePair(%08x, &hi2, &lo2) -> hi2:%04x lo2:%04x. should be hi:%04x lo:%04x\n", ucs4, hi2, lo2, hi, lo);
	    ret = false;
	  }
	}
	else
	{
	  fprintf(stderr, "ERROR: Iceman::Unicode::convertUcs4ToSurrogatePair(%08x, &hi2, &lo2) returns false.\n", ucs4);
	  ret = false;
	}
      }
      x++;
    }
  }

  printf("stage2\n");
  ucs4 = 0;
  for (;;)
  {
    if ((ucs4 & 0xfffffff) == 0)
    {
      printf("%08x\n", ucs4);
    }
    bool p = Iceman::Unicode::convertUcs4ToSurrogatePair(ucs4, &hi, &lo);
    if ((ucs4 <= 0xffff) || (ucs4 > 0x10ffff))
    {
      if (p == true)
      {
	fprintf(stderr, "ERROR: Iceman::Unicode::convertUcs4ToSurrogatePair(%08x, &hi, &lo) returns true\n", ucs4);
	ret = false;
      }
    }
    else
    {
      if (p == false)
      {
	fprintf(stderr, "ERROR: Iceman::Unicode::convertUcs4ToSurrogatePair(%08x, &hi, &lo) returns false\n", ucs4);
	ret = false;
      }
    }
    if (ucs4++ == 0xffffffff)
    {
      break;
    }
  }
  
  printf("stage3\n");
  hi = 0;
  for (;;)
  {
    if ((hi & 0x0fff) == 0)
    {
      printf("%04x\n", hi);
    }
    lo = 0;
    for (;;)
    {
      Iceman::UInt32 ucs4 = Iceman::Unicode::convertSurrogatePairToUcs4(hi, lo);
      if ((0xd800 <= hi) && (hi <= 0xdbff) &&
	  (0xdc00 <= lo) && (lo <= 0xdfff))
      {
	if (ucs4 == 0)
	{
	  fprintf(stderr, "ERROR: Iceman::Unicode::convertSurrogatePairToUcs4(%04x, %04x) returns 0.\n", hi, lo);
	  ret = false;
	}
      }
      else
      {
	if (ucs4 != 0)
	{
	  fprintf(stderr, "ERROR: Iceman::Unicode::convertSurrogatePairToUcs4(%04x, %04x) returns %08x.\n", hi, lo, ucs4);
	  ret = false;
	}
      }
      if (lo++ == 0xffff)
      {
	break;
      }
    }
    if (hi++ == 0xffff)
    {
      break;
    }
  }
  return ret;
}

int
main()
{
  if (!code_test1())
  {
    return -1;
  }
  return 0;
}
#endif /* CODE_TEST1 */
