﻿// @@DISTHDR@@
// $Id$

#ifndef INCLUDE_ccc_iceman_Unicode_h
#define INCLUDE_ccc_iceman_Unicode_h

#include <ccc/base/base.h>

CCC_NAMESPACE_START(CCC);

#define ICEMAN_UNICODE_SP			0x0020u		// space
#define ICEMAN_UNICODE_FULL_STOP		0x002eu		// period
#define ICEMAN_UNICODE_NBSP			0x00a0u		// no-break space
#define ICEMAN_UNICODE_ZESP			0x200bu		// zero width space
#define ICEMAN_UNICODE_IDSP			0x3000u		// ideographic space
#define ICEMAN_UNICODE_IDEOGRAPHIC_FULL_STOP	0x3002u
#define ICEMAN_UNICODE_ZWNBSP			0xfeffu		// zero width no-break space
#define ICEMAN_UNICODE_I_ZWNBSP			0xfffeu		// Illegal: inverted ZWNBSP
#define ICEMAN_UNICODE_I_ZWNBSP_32		0xfffe0000u	// Illegal: inverted ZWNBSP (32bit)
#define ICEMAN_UNICODE_SNC			0xffffu		// special non-character value
// surrogates pair
#define ICEMAN_UNICODE_SURROGATE_HIGH_MIN	0xd800u
#define ICEMAN_UNICODE_SURROGATE_HIGH_MAX	0xdbffu
#define ICEMAN_UNICODE_SURROGATE_LOW_MIN	0xdc00u
#define ICEMAN_UNICODE_SURROGATE_LOW_MAX	0xdfffu

#define ICEMAN_UNICODE_UTF16_MAX		0x0010ffffu
#define ICEMAN_UNICODE_UTF32_MAX		0x0010ffffu

class Unicode
{
 public:
  // for to handle unicode surrogates pair
  static UInt32 convertSurrogatePairToUcs4(UInt16 high_surrogate, UInt16 low_surrogate);
  static bool convertUcs4ToSurrogatePair(UInt32 ucs4, UInt16* high_surrogate, UInt16* low_surrogate);
  static bool highSurrogateP(UInt16 hi)
  {
    return ((ICEMAN_UNICODE_SURROGATE_HIGH_MIN <= hi) && (hi <= ICEMAN_UNICODE_SURROGATE_HIGH_MAX));
  }
  static bool lowSurrogateP(UInt16 lo)
  {
    return ((ICEMAN_UNICODE_SURROGATE_LOW_MIN <= lo) && (lo <= ICEMAN_UNICODE_SURROGATE_LOW_MAX));
  }
};
  
CCC_NAMESPACE_END(CCC);

#endif /* INCLUDE_ccc_iceman_Unicode_h */
