﻿// $Id$

#include <ccc/iceman/UnivString.h>
#include <ccc/base/StringOFlow.h>
#include <ccc/base/StringIFlow.h>
#include <ccc/base/CompositIFilter.h>
#include <ccc/base/Conveyer.h>

CCC_NAMESPACE_START(CCC);

void
UnivString::clear()
{
  ceid = CEID_NULL;
  b_str = 0;
  d_str = 0;
  w_str = 0;
}

UnivString::UnivString(const UnivString& us)
{
  clear();
  ceid = us.ceid;
  if (us.b_str)
  {
    b_str = new BString(us.b_str);
  }
  else if (us.d_str)
  {
    d_str = new DString(us.d_str);
  }
  else if (us.w_str)
  {
    w_str = new WString(us.w_str);
  }
}

UnivString::UnivString(CeId ceid, const BString& b_str)
{
  clear();
  UnivString::ceid = ceid;
  UnivString::b_str = new BString(b_str);
}

UnivString::UnivString(CeId ceid, const DString& d_str)
{
  clear();
  UnivString::ceid = ceid;
  UnivString::d_str = new DString(d_str);
}

UnivString::UnivString(CeId ceid, const WString& w_str)
{
  clear();
  UnivString::ceid = ceid;
  UnivString::w_str = new WString(w_str);
}

UnivString::UnivString(CeId ceid, const Int8* str)
{
  clear();
  UnivString::ceid = ceid;
  UnivString::b_str = new BString(str);
}

UnivString::UnivString(CeId ceid, const UInt16* str)
{
  clear();
  UnivString::ceid = ceid;
  UnivString::d_str = new DString(str);
}

UnivString::UnivString(CeId ceid, const UInt32* str)
{
  clear();
  UnivString::ceid = ceid;
  UnivString::w_str = new WString(str);
}

UnivString::UnivString(CeId ceid, const Int8* str, Size len)
{
  clear();
  UnivString::ceid = ceid;
  UnivString::b_str = new BString(str, len);
}

UnivString::UnivString(CeId ceid, const UInt16* str, Size len)
{
  clear();
  UnivString::ceid = ceid;
  UnivString::d_str = new DString(str, len);
}

UnivString::UnivString(CeId ceid, const UInt32* str, Size len)
{
  clear();
  UnivString::ceid = ceid;
  UnivString::w_str = new WString(str, len);
}

UnivString::~UnivString()
{
  delete b_str;
  delete d_str;
  delete w_str;
}

#if 0
UnivString*
UnivString::convert(CeId to_ceid)
{
  CompositIFilter* cf = createCompositIFilter(ceid, to_ceid);
  if (!cf)
  {
    return 0;
  }
  IFlow* iflow = 0;
  if (b_str)
  {
    iflow = StringIFlow<Int8>(b_str);
  }
  else if (d_str)
  {
    iflow = StringIFlow<UInt16>(d_str);
  }
  else if (w_str)
  {
    iflow = StringIflow<UInt32>(w_str);
  }
  else
  {
    delete cf;
    return 0;
  }
  

  delete iflow;
}
#endif

BString*
UnivString::convertToBString(CeId to_ceid) const
{
  CompositIFilter* cf = Iceman::createCompositIFilter(ceid, to_ceid);
  if (!cf)
  {
    return 0;
  }
  IFlow* in = 0;
  if (b_str)
  {
    in = new StringIFlow<Int8>(b_str);
  }
  else if (d_str)
  {
    in = new StringIFlow<UInt16>(d_str);
  }
  else if (w_str)
  {
    in = new StringIFlow<UInt32>(w_str);
  }
  else
  {
    delete cf;
    return 0;
  }
  BString* ret = new BString();
  OFlow* out = new StringOFlow<Int8>(ret);
  
  cf->setSrc(in);
  Conveyer conv;
  conv.setSrc(cf);
  conv.setDest(out);
  try
  {
    conv.carry();
  }
  catch (IOException /* ioe */)
  {
    delete ret;
    ret = 0;
  }
  delete in;
  delete out;
  delete cf;
  return ret;
}

DString*
UnivString::convertToDString(CeId to_ceid) const
{
  CompositIFilter* cf = Iceman::createCompositIFilter(ceid, to_ceid);
  if (!cf)
  {
    return 0;
  }
  IFlow* in = 0;
  if (b_str)
  {
    in = new StringIFlow<Int8>(b_str);
  }
  else if (d_str)
  {
    in = new StringIFlow<UInt16>(d_str);
  }
  else if (w_str)
  {
    in = new StringIFlow<UInt32>(w_str);
  }
  else
  {
    delete cf;
    return 0;
  }
  DString* ret = new DString();
  OFlow* out = new StringOFlow<UInt16>(ret);
  
  cf->setSrc(in);
  Conveyer conv;
  conv.setSrc(cf);
  conv.setDest(out);
  try
  {
    conv.carry();
  }
  catch (IOException /* ioe */)
  {
    delete ret;
    ret = 0;
  }
  delete in;
  delete out;
  delete cf;
  return ret;
}

WString*
UnivString::convertToWString(CeId to_ceid) const
{
  CompositIFilter* cf = Iceman::createCompositIFilter(ceid, to_ceid);
  if (!cf)
  {
    return 0;
  }
  IFlow* in = 0;
  if (b_str)
  {
    in = new StringIFlow<Int8>(b_str);
  }
  else if (d_str)
  {
    in = new StringIFlow<UInt16>(d_str);
  }
  else if (w_str)
  {
    in = new StringIFlow<UInt32>(w_str);
  }
  else
  {
    delete cf;
    return 0;
  }
  WString* ret = new WString();
  OFlow* out = new StringOFlow<UInt32>(ret);
  
  cf->setSrc(in);
  Conveyer conv;
  conv.setSrc(cf);
  conv.setDest(out);
  try
  {
    conv.carry();
  }
  catch (IOException /* ioe */)
  {
    delete ret;
    ret = 0;
  }
  delete in;
  delete out;
  delete cf;
  return ret;
}

CCC_NAMESPACE_END(CCC);
