﻿// $Id$

#ifndef INCLUDE_ccc_iceman_UnivString_h
#define INCLUDE_ccc_iceman_UnivString_h

#include <ccc/base/TString.h>
#include <ccc/iceman/Iceman.h>

CCC_NAMESPACE_START(CCC);

/*!
 * 様々な文字セットエンコーディングの文字列を
 * 統一的に表現するためのクラスです。
 * 指定したエンコーディングに変換してデータを
 * 取り出す機能があります。
 */
class UnivString
{
  /*!
   * 文字コード
   */
  CeId ceid;
  /*!
   * \brief BString文字列データ
   *
   * 使用されない場合には0にセットされます。
   */
  BString* b_str;
  /*!
   * \brief DString文字列データ
   *
   * 使用されない場合には0にセットされます。
   */
  DString* d_str;
  /*!
   * \brief WString文字列データ
   *
   * 使用されない場合には0にセットされます。
   */
  WString* w_str;

 private:
  void clear();

 public:
  /*!
   * コピーコンストラクタ<br>
   * 引数で渡したUnivStringの複製を作製します。
   */
  UnivString(const UnivString& us);
  /*!
   * コンストラクタ<br>
   * 引数で与えた文字列は、このオブジェクト内にコピーされたものが保持されます。
   * BStringで初期化します。
   * \param ceid 文字セットエンコーディング
   * \param b_str 文字列
   */
  UnivString(CeId ceid, const BString& b_str);
  /*!
   * コンストラクタ<br>
   * 引数で与えた文字列は、このオブジェクト内にコピーされたものが保持されます。
   * DStringで初期化します。
   * \param ceid 文字セットエンコーディング
   * \param d_str 文字列
   */
  UnivString(CeId ceid, const DString& d_str);
  /*!
   * コンストラクタ<br>
   * 引数で与えた文字列は、このオブジェクト内にコピーされたものが保持されます。
   * WStringで初期化します。
   * \param ceid 文字セットエンコーディング
   * \param w_str 文字列
   */
  UnivString(CeId ceid, const WString& w_str);
  /*!
   * コンストラクタ<br>
   * 引数で与えた文字列は、このオブジェクト内にコピーされたものが保持されます。
   * ヌルで終端されたInt8型の文字列で初期化します。
   * \param ceid 文字セットエンコーディング
   * \param str ヌルで終端された文字列
   */
  UnivString(CeId ceid, const Int8* str);
  /*!
   * コンストラクタ<br>
   * 引数で与えた文字列は、このオブジェクト内にコピーされたものが保持されます。
   * ヌルで終端されたUInt16型の文字列で初期化します。
   * \param ceid 文字セットエンコーディング
   * \param str ヌルで終端された文字列
   */
  UnivString(CeId ceid, const UInt16* str);
  /*!
   * コンストラクタ<br>
   * 引数で与えた文字列は、このオブジェクト内にコピーされたものが保持されます。
   * ヌルで終端されたUInt32型の文字列で初期化します。
   * \param ceid 文字セットエンコーディング
   * \param str ヌルで終端された文字列
   */
  UnivString(CeId ceid, const UInt32* str);
  /*!
   * コンストラクタ<br>
   * 引数で与えた文字列は、このオブジェクト内にコピーされたものが保持されます。
   * Int8型の文字列で初期化します。
   * \param ceid 文字セットエンコーディング
   * \param str ヌルで終端された文字列
   * \param len 文字列の長さ
   */
  UnivString(CeId ceid, const Int8* str, Size len);
  /*!
   * コンストラクタ<br>
   * 引数で与えた文字列は、このオブジェクト内にコピーされたものが保持されます。
   * UInt16型の文字列で初期化します。
   * \param ceid 文字セットエンコーディング
   * \param str ヌルで終端された文字列
   * \param len 文字列の長さ
   */
  UnivString(CeId ceid, const UInt16* str, Size len);
  /*!
   * コンストラクタ<br>
   * 引数で与えた文字列は、このオブジェクト内にコピーされたものが保持されます。
   * UInt32型の文字列で初期化します。
   * \param ceid 文字セットエンコーディング
   * \param str ヌルで終端された文字列
   * \param len 文字列の長さ
   */
  UnivString(CeId ceid, const UInt32* str, Size len);
  /*!
   * デストラクタ
   */
  ~UnivString();

  /* アクセサ */
  /*!
   * 保持している文字セットエンコーディングを得ます。
   * \return 保持している文字セットエンコーディング
   */
  CeId getCeId() const
  {
    return ceid;
  }
  /*!
   * 内部に保持しているBStringを返します。
   * \return BString
   */
  const BString* bString() const
  {
    return b_str;
  }
  /*!
   * 内部に保持しているDStringを返します。
   * \return DString
   */
  const DString* dString() const
  {
    return d_str;
  }
  /*!
   * 内部に保持しているWStringを返します。
   * \return WString
   */
  const WString* wString() const
  {
    return w_str;
  }
  /* コンバータ */
#if 0
  /* TODO:
   * このメソッドは現在のiceman機能では実現困難
   * CeIdから何バイト文字の文字セットエンコーディング
   * かを調べるための機能を追加した後に実装する予定
   */
  /*!
   * 指定した文字セットエンコーディングに変換したUnivStringを得ます。
   * 返り値のオブジェクトは呼び出し側が使い終わったら明示的に削除する必要があります。
   * \param to_ceid 変換先の文字セットエンコーディング
   * \retval 非0 変換結果
   * \retval 0 指定された出力に変換できません。
   */
  UnivString* convert(CeId to_ceid);
#endif
  /*!
   * 指定した文字セットエンコーディングに変換したBStringを得ます。
   * 返り値のオブジェクトは呼び出し側が使い終わったら明示的に削除する必要があります。
   * \param to_ceid 変換先の文字セットエンコーディング
   * \retval 非0 変換結果の文字列
   * \retval 0 指定された出力に変換できません。
   */
  BString* convertToBString(CeId to_ceid) const;
  /*!
   * 指定した文字セットエンコーディングに変換したDStringを得ます。
   * 返り値のオブジェクトは呼び出し側が使い終わったら明示的に削除する必要があります。
   * \param to_ceid 変換先の文字セットエンコーディング
   * \retval 非0 変換結果の文字列
   * \retval 0 指定された出力に変換できません。
   */
  DString* convertToDString(CeId to_ceid) const;
  /*!
   * 指定した文字セットエンコーディングに変換したWStringを得ます。
   * 返り値のオブジェクトは呼び出し側が使い終わったら明示的に削除する必要があります。
   * \param to_ceid 変換先の文字セットエンコーディング
   * \retval 非0 変換結果の文字列
   * \retval 0 指定された出力に変換できません。
   */
  WString* convertToWString(CeId to_ceid) const;
};

CCC_NAMESPACE_END(CCC);

#endif /* INCLUDE_ccc_iceman_UnivString_h */
