﻿// $Id$

#include <assert.h>
#include <string.h>
#include <ccc/iceman/Utf16String.h>
#include <ccc/iceman/Iceman.h>
#include <ccc/base/FixedMemIFlow.h>
#include <ccc/base/StringIFlow.h>
#include <ccc/base/StringOFlow.h>
#include <ccc/base/Conveyer.h>
#include <ccc/base/CompositIFilter.h>

CCC_NAMESPACE_START(CCC)

Utf16String::Utf16String(const char* utf8)
{
  CCC::Utf8String from(utf8);
  Iceman::convertToDString(CCC::CEID_UTF8, CCC::CEID_UTF16N, &from, this);
}

Utf16String::Utf16String(const Utf8String& utf8)
{
  assign(utf8);
}

Utf16String::Utf16String(const Utf8String* utf8)
{
  assign(utf8);
}

Utf16String::Utf16String()
{
}

Utf16String::Utf16String(const UInt16* c_str)
  : DString(c_str)
{
}

Utf16String::Utf16String(const UInt16* c_str, Size size)
  : DString(c_str, size)
{
}

Utf16String::Utf16String(const DSubString& ss)
  : DString(ss)
{
}

Utf16String::Utf16String(const Utf16String& ss)
  : DString(ss)
{
}

Utf16String::Utf16String(const DSubString* ss)
  : DString(ss)
{
}

Utf16String::Utf16String(const Utf16String* ss)
  : DString(ss)
{
}

Utf16String::Utf16String(CeId from_ceid, const BString* src)
{
  assign(from_ceid, src);
}

Utf16String::Utf16String(CeId from_ceid, const DString* src)
{
  assign(from_ceid, src);
}

Utf16String::Utf16String(CeId from_ceid, const WString* src)
{
  assign(from_ceid, src);
}

void
Utf16String::convertToUtf8(Utf8String* out)
{
  Iceman::convertToBString(CCC::CEID_UTF16N, CCC::CEID_UTF8N, this, out);
}

void
Utf16String::assign(const Utf8String& utf8)
{
  Iceman::convertToDString(CCC::CEID_UTF8, CCC::CEID_UTF16N, &utf8, this);
}

void
Utf16String::assign(const Utf8String* utf8)
{
  Iceman::convertToDString(CCC::CEID_UTF8, CCC::CEID_UTF16N, utf8, this);
}

void
Utf16String::assign(const char* utf8)
{
  Utf8String tmp(utf8);
  Iceman::convertToDString(CCC::CEID_UTF8, CCC::CEID_UTF16N, &tmp, this);
}

void
Utf16String::assign(CeId from_ceid, const BString* src)
{
  Iceman::convertToDString(from_ceid, CCC::CEID_UTF16N, src, this);
}

void
Utf16String::assign(CeId from_ceid, const DString* src)
{
  Iceman::convertToDString(from_ceid, CCC::CEID_UTF16N, src, this);
}

void
Utf16String::assign(CeId from_ceid, const WString* src)
{
  Iceman::convertToDString(from_ceid, CCC::CEID_UTF16N, src, this);
}

void
Utf16String::add(const Utf8String& utf8)
{
  Utf16String tmp;
  Iceman::convertToDString(CCC::CEID_UTF8, CCC::CEID_UTF16N, &utf8, &tmp);
  add(tmp);
}

void
Utf16String::add(const Utf8String* utf8)
{
  Utf16String tmp;
  Iceman::convertToDString(CCC::CEID_UTF8, CCC::CEID_UTF16N, utf8, &tmp);
  add(tmp);
}

void
Utf16String::add(CeId from_ceid, const BString* src)
{
  Utf16String tmp;
  Iceman::convertToDString(from_ceid, CCC::CEID_UTF16N, src, &tmp);
  add(tmp);
}

void
Utf16String::add(CeId from_ceid, const DString* src)
{
  Utf16String tmp;
  Iceman::convertToDString(from_ceid, CCC::CEID_UTF16N, src, &tmp);
  add(tmp);
}

void
Utf16String::add(CeId from_ceid, const WString* src)
{
  Utf16String tmp;
  Iceman::convertToDString(from_ceid, CCC::CEID_UTF16N, src, &tmp);
  add(tmp);
}

CCC_NAMESPACE_END(CCC)
