﻿// $Id$

#ifndef INCLUDE_Utf16String_h
#define INCLUDE_Utf16String_h

#include <ccc/base/base.h>
#include <ccc/base/TString.h>
#include <ccc/iceman/Iceman.h>
#include <ccc/iceman/Utf8String.h>

CCC_NAMESPACE_START(CCC)

/*!
 * UTF16のネイティブエンディアンによる文字列を表現します。
 */
class Utf16String
  : public DString
{
 public:
  /*!
   * コンストラクタ
   * \param utf8 utf-8エンコーディングのC言語形式の文字列
   */
  Utf16String(const char* utf8);
  /*!
   * コンストラクタ
   * \param utf8 utf-8エンコーディングの文字列
   */
  Utf16String(const Utf8String& utf8);
  /*!
   * コンストラクタ
   * \param utf8 utf-8エンコーディングの文字列
   */
  Utf16String(const Utf8String* utf8);
  /*!
   * コンストラクタ
   */
  Utf16String();
  /*!
   * コンストラクタ<br>
   * 引数で渡した文字列の内容で生成する文字列の内容が初期化されます。
   * \param c_str ヌルで終端された文字列へのポインタ
   */
  Utf16String(const UInt16* c_str);
  /*!
   * コンストラクタ<br>
   * 引数で渡した文字列の内容で生成する文字列の内容が初期化されます。
   * \param c_str 文字列へのポインタ
   * \param size 文字数
   */
  Utf16String(const UInt16* c_str, Size size);
  /*!
   * コンストラクタ<br>
   * 引数で渡した部分文字列の内容で生成する文字列の内容が初期化されます。
   * \param ss 部分文字列
   */
  Utf16String(const DSubString& ss);
  /*!
   * コピーコンストラクタ
   * \param ss コピー元
   */
  Utf16String(const Utf16String& ss);
  /*!
   * コンストラクタ<br>
   * 引数で渡した部分文字列の内容で生成する文字列の内容が初期化されます。
   * \param ss 部分文字列へのポインタ
   */
  Utf16String(const DSubString* ss);
  /*!
   * コンストラクタ<br>
   * 引数で渡した文字列の内容で生成する文字列の内容が初期化されます。
   * \param ss 文字列へのポインタ
   */
  Utf16String(const Utf16String* ss);
  /*!
   * コンストラクタ<br>
   * \param from_ceid 変換元文字セットエンコーディング
   * \param src 変換元文字列
   */
  Utf16String(CeId from_ceid, const BString* src);
  /*!
   * コンストラクタ<br>
   * \param from_ceid 変換元文字セットエンコーディング
   * \param src 変換元文字列
   */
  Utf16String(CeId from_ceid, const DString* src);
  /*!
   * コンストラクタ<br>
   * \param from_ceid 変換元文字セットエンコーディング
   * \param src 変換元文字列
   */
  Utf16String(CeId from_ceid, const WString* src);
  using DString::assign;
  using DString::add;
  void add(const UInt16 c)
  {
    DString::add(c);
  }
  void assign(const DSubString& ss)
  {
    DString::assign(ss);
  }
  /*!
   * utf-8nでエンコーディングされた文字列に変換します。
   * \param to 変換先
   */
  void convertToUtf8(Utf8String* to);
  /*!
   * 文字列の代入
   * \param utf8 utf-8エンコーディングの文字列
   */
  void assign(const Utf8String& utf8);
  /*!
   * 文字列の代入
   * \param utf8 utf-8エンコーディングの文字列
   */
  void assign(const Utf8String* utf8);
  /*!
   * 文字列の代入
   * \param utf8 utf-8エンコーディングの文字列
   */
  void assign(const char* utf8);
  /*!
   * 文字列の代入
   * \param from_ceid 変換元文字セットエンコーディング
   * \param src 変換元文字列
   */
  void assign(CeId from_ceid, const BString* src);
  /*!
   * 文字列の代入
   * \param from_ceid 変換元文字セットエンコーディング
   * \param src 変換元文字列
   */
  void assign(CeId from_ceid, const DString* src);
  /*!
   * 文字列の代入
   * \param from_ceid 変換元文字セットエンコーディング
   * \param src 変換元文字列
   */
  void assign(CeId from_ceid, const WString* src);
  /*!
   * 文字列の追加
   * \param utf8 utf-8エンコーディングの文字列
   */
  void add(const Utf8String& utf8);
  /*!
   * 文字列の追加
   * \param utf8 utf-8エンコーディングの文字列
   */
  void add(const Utf8String* utf8);
  /*!
   * 文字列の追加
   * \param utf8 utf-8エンコーディングの文字列
   */
  void add(const char* utf8);
  /*!
   * 文字列の追加
   * \param from_ceid 変換元文字セットエンコーディング
   * \param src 変換元文字列
   */
  void add(CeId from_ceid, const BString* src);
  /*!
   * 文字列の追加
   * \param from_ceid 変換元文字セットエンコーディング
   * \param src 変換元文字列
   */
  void add(CeId from_ceid, const DString* src);
  /*!
   * 文字列の追加
   * \param from_ceid 変換元文字セットエンコーディング
   * \param src 変換元文字列
   */
  void add(CeId from_ceid, const WString* src);
};

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_Utf16String_h */
