﻿// $Id$

#include <ccc/iceman/Utf7.h>
#include <ccc/iceman/Iceman.h>
#include <ccc/iceman/Unicode.h>

CCC_NAMESPACE_START(CCC);

// ------------------------------------------------------------------------
// class Utf7

// ============================================================
// b64set table
//
// *Set D : directly encoded characters
//   ABCDEFGHIJKLMNOPQRSTUVWXYZ
//   abcdefghijklmnopqrstuvwxyz
//   0123456789'(),-./:?
//
// *Set O : optional direct charactes
//   !"#$%&*;<=>@[]^_`{|}
//
// *Set B : modified base 64
//
static UInt8 b64set[256] =
{
   0,  0,  0,  0,  0,  0,  0,  0,
   0, 24, 24,  0,  0, 24,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,
  24, 18, 18, 18, 18, 18, 18, 25,
  25, 25, 18,  4, 25, 25, 25, 29,
  29, 29, 29, 29, 29, 29, 29, 29,
  29, 29, 25, 18, 18, 18, 18, 25,
  18, 29, 29, 29, 29, 29, 29, 29,
  29, 29, 29, 29, 29, 29, 29, 29,
  29, 29, 29, 29, 29, 29, 29, 29,
  29, 29, 29, 18,  0, 18, 18, 18,
  18, 29, 29, 29, 29, 29, 29, 29,
  29, 29, 29, 29, 29, 29, 29, 29,
  29, 29, 29, 29, 29, 29, 29, 29,
  29, 29, 29, 18, 18, 18,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,
};
// this b64set table was generated by following code.
#if 0
#include <stdio.h>

static char b64set[256];

enum B64Set
{
  B64SET_D = 1,
  B64SET_O = 2,
  B64SET_B = 4,
  B64SET_DIRECT = 8,
  B64SET_ODIRECT = 16,
};

void
init_table()
{
  for (int i = 0; i < 256; i++)
  {
    b64set[i] = 0;
  }
  static char set_d[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789'(),-./:?";
  static char set_o[] = "!\"#$%&*;<=>@[]^_`{|}";
  static char set_b[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
  static char set_c[] = " \011\012\015";
  char* p;
  p = set_d;
  while (*p)
  {
    b64set[*p] |= B64SET_D;
    b64set[*p] |= B64SET_DIRECT;
    b64set[*p] |= B64SET_ODIRECT;
    p++;
  }
  p = set_o;
  while (*p)
  {
    b64set[*p] |= B64SET_O;
    b64set[*p] |= B64SET_ODIRECT;
    p++;
  }
  p = set_b;
  while (*p)
  {
    b64set[*p] |= B64SET_B;
    p++;
  }
  p = set_c;
  while (*p)
  {
    b64set[*p] |= B64SET_DIRECT;
    b64set[*p] |= B64SET_ODIRECT;
    p++;
  }
}

int
main()
{
  init_table();
  printf("// b64set table\n");
  printf("static char b64set[256] =\n");
  printf("{\n  ");
  for (int i = 0; i < 256; i++)
  {
    printf("%2i", b64set[i]);
    if ((i + 1) % 8 == 0 && i != 0)
    {
      printf(",");
      if (i != 255)
      {
	printf("\n  ");
      }
    }
    else
    {
      printf(", ");
    }
  }
  printf("\n};\n");
}
#endif /* 0 */
// ============================================================

bool
Utf7::setDP(UInt16 c)
{
  return ((c < 0xff) && (b64set[(UInt8)c] & B64SET_D));
}

bool
Utf7::setOP(UInt16 c)
{
  return ((c < 0xff) && (b64set[(UInt8)c] & B64SET_O));
}

bool
Utf7::setBP(UInt16 c)
{
  return ((c < 0xff) && (b64set[(UInt8)c] & B64SET_B));
}

bool
Utf7::directP(UInt16 c)
{
  return ((c < 0xff) && (b64set[(UInt8)c] & B64SET_DIRECT));
}

bool
Utf7::optionDirectP(UInt16 c)
{
  return ((c < 0xff) && (b64set[(UInt8)c] & B64SET_ODIRECT));
}

CCC_NAMESPACE_END(CCC);
