﻿// $Id$

#ifndef INCLUDE_ccc_iceman_Utf7_h
#define INCLUDE_ccc_iceman_Utf7_h

#include <ccc/base/base.h>

CCC_NAMESPACE_START(CCC);

/*!
 * UTF7: RFC2152
 */
class Utf7
{
  enum B64Set
  {
    B64SET_D = 1,	// directly encoded characters
    B64SET_O = 2,	// optional direct characters
    B64SET_B = 4,	// modified base 64 charactes
    B64SET_DIRECT = 8,		// direct
    B64SET_ODIRECT = 16,	// optional direct
  };
 public:
  static bool setDP(UInt16 c);
  static bool setOP(UInt16 c);
  static bool setBP(UInt16 c);
  static bool directP(UInt16 c);
  static bool optionDirectP(UInt16 c);
};

CCC_NAMESPACE_END(CCC);

#endif /* INCLUDE_ccc_iceman_Utf7_h */
