﻿// $Id$

#include <ccc/iceman/Utf8String.h>
#include <ccc/iceman/Iceman.h>
#include <ccc/base/FixedMemIFlow.h>
#include <ccc/base/StringIFlow.h>
#include <ccc/base/StringOFlow.h>
#include <ccc/base/Conveyer.h>
#include <ccc/base/CompositIFilter.h>
#include <ccc/iceman/Utf16String.h>

CCC_NAMESPACE_START(CCC)

Utf8String::Utf8String(const Utf16String& utf16)
{
  assign(utf16);
}

Utf8String::Utf8String(const Utf16String* utf16)
{
  assign(utf16);
}

Utf8String::Utf8String()
{
}

Utf8String::Utf8String(const char* c_str)
  : BString(c_str)
{
}

Utf8String::Utf8String(const char* c_str, Size size)
  : BString(c_str, size)
{
}

Utf8String::Utf8String(const BSubString& ss)
  : BString(ss)
{
}

Utf8String::Utf8String(const Utf8String& ss)
  : BString(ss)
{
}

Utf8String::Utf8String(const BSubString* ss)
  : BString(ss)
{
}

Utf8String::Utf8String(const Utf8String* ss)
  : BString(ss)
{
}

Utf8String::Utf8String(CeId from_ceid, const BString* src)
{
  Iceman::convertToBString(from_ceid, CCC::CEID_UTF8N, src, this);
}

Utf8String::Utf8String(CeId from_ceid, const DString* src)
{
  Iceman::convertToBString(from_ceid, CCC::CEID_UTF8N, src, this);
}

Utf8String::Utf8String(CeId from_ceid, const WString* src)
{
  Iceman::convertToBString(from_ceid, CCC::CEID_UTF8N, src, this);
}

void
Utf8String::convertToUtf16(Utf16String* out)
{
  Iceman::convertToDString(CCC::CEID_UTF8, CCC::CEID_UTF16N, this, out);
}

void
Utf8String::assign(const Utf16String& utf16)
{
  Iceman::convertToBString(CCC::CEID_UTF16, CCC::CEID_UTF8N, &utf16, this);
}

void
Utf8String::assign(const Utf16String* utf16)
{
  Iceman::convertToBString(CCC::CEID_UTF16, CCC::CEID_UTF8N, utf16, this);
}

void
Utf8String::assign(CeId from_ceid, const BString* src)
{
  Iceman::convertToBString(from_ceid, CCC::CEID_UTF8N, src, this);
}

void
Utf8String::assign(CeId from_ceid, const DString* src)
{
  Iceman::convertToBString(from_ceid, CCC::CEID_UTF8N, src, this);
}

void
Utf8String::assign(CeId from_ceid, const WString* src)
{
  Iceman::convertToBString(from_ceid, CCC::CEID_UTF8N, src, this);
}

void
Utf8String::add(const Utf16String& utf16)
{
  Utf8String addition;
  Iceman::convertToBString(CCC::CEID_UTF16, CCC::CEID_UTF8N, &utf16, &addition);
  add(addition);
}

void
Utf8String::add(const Utf16String* utf16)
{
  Utf8String addition;
  Iceman::convertToBString(CCC::CEID_UTF16, CCC::CEID_UTF8N, utf16, &addition);
  add(addition);
}

void
Utf8String::add(CeId from_ceid, const BString* src)
{
  Utf8String addition;
  Iceman::convertToBString(from_ceid, CCC::CEID_UTF8N, src, &addition);
  add(addition);
}

void
Utf8String::add(CeId from_ceid, const DString* src)
{
  Utf8String addition;
  Iceman::convertToBString(from_ceid, CCC::CEID_UTF8N, src, &addition);
  add(addition);
}

void
Utf8String::add(CeId from_ceid, const WString* src)
{
  Utf8String addition;
  Iceman::convertToBString(from_ceid, CCC::CEID_UTF8N, src, &addition);
  add(addition);
}

CCC_NAMESPACE_END(CCC)
