﻿// $Id$

#ifndef INCLUDE_Utf8String_h
#define INCLUDE_Utf8String_h

#include <ccc/base/base.h>
#include <ccc/base/TString.h>
#include <ccc/iceman/Iceman.h>

CCC_NAMESPACE_START(CCC)

class Utf16String;

/*!
 * UTF8の文字列を表現します。
 */
class Utf8String
  : public BString
{
 public:
  /*!
   * コンストラクタ
   * \param utf16 utf-16エンコーディングの文字列
   */
  Utf8String(const Utf16String& utf16);
  /*!
   * コンストラクタ
   * \param utf16 utf-16エンコーディングの文字列
   */
  Utf8String(const Utf16String* utf16);
  /*!
   * コンストラクタ
   */
  Utf8String();
  /*!
   * コンストラクタ<br>
   * 引数で渡した文字列の内容で生成する文字列の内容が初期化されます。
   * \param c_str ヌルで終端されたutf-8エンコーディングの文字列へのポインタ
   */
  Utf8String(const char* c_str);
  /*!
   * コンストラクタ<br>
   * 引数で渡した文字列の内容で生成する文字列の内容が初期化されます。
   * \param c_str utf-8エンコーディングの文字列へのポインタ
   * \param size 文字数
   */
  Utf8String(const char* c_str, Size size);
  /*!
   * コンストラクタ<br>
   * 引数で渡した部分文字列の内容で生成する文字列の内容が初期化されます。
   * \param ss 部分文字列
   */
  Utf8String(const BSubString& ss);
  /*!
   * コピーコンストラクタ
   * \param ss コピー元
   */
  Utf8String(const Utf8String& ss);
  /*!
   * コンストラクタ<br>
   * 引数で渡した部分文字列の内容で生成する文字列の内容が初期化されます。
   * \param ss 部分文字列へのポインタ
   */
  Utf8String(const BSubString* ss);
  /*!
   * コンストラクタ<br>
   * 引数で渡した文字列の内容で生成する文字列の内容が初期化されます。
   * \param ss 文字列へのポインタ
   */
  Utf8String(const Utf8String* ss);
  /*!
   * コンストラクタ<br>
   * \param from_ceid 変換元文字セットエンコーディング
   * \param src 変換元文字列
   */
  Utf8String(CeId from_ceid, const BString* src);
  /*!
   * コンストラクタ<br>
   * \param from_ceid 変換元文字セットエンコーディング
   * \param src 変換元文字列
   */
  Utf8String(CeId from_ceid, const DString* src);
  /*!
   * コンストラクタ<br>
   * \param from_ceid 変換元文字セットエンコーディング
   * \param src 変換元文字列
   */
  Utf8String(CeId from_ceid, const WString* src);
  using BString::assign;
  using BString::add;
  void assign(const char* str, Size size)
  {
    BString::assign(str, size);
  }
  /*!
   * utf-16でエンコーディングされた文字列に変換します。
   * \param to 変換先
   */
  void convertToUtf16(Utf16String* to);
  /*!
   * 文字列の代入
   * \param utf16 utf-16エンコーディングの文字列
   */
  void assign(const Utf16String& utf16);
  /*!
   * 文字列の代入
   * \param utf16 utf-16エンコーディングの文字列
   */
  void assign(const Utf16String* utf16);
  /*!
   * 文字列の代入
   * \param from_ceid 変換元文字セットエンコーディング
   * \param src 変換元文字列
   */
  void assign(CeId from_ceid, const BString* src);
  /*!
   * 文字列の代入
   * \param from_ceid 変換元文字セットエンコーディング
   * \param src 変換元文字列
   */
  void assign(CeId from_ceid, const DString* src);
  /*!
   * 文字列の代入
   * \param from_ceid 変換元文字セットエンコーディング
   * \param src 変換元文字列
   */
  void assign(CeId from_ceid, const WString* src);
  /*!
   * 文字列の追加
   * \param utf16 utf-16エンコーディングの文字列
   */
  void add(const Utf16String& utf16);
  /*!
   * 文字列の追加
   * \param utf16 utf-16エンコーディングの文字列
   */
  void add(const Utf16String* utf16);
  /*!
   * 文字列の追加
   * \param from_ceid 変換元文字セットエンコーディング
   * \param src 変換元文字列
   */
  void add(CeId from_ceid, const BString* src);
  /*!
   * 文字列の追加
   * \param from_ceid 変換元文字セットエンコーディング
   * \param src 変換元文字列
   */
  void add(CeId from_ceid, const DString* src);
  /*!
   * 文字列の追加
   * \param from_ceid 変換元文字セットエンコーディング
   * \param src 変換元文字列
   */
  void add(CeId from_ceid, const WString* src);
};

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_Utf8String_h */
