﻿// @@DISTHDR@@
// $Id$

#ifndef INCLUDE_ccc_iceman_XmlDetector_h
#define INCLUDE_ccc_iceman_XmlDetector_h

#include <ccc/iceman/Detector.h>

CCC_NAMESPACE_START(CCC);

class XmlParseError
{
  int err_no;
  const char* msg;
 public:
  XmlParseError(int n, const char* msg)
  {
    err_no = n;
    XmlParseError::msg = msg;
  }
};

class XmlDetector
  : public Detector
{
  enum
  {
    UNKNOWN = 0,
    ONEBYTE,
    BE2BYTE,
    LE2BYTE,
  } in_type;

#ifdef _MSC_VER
  enum
  {
    max_unget_size = 20,
  };
#else
  const static int max_unget_size = 20;
#endif

  char unget_buf[max_unget_size + 1];
  int unget_size;
  IFlow* in;
  char* enc_name;
  
 public:
  XmlDetector();
  ~XmlDetector();
  virtual bool rewind();
  virtual CeId detect(IFlow* in);
  static Detector* createDetector();

 private:
  void clear();
  bool checkEncoding();
  char getChar();
  void ungetChar(char c);
  bool parseXMLDecl();
  bool parseVersionInfo(bool l1_p);
  bool parseS(bool l1_p);
  void parseS();
  bool parseEncodingDecl(bool l1_p);
  bool parseVersionNum();
  void parseEq();
  bool check(char* str, Size len);
  bool parseClassString(char* class_str);
  bool parseEncName();
};

CCC_NAMESPACE_END(CCC);

#endif /* INCLUDE_ccc_iceman_XmlDetector_h */
