﻿/* @@DISTHDR@@ */
/* $Id$ */

/*!
 * \file ces.h
 * \ja
 * このファイルで文字セットエンコーディング名が定義されています。
 * このファイルはいくつかのマクロ定義が行なわれた上で複数回インクルードされます。
 * \ja_end
 * \en
 * Charset Encoding Names are definded in this file.<br>
 * This file is included multiple times with defined some macros.
 * \en_end
 */

#undef ICEMAN_CE1
#undef ICEMAN_CE2
#undef ICEMAN_CE3
#undef ICEMAN_CE4
#undef ICEMAN_CE5
#undef ICEMAN_CE6
#undef ICEMAN_CE7
#undef ICEMAN_CE8
#undef ICEMAN_CE9
#undef ICEMAN_CE10
#undef ICEMAN_CE11
#undef ICEMAN_CEA

/*!
 * \def ICEMAN_CE1(ce_id, g, nid, s1)
 * \param ce_id charset encoding ID - CeId.
 * \param g  charset encoding group ID - CeGId.
 * \param nid when the g != CEGID_NOGROUP, corresponding netive charset encoding ID - CeId.
 * \param s1 a charset encoding name string.
 */
/*!
 * \def ICEMAN_CE2(ce_id, g, nid, s1, s2)
 * \param ce_id charset encoding ID - CeId
 * \param g  charset encoding group ID - CeGId.
 * \param nid when the g != CEGID_NOGROUP, corresponding netive charset encoding ID - CeId.
 * \param s1 a charset encoding name string.
 * \param s2 an aliase charset encoding name string.
 */
/*!
 * \def ICEMAN_CE3(ce_id, g, nid, s1, s2, s3)
 * \param ce_id charset encoding ID - CeId
 * \param g  charset encoding group ID - CeGId
 * \param nid when the g != CEGID_NOGROUP, corresponding netive charset encoding ID - CeId
 * \param s1 a charset encoding name string.
 * \param s2 an aliase charset encoding name string.
 * \param s3 an aliase charset encoding name string.
 */
/*!
 * \def ICEMAN_CE4(ce_id, g, nid, s1, s2, s3, s4)
 * \param ce_id charset encoding ID - CeId
 * \param g  charset encoding group ID - CeGId
 * \param nid when the g != CEGID_NOGROUP, corresponding netive charset encoding ID - CeId
 * \param s1 a charset encoding name string.
 * \param s2 an aliase charset encoding name string.
 * \param s3 an aliase charset encoding name string.
 * \param s4 an aliase charset encoding name string.
 */
/*!
 * \def ICEMAN_CEA(ce_id, ce_id_a)
 * \param ce_id charset encoding ID
 * \param ce_id_a aliase of the charset encoding ID
 */

/* for enum definition */
#ifdef CCC_ICEMAN_CEID_ENUM_DEF
#  define ICEMAN_CE1(ce_id, g, nid, s1) ce_id,
#  define ICEMAN_CE2(ce_id, g, nid, s1, s2) ce_id,
#  define ICEMAN_CE3(ce_id, g, nid, s1, s2, s3) ce_id,
#  define ICEMAN_CE4(ce_id, g, nid, s1, s2, s3, s4) ce_id,
#  define ICEMAN_CE5(ce_id, g, nid, s1, s2, s3, s4, s5) ce_id,
#  define ICEMAN_CE6(ce_id, g, nid, s1, s2, s3, s4, s5, s6) ce_id,
#  define ICEMAN_CE7(ce_id, g, nid, s1, s2, s3, s4, s5, s6, s7) ce_id,
#  define ICEMAN_CE8(ce_id, g, nid, s1, s2, s3, s4, s5, s6, s7, s8) ce_id,
#  define ICEMAN_CE9(ce_id, g, nid, s1, s2, s3, s4, s5, s6, s7, s8, s9) ce_id,
#  define ICEMAN_CE10(ce_id, g, nid, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10) ce_id,
#  define ICEMAN_CE11(ce_id, g, nid, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11) ce_id,
#  define ICEMAN_CEA(ce_id, ce_id_a) ce_id = ce_id_a,
#endif /* CCC_ICEMAN_CEID_ENUM_DEF */

/* for CeGId group mapping table */
#ifdef CCC_ICEMAN_CEID_CEGID_MAP
#  define ICEMAN_CE1(ce_id, g, nid, s1) { ce_id, g, nid },
#  define ICEMAN_CE2(ce_id, g, nid, s1, s2) { ce_id, g, nid },
#  define ICEMAN_CE3(ce_id, g, nid, s1, s2, s3) { ce_id, g, nid },
#  define ICEMAN_CE4(ce_id, g, nid, s1, s2, s3, s4) { ce_id, g, nid },
#  define ICEMAN_CE5(ce_id, g, nid, s1, s2, s3, s4, s5) { ce_id, g, nid },
#  define ICEMAN_CE6(ce_id, g, nid, s1, s2, s3, s4, s5, s6) { ce_id, g, nid },
#  define ICEMAN_CE7(ce_id, g, nid, s1, s2, s3, s4, s5, s6, s7) { ce_id, g, nid },
#  define ICEMAN_CE8(ce_id, g, nid, s1, s2, s3, s4, s5, s6, s7, s8) { ce_id, g, nid },
#  define ICEMAN_CE9(ce_id, g, nid, s1, s2, s3, s4, s5, s6, s7, s8, s9) { ce_id, g, nid },
#  define ICEMAN_CE10(ce_id, g, nid, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10) { ce_id, g, nid },
#  define ICEMAN_CE11(ce_id, g, nid, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11) { ce_id, g, nid },
#  define ICEMAN_CEA(ce_id, ce_id_a)
#endif /* CCC_ICEMAN_CEID_CEGID_MAP */

/* for making charset string dictionary */
#ifdef CCC_ICEMAN_CEDIC_DEF
#  define ICEMAN_CE1(ce_id, g, nid, s1) { ce_id, s1 },
#  define ICEMAN_CE2(ce_id, g, nid, s1, s2) { ce_id, s1 }, { ce_id, s2 },
#  define ICEMAN_CE3(ce_id, g, nid, s1, s2, s3) { ce_id, s1 }, { ce_id, s2 }, { ce_id, s3 },
#  define ICEMAN_CE4(ce_id, g, nid, s1, s2, s3, s4) { ce_id, s1 }, { ce_id, s2 }, { ce_id, s3 }, { ce_id, s4 },
#  define ICEMAN_CE5(ce_id, g, nid, s1, s2, s3, s4, s5) { ce_id, s1 }, { ce_id, s2 }, { ce_id, s3 }, { ce_id, s4 }, { ce_id, s5 },
#  define ICEMAN_CE6(ce_id, g, nid, s1, s2, s3, s4, s5, s6) { ce_id, s1 }, { ce_id, s2 }, { ce_id, s3 }, { ce_id, s4 }, { ce_id, s5 }, { ce_id, s6 },
#  define ICEMAN_CE7(ce_id, g, nid, s1, s2, s3, s4, s5, s6, s7) { ce_id, s1 }, { ce_id, s2 }, { ce_id, s3 }, { ce_id, s4 }, { ce_id, s5 }, { ce_id, s6 }, { ce_id, s7 },
#  define ICEMAN_CE8(ce_id, g, nid, s1, s2, s3, s4, s5, s6, s7, s8) { ce_id, s1 }, { ce_id, s2 }, { ce_id, s3 }, { ce_id, s4 }, { ce_id, s5 }, { ce_id, s6 }, { ce_id, s7 }, { ce_id, s8 },
#  define ICEMAN_CE9(ce_id, g, nid, s1, s2, s3, s4, s5, s6, s7, s8, s9) { ce_id, s1 }, { ce_id, s2 }, { ce_id, s3 }, { ce_id, s4 }, { ce_id, s5 }, { ce_id, s6 }, { ce_id, s7 }, { ce_id, s8 }, { ce_id, s9 },
#  define ICEMAN_CE10(ce_id, g, nid, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10) { ce_id, s1 }, { ce_id, s2 }, { ce_id, s3 }, { ce_id, s4 }, { ce_id, s5 }, { ce_id, s6 }, { ce_id, s7 }, { ce_id, s8 }, { ce_id, s9 }, { ce_id, s10 },
#  define ICEMAN_CE11(ce_id, g, nid, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11) { ce_id, s1 }, { ce_id, s2 }, { ce_id, s3 }, { ce_id, s4 }, { ce_id, s5 }, { ce_id, s6 }, { ce_id, s7 }, { ce_id, s8 }, { ce_id, s9 }, { ce_id, s10 }, { ce_id, s11 },
#  define ICEMAN_CEA(ce_id, ce_id_a)
#endif /* CCC_ICEMAN_CEDIC_DEF */

/* for making top charset string table */
#ifdef CCC_ICEMAN_CEN_STRINGS_TOP_DEF
#  define ICEMAN_CE1(ce_id, g, nid, s1) s1,
#  define ICEMAN_CE2(ce_id, g, nid, s1, s2) s1, s2,
#  define ICEMAN_CE3(ce_id, g, nid, s1, s2, s3) s1, s2, s3,
#  define ICEMAN_CE4(ce_id, g, nid, s1, s2, s3, s4) s1, s2, s3, s4,
#  define ICEMAN_CE5(ce_id, g, nid, s1, s2, s3, s4, s5) s1, s2, s3, s4, s5
#  define ICEMAN_CE6(ce_id, g, nid, s1, s2, s3, s4, s5, s6) s1, s2, s3, s4, s5, s6
#  define ICEMAN_CE7(ce_id, g, nid, s1, s2, s3, s4, s5, s6, s7) s1, s2, s3, s4, s5, s6, s7
#  define ICEMAN_CE8(ce_id, g, nid, s1, s2, s3, s4, s5, s6, s7, s8) s1, s2, s3, s4, s5, s6, s7, s8
#  define ICEMAN_CE9(ce_id, g, nid, s1, s2, s3, s4, s5, s6, s7, s8, s9) s1, s2, s3, s4, s5, s6, s7, s8, s9
#  define ICEMAN_CE10(ce_id, g, nid, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10) s1, s2, s3, s4, s5, s6, s7, s8, s9, s10
#  define ICEMAN_CE11(ce_id, g, nid, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11) s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11
#  define ICEMAN_CEA(ce_id, ce_id_a)
#endif /* CCC_ICEMAN_CEN_STRINGS_TOP_DEF */

/* for making charset string table */
#ifdef CCC_ICEMAN_CEN_CHARSET_DEF
#  define ICEMAN_CE1(ce_id, g, nid, s1) { ce_id, g, nid, s1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
#  define ICEMAN_CE2(ce_id, g, nid, s1, s2) { ce_id, g, nid, s1, s2, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
#  define ICEMAN_CE3(ce_id, g, nid, s1, s2, s3) { ce_id, g, nid, s1, s2, s3, 0, 0, 0, 0, 0, 0, 0, 0 },
#  define ICEMAN_CE4(ce_id, g, nid, s1, s2, s3, s4) { ce_id, g, nid, s1, s2, s3, s4, 0, 0, 0, 0, 0, 0, 0 },
#  define ICEMAN_CE5(ce_id, g, nid, s1, s2, s3, s4, s5) { ce_id, g, nid, s1, s2, s3, s4, s5, 0, 0, 0, 0, 0, 0 },
#  define ICEMAN_CE6(ce_id, g, nid, s1, s2, s3, s4, s5, s6) { ce_id, g, nid, s1, s2, s3, s4, s5, s6, 0, 0, 0, 0, 0 },
#  define ICEMAN_CE7(ce_id, g, nid, s1, s2, s3, s4, s5, s6, s7) { ce_id, g, nid, s1, s2, s3, s4, s5, s6, s7, 0, 0, 0, 0 },
#  define ICEMAN_CE8(ce_id, g, nid, s1, s2, s3, s4, s5, s6, s7, s8) { ce_id, g, nid, s1, s2, s3, s4, s5, s6, s7, s8, 0, 0, 0 },
#  define ICEMAN_CE9(ce_id, g, nid, s1, s2, s3, s4, s5, s6, s7, s8, s9) { ce_id, g, nid, s1, s2, s3, s4, s5, s6, s7, s8, s9, 0, 0 },
#  define ICEMAN_CE10(ce_id, g, nid, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10) { ce_id, g, nid, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, 0 },
#  define ICEMAN_CE11(ce_id, g, nid, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11) { ce_id, g, nid, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11 },
#  define ICEMAN_CEA(ce_id, ce_id_a)
#endif /* CCC_ICEMAN_CEN_CHARSET_DEF */

/*
 * Table of charset encoding ids and names
 * IANA: http://www.iana.org/assignments/character-sets/character-sets.xhtml
 */

/*
 * CEID_USASCII: US-ASCII.
 */
ICEMAN_CE11(CEID_USASCII, CEGID_8BIT, CEID_NULL, "us-ascii", "iso-ir-6", "ANSI_X3.4-1968", "ANSI_X3.4-1986", "ISO_646.irv:1991", "ISO646-US", "us", "IBM367", "cp367", "csASCII", "ASCII")

/*
 * CEID_UCS2: UCS2, native endian of this machine.
 * CEID_UCS2_LE: UCS2 little endian.
 * CEID_UCS2_BE: UCS2 big endian.
 * CEID_UCS4: UCS4, native endian of this machine.
 * CEID_UCS4_LE: UCS4 little endian. 
 * CEID_UCS4_BE: UCS4 big endian.
 */
#if CCC_ENDIAN == CCC_LITTLE_ENDIAN
ICEMAN_CE7(CEID_UCS2, CEGID_16BIT_NE, CEID_NULL, "ucs2-le", "ucs2", "ISO-10646-UCS-2", "UCS-2", "csUnicode", "UCS-2LE", "UNICODELITTLE")
ICEMAN_CEA(CEID_UCS2_LE, CEID_UCS2)
ICEMAN_CE3(CEID_UCS2_BE, CEGID_NOGROUP, CEID_UCS2, "ucs2-be", "UCS-2BE", "UNICODEBIG")
ICEMAN_CE6(CEID_UCS4, CEGID_32BIT_NE, CEID_NULL, "ucs4-le", "ucs4", "ISO-10646-UCS-4", "UCS-4", "CSUCS4", "UCS-4LE")
ICEMAN_CEA(CEID_UCS4_LE, CEID_UCS4)
ICEMAN_CE2(CEID_UCS4_BE, CEGID_NOGROUP, CEID_UCS4, "ucs4-be", "UCS-4BE")
#elif CCC_ENDIAN == CCC_BIG_ENDIAN
ICEMAN_CE7(CEID_UCS2, CEGID_16BIT_NE, CEID_NULL, "ucs2-be", "ucs2", "ISO-10646-UCS-2", "UCS-2", "csUnicode", "UCS-2BE", "UNICODEBIG")
ICEMAN_CEA(CEID_UCS2_BE, CEID_UCS2)
ICEMAN_CE3(CEID_UCS2_LE, CEGID_NOGROUP, CEID_UCS2, "ucs2-le", "UCS-2LE", "UNICODELITTLE")
ICEMAN_CE6(CEID_UCS4, CEGID_32BIT_NE, CEID_NULL, "ucs4-be", "ucs4", "ISO-10646-UCS-4", "UCS-4", "CSUCS4", "UCS-4BE")
ICEMAN_CEA(CEID_UCS4_BE, CEID_UCS4)
ICEMAN_CE2(CEID_UCS4_LE, CEGID_NOGROUP, CEID_UCS4, "ucs4-le", "UCS-4LE")
#else
#  error "CCC_ENDIAN should be CCC_LITTLE_ENDIAN or CCC_BIG_ENDIAN"
#endif /* CCC_ENDIAN */
/*
 * CEID_UTF7: UTF-7
 */
ICEMAN_CE5(CEID_UTF7, CEGID_8BIT, CEID_NULL, "utf-7", "utf7", "unicode-1-1-utf-7", "CSUNICODE11UTF7", "csUTF7")
/*
 * CEID_UTF8: UTF-8 with BOM.
 */
ICEMAN_CE3(CEID_UTF8, CEGID_8BIT, CEID_NULL, "utf-8", "utf8", "csUTF8")
/*
 * CEID_UTF8N: UTF-8 without BOM.
 */
ICEMAN_CE2(CEID_UTF8N, CEGID_8BIT, CEID_NULL, "utf-8n", "utf8n")
/*
 * CEID_UTF16: UTF-16 with BOM.
 */
ICEMAN_CE2(CEID_UTF16, CEGID_16BIT_NE, CEID_NULL, "utf-16", "csUTF16")
/*
 * CEID_UTF16N: UTF-16 without BOM.
 */
ICEMAN_CE1(CEID_UTF16N, CEGID_16BIT_NE, CEID_NULL, "utf-16n")
/*
 * CEID_UTF32: UTF-32 with BOM.
 */
ICEMAN_CE2(CEID_UTF32, CEGID_32BIT_NE, CEID_NULL, "utf-32", "csUTF32")
/*
 * CEID_UTF32N: UTF-32 without BOM
 */
ICEMAN_CE1(CEID_UTF32N, CEGID_32BIT_NE, CEID_NULL, "utf-32n")
/*
 * CEID_UTF16_BE: UTF-16 big endian without BOM.
 * CEID_UTF16_LE: UTF-16 little endian without BOM.
 * CEID_UTF16_BE_BOM: UTF-16 big endian with BOM.
 * CEID_UTF16_LE_BOM: UTF-16 little endian with BOM.
 * CEID_UTF32_BE: UTF-32 big endian without BOM.
 * CEID_UTF32_LE: UTF-32 little endian without BOM.
 * CEID_UTF32_BE_BOM: UTF-32 big endian with BOM.
 * CEID_UTF32_LE_BOM: UTF-32 little endian with BOM.
 */
#if CCC_ENDIAN == CCC_LITTLE_ENDIAN
ICEMAN_CE2(CEID_UTF16_BE, CEGID_NOGROUP, CEID_UTF16, "utf-16be", "csUTF16BE")
ICEMAN_CE2(CEID_UTF16_LE, CEGID_16BIT_NE, CEID_NULL, "utf-16le", "csUTF16LE")
ICEMAN_CE1(CEID_UTF16_BE_BOM, CEGID_NOGROUP, CEID_UTF16, "utf-16be+bom")
ICEMAN_CE1(CEID_UTF16_LE_BOM, CEGID_16BIT_NE, CEID_NULL, "utf-16le+bom")
ICEMAN_CE2(CEID_UTF32_BE, CEGID_NOGROUP, CEID_UTF32, "utf-32be", "csUTF32BE")
ICEMAN_CE2(CEID_UTF32_LE, CEGID_32BIT_NE, CEID_NULL, "utf-32le", "csUTF32LE")
ICEMAN_CE1(CEID_UTF32_BE_BOM, CEGID_NOGROUP, CEID_UTF32, "utf-32be+bom")
ICEMAN_CE1(CEID_UTF32_LE_BOM, CEGID_32BIT_NE, CEID_NULL, "utf-32le+bom")
#elif CCC_ENDIAN == CCC_BIG_ENDIAN
ICEMAN_CE2(CEID_UTF16_BE, CEGID_16BIT_NE, CEID_NULL, "utf-16be", "csUTF16BE")
ICEMAN_CE2(CEID_UTF16_LE, CEGID_NOGROUP, CEID_UTF16, "utf-16le", "csUTF16LE")
ICEMAN_CE1(CEID_UTF16_BE_BOM, CEGID_16BIT_NE, CEID_NULL, "utf-16be+bom")
ICEMAN_CE1(CEID_UTF16_LE_BOM, CEGID_NOGROUP, CEID_UTF16, "utf-16le+bom")
ICEMAN_CE2(CEID_UTF32_BE, CEGID_32BIT_NE, CEID_NULL, "utf-32be", "csUTF32BE")
ICEMAN_CE2(CEID_UTF32_LE, CEGID_NOGROUP, CEID_UTF32, "utf-32le", "csUTF32LE")
ICEMAN_CE1(CEID_UTF32_BE_BOM, CEGID_32BIT_NE, CEID_NULL, "utf-32be+bom")
ICEMAN_CE1(CEID_UTF32_LE_BOM, CEGID_NOGROUP, CEID_UTF32, "utf-32le+bom")
#endif /* CCC_ENDIAN */
/*
 * CEID_ISO2022JP: iso-2022-jp
 */
ICEMAN_CE2(CEID_ISO2022JP, CEGID_8BIT, CEID_NULL, "iso-2022-jp", "csISO2022JP")
/*
 * CEID_EUCJP: euc-jp
 */
ICEMAN_CE6(CEID_EUCJP, CEGID_8BIT, CEID_NULL, "euc-jp", "x-euc-jp", "ujis", "eucJP", "EXTENDED_UNIX_CODE_PACKED_FORMAT_FOR_JAPANESE", "csEUCPkdFmtJapanese")
/*
 * CEID_SJIS: Shift_JIS
 */
ICEMAN_CE4(CEID_SJIS, CEGID_8BIT, CEID_NULL, "Shift_JIS", "sjis", "MS_Kanji", "csShiftJIS")
/*
 * CEID_ISO8859_1: iso-8859-1
 */
ICEMAN_CE10(CEID_ISO8859_1, CEGID_8BIT, CEID_NULL, "iso-8859-1", "iso-ir-100", "ISO_8859-1", "latin1", "l1", "IBM819", "CP819", "csISOLatin1", "ISO8859-1", "ISO_8859-1:1987")
/*
 * CEID_ISO8859_2: iso-8859-2
 */
ICEMAN_CE8(CEID_ISO8859_2, CEGID_8BIT, CEID_NULL, "iso-8859-2", "iso-ir-101", "ISO_8859-2", "latin2", "l2", "csISOLatin2", "ISO8859-2", "ISO_8859-2:1987")
/*
 * CEID_ISO8859_3: iso-8859-3
 */
ICEMAN_CE8(CEID_ISO8859_3, CEGID_8BIT, CEID_NULL, "iso-8859-3", "iso-ir-109", "ISO_8859-3", "latin3", "l3", "csISOLatin3", "ISO8859-3", "ISO_8859-3:1988")
/*
 * CEID_ISO8859_4: iso-8859-4
 */
ICEMAN_CE8(CEID_ISO8859_4, CEGID_8BIT, CEID_NULL, "iso-8859-4", "iso-ir-110", "ISO_8859-4", "latin4", "l4", "csISOLatin4", "ISO8859-4", "ISO_8859-4:1988")
/*
 * CEID_ISO8859_5: iso-8859-5
 */
ICEMAN_CE7(CEID_ISO8859_5, CEGID_8BIT, CEID_NULL, "iso-8859-5", "iso-ir-144", "ISO_8859-5", "cyrillic", "csISOLatinCyrillic", "ISO8859-5", "ISO_8859-5:1988")
/*
 * CEID_ISO8859_6: iso-8859-6
 */
ICEMAN_CE9(CEID_ISO8859_6, CEGID_8BIT, CEID_NULL, "iso-8859-6", "iso-ir-127", "ISO_8859-6", "ECMA-114", "ASMO-708", "arabic", "csISOLatinArabic", "ISO8859-6", "ISO_8859-6:1987")
/*
 * CEID_ISO8859_7: iso-8859-7
 */
ICEMAN_CE10(CEID_ISO8859_7, CEGID_8BIT, CEID_NULL, "iso-8859-7", "iso-ir-126", "ISO_8859-7", "ELOT_928", "ECMA-118", "greek", "greek8", "csISOLatinGreek", "ISO8859-7", "ISO_8859-7:1987")
/*
 * CEID_ISO8859_8: iso-8859-8
 */
ICEMAN_CE7(CEID_ISO8859_8, CEGID_8BIT, CEID_NULL, "iso-8859-8", "iso-ir-138", "ISO_8859-8", "hebrew", "csISOLatinHebrew", "ISO8859-8", "ISO_8859-8:1988")
/*
 * CEID_ISO8859_9: iso-8859-9
 */
ICEMAN_CE8(CEID_ISO8859_9, CEGID_8BIT, CEID_NULL, "iso-8859-9", "iso-ir-148", "ISO_8859-9", "latin5", "l5", "csISOLatin5", "ISO8859-9", "ISO_8859-9:1989")
/*
 * CEID_ISO8859_10: iso-8859-10
 */
ICEMAN_CE8(CEID_ISO8859_10, CEGID_8BIT, CEID_NULL, "iso-8859-10", "iso-ir-157", "ISO_8859-10", "csISOLatin6", "l6", "latin6", "ISO8859-10", "ISO_8859-10:1992")
/*
 * CEID_ISO8859_13: iso-8859-13
 */
ICEMAN_CE7(CEID_ISO8859_13, CEGID_8BIT, CEID_NULL, "iso-8859-13", "csISO885913", "ISO-IR-179", "ISO8859-13", "ISO_8859-13", "l7", "latin7")
/*
 * CEID_ISO8859_14: iso-8859-14
 */
ICEMAN_CE8(CEID_ISO8859_14, CEGID_8BIT, CEID_NULL, "iso-8859-14", "iso-ir-199", "ISO_8859-14:1998", "ISO_8859-14", "latin8", "iso-celtic", "l8", "csISO885914")
/*
 * CEID_ISO8859_15: iso-8859-15
 */
ICEMAN_CE7(CEID_ISO8859_15, CEGID_8BIT, CEID_NULL, "iso-8859-15", "ISO_8859-15", "Latin-9", "csISO885915", "ISO-IR-203", "ISO8859-15", "ISO_8859-15:1998")
/*
 * CEID_CP932: Microsoft cp932
 */
ICEMAN_CE4(CEID_CP932, CEGID_8BIT, CEID_NULL, "cp932", "SJIS-open", "SJIS-win", "MS932")
/*
 * CEID_EUCJPMS: euc-jp-ms
 */
ICEMAN_CE4(CEID_EUCJPMS, CEGID_8BIT, CEID_NULL, "EUC-JP-MS", "eucJP-MS", "eucJP-open", "eucJP-win")
/*
 * CEID_CP1252: Microsoft cp1252, windows-1252
 */
ICEMAN_CE4(CEID_CP1252, CEGID_8BIT, CEID_NULL, "windows-1252", "cp1252", "MS1252", "cswindows1252")

/* ------------------------------------------------------------
 * Detector
 * ------------------------------------------------------------ */

/*
 * CEID_JADETECTOR: Japanese charset encoding detector.
 */
ICEMAN_CE2(CEID_JADETECTOR, CDGID_DETECTOR, CEID_NULL, "ja-detector", "ja-auto")
/*
 * CEID_XMLDETECTOR: XML charset encoding detector.
 */
ICEMAN_CE1(CEID_XMLDETECTOR, CDGID_DETECTOR, CEID_NULL, "xml-detector")
/*
 * CEID_HTMLDETECTOR: HTML charset encoding detector.
 */
ICEMAN_CE1(CEID_HTMLDETECTOR, CDGID_DETECTOR, CEID_NULL, "html-detector")
