﻿// @@DISTHDR@@
// $Id$
// compile synthetic filter path

//#define TEST_COMPILE

#include <assert.h>
#include <stdio.h>
#include <string.h>
#include <ccc/base/AVLDict.h>

#define COMPILE_FILTERPATH
#include <ccc/iceman/Iceman.h>
#ifndef TEST_COMPILE
#include <ccc/iceman/CenDictionary.h>
#include "unitfilter.cpp"
#endif /* TEST_COMPILE */
#include <ccc/iceman/IFilterPath.h>

CCC_NAMESPACE_START(CCC);

#ifdef TEST_COMPILE
typedef char CompileKey;
#else /* TEST_COMPILE */
typedef CeId CompileKey;
#endif /* TEST_COMPILE */

#ifdef TEST_COMPILE
struct UnitIFilterEntry
{
  char* from;
  char* to;
  int lost;
};

// filter id order
static UnitIFilterEntry unit_filters[] =
{
  { "us-ascii", "ucs-2", 0 },
  { "ucs-2", "utf-8", 0 },
  { "ucs-2", "utf-7", 0 },
  { "ucs-2", "ucs-4", 0 },
  { "ucs-4", "ucs-2", 0 },
  { "ucs-2-lt", "ucs-2", 0 },
  { "ucs-2-bg", "ucs-2", 0 },
  { "ucs-4-lt", "ucs-4", 0 },
  { "ucs-4-bg", "ucs-4", 0 },
  { "ucs-2", "us-ascii", -1 },
  { "iso-2022-jp", "ucs-2", 0 },
  { "iso-2022-jp", "euc-jp", 0 },
  { "iso-2022-jp", "shift_jis", 0 },//
  { "euc-jp", "ucs-2", 0 },
  { "euc-jp", "iso-2022-jp", 0 },
  { "euc-jp", "shift_jis", 0 },
  { "shift_jis", "ucs-2", 0 },
  { "shift_jis", "euc-jp", 0 },
  { "shift_jis", "iso-2022-jp", 0 },
  { "shift_jis", "us-ascii", -1 },
  { "ucs-2", "euc-jp", -1 },
  { "ucs-2", "iso-2022-jp", -1 },
  { "ucs-2", "shift_jis", -1 },
  0
};
#endif /* TEST_COMPILE */

int
CompileKeyComp(const CompileKey* key1, const CompileKey* key2)
{
#ifdef TEST_COMPILE
  return strcmp(key1, key2);
#else /* TEST_COMPILE */
  return *((int*)key1) - *((int*)key2);
#endif /* TEST_COMPILE */
}

class StringDictionary
  : public AVLDict<CompileKey, CompileKey>
{
 protected:
  virtual const CompileKey* getKey(const CompileKey* element) const
  {
    return element;
  }
  virtual int compare(const CompileKey* key1, const CompileKey* key2) const
  {
    return CompileKeyComp(key1, key2);
  }
};

class CompileIFilterPath
{
  StringDictionary* src_dic;
  StringDictionary* dist_dic;

 public:
  CompileIFilterPath();
  ~CompileIFilterPath();
  void makeSrcDictionary();
  void makeDistDictionary();
  void findAll();
  void find(CompileKey* from, CompileKey* to, int nest, IFilterPath& work, IFilterPath& found, IFilterPath& found2);

 private:
  void print(IFilterPath& path);
  void print2(IFilterPath& path);
  void printResult(CompileKey* from, CompileKey* to, IFilterPath& found, IFilterPath& found2);
};

CompileIFilterPath::CompileIFilterPath()
{
  src_dic = new StringDictionary();
  dist_dic = new StringDictionary();
  makeSrcDictionary();
  makeDistDictionary();
}

CompileIFilterPath::~CompileIFilterPath()
{
  delete src_dic;
  delete dist_dic;
}

void
CompileIFilterPath::print(IFilterPath& path)
{
  printf("(");
  int i;
  for (i = 0; path[i] != -1; i++)
  {
#ifdef TEST_COMPILE
    printf("%d:[%s=>%s] ", path[i], unit_filters[path[i]].from, unit_filters[path[i]].to);
#else /* TEST_COMPILE */
    printf("%d:[%d=>%d] ", path[i], (int)unit_filters[path[i]].from, (int)unit_filters[path[i]].to);
#endif /* TEST_COMPILE */
  }
  printf(")\n");
}

void
CompileIFilterPath::print2(IFilterPath& path)
{
  printf("<");
  int i;
  for (i = 0; i < ICEMAN_MAX_COMPOSIT_PATH; i++)
  {
    printf("%d, ", path[i]);
  }
  printf(">\n");
}

void
CompileIFilterPath::makeSrcDictionary()
{
  UnitIFilterEntry* f = unit_filters;
#ifdef TEST_COMPILE
  while (f->from != 0)
  {
    src_dic->add(f->from);
    f++;
  }
#else /* TEST_COMPILE */
  while (f->from != CEID_NULL)
  {
    src_dic->add(&f->from);
    f++;
  }
#endif /* TEST_COMPILE */
}

void
CompileIFilterPath::makeDistDictionary()
{
  UnitIFilterEntry* f = unit_filters;
#ifdef TEST_COMPILE
  while (f->from != 0)
  {
    dist_dic->add(f->to);
    f++;
  }
#else /* TEST_COMPILE */
  while (f->from != CEID_NULL)
  {
    dist_dic->add(&f->to);
    f++;
  }
#endif /* TEST_COMPILE */
}

void
CompileIFilterPath::printResult(CompileKey* from, CompileKey* to, IFilterPath& found, IFilterPath& found2)
{
#ifdef TEST_COMPILE
  printf("\n================================================\nFIND %s=>%s\n", src, dist);
  printf("no lost: ");
  print(found);
  printf("lost:    ");
  print(found2);
#else /* TEST_COMPILE */
  // { from, to, lost, path0, path1, ..., path4 }
  if (found.getLength() != 0)
  {
    printf("\n// COMPOSITFILTER: %s -> %s\n", CenDictionary::searchStr(*from), CenDictionary::searchStr(*to));
    int i = 0;
    while (i < found.getLength())
    {
      int n = found[i++];
      printf("//   UNITFILTER:%d %s -> %s\n", 
	     n,
	     CenDictionary::searchStr(unit_filters[n].from),
	     CenDictionary::searchStr(unit_filters[n].to));
    }
    printf("{ (CeId)%d, (CeId)%d, 0, ", (int)*from, (int)*to);
    i = 0;
    while (i < found.getLength())
    {
      printf("%d, ", found[i++]);
    }
    while (i < ICEMAN_MAX_COMPOSIT_PATH)
    {
      printf("-1, ");
      i++;
    }
    printf("},\n");
  }
  else if (found2.getLength() != 0)
  {
    printf("\n// COMPOSITFILTER: %s -> %s\n", CenDictionary::searchStr(*from), CenDictionary::searchStr(*to));
    int i = 0;
    while (i < found2.getLength())
    {
      int n = found2[i++];
      printf("//   UNITFILTER:%d %s -> %s\n", 
	     n,
	     CenDictionary::searchStr(unit_filters[n].from),
	     CenDictionary::searchStr(unit_filters[n].to));
    }
    printf("{ (CeId)%d, (CeId)%d, -1, ", (int)*from, (int)*to);
    i = 0;
    while (i < found2.getLength())
    {
      printf("%d, ", found2[i++]);
    }
    while (i < ICEMAN_MAX_COMPOSIT_PATH)
    {
      printf("-1, ");
      i++;
    }
    printf("},\n");
  }
#endif /* TEST_COMPILE */
}

void
CompileIFilterPath::findAll()
{
  Iterator<CompileKey>* src_itr = src_dic->createIterator();
  Iterator<CompileKey>* dist_itr = dist_dic->createIterator();
  CompileKey* src;
  IFilterPath work;
  IFilterPath found;
  IFilterPath found2;
  while (src = src_itr->next())
  {
    dist_itr->rewind();
    CompileKey* dist;
    while (dist = dist_itr->next())
    {
      if (CompileKeyComp(src, dist))
      {
	work.clear();
	found.clear();
	found2.clear();
	find(src, dist, 0, work, found, found2);
	printResult(src, dist, found, found2);
      }
    }
  }
  delete src_itr;
  delete dist_itr;
}

void
CompileIFilterPath::find(CompileKey* from, CompileKey* to, int nest,
			IFilterPath& work, IFilterPath& found, IFilterPath& found2)
{
  // printf("find: nest:%d\n", nest);
  int n;
  int i;
  for (n = 0; unit_filters[n].from != 0; n++)
  {
    assert(nest + 1 <= ICEMAN_MAX_COMPOSIT_PATH);
    work[nest] = n;
    work[nest + 1] = -1;
    // printf("- nest:%d ", nest); print2(work);
#ifdef TEST_COMPILE
    if (!CompileKeyComp(unit_filters[n].from, from))
#else /* TEST_COMPILE */
    if (!CompileKeyComp(&(unit_filters[n].from), from))
#endif /* TEST_COMPILE */
    {
#ifdef TEST_COMPILE
      if (!CompileKeyComp(unit_filters[n].to, to))
#else /* TEST_COMPILE */
      if (!CompileKeyComp(&(unit_filters[n].to), to))
#endif /* TEST_COMPILE */
      {
	//printf("@ "); print(found);
	// bingo
	int lost = 0;
	for (i = 0; i <= nest; i++)
	{
	  lost += unit_filters[work[i]].lost;
	}
	if (lost == 0)
	{
	  int f_len = found.getLength();
	  if ((f_len == 0) ||
	      (f_len > work.getLength()))
	  {
	    found = work;
	  }
	  int f2_len = found2.getLength();
	  if ((f2_len == 0) ||
	      (f2_len > work.getLength()))
	  {
	    found2 = work;
	  }
	}
	else
	{
	  int f2_len = found2.getLength();
	  if ((f2_len == 0) ||
	      (f2_len > work.getLength()))
	  {
	    found2 = work;
	  }
	}
	//printf("%d    ", lost);
	//for (i = 0; i <= nest; i++)
	//{
	//  printf("%d:[%s=>%s] ", work[i], unit_filters[work[i]].from, unit_filters[work[i]].to);
	//}
	//printf("\n");
      }
      else if (nest < ICEMAN_MAX_COMPOSIT_PATH - 1)
      {
	// pliventing path loop
	for (i = 0; i <= nest; i++)
	{
#ifdef TEST_COMPILE
	  if (!CompileKeyComp(unit_filters[work[i]].from, unit_filters[n].to))
#else /* TEST_COMPILE */
	  if (!CompileKeyComp(&(unit_filters[work[i]].from), &(unit_filters[n].to)))
#endif /* TEST_COMPILE */
	  {
	    //printf("i:%d, nest:%d\n", i, nest);
	    break;
	  }
	}
	if (i > nest)
	{
#ifdef TEST_COMPILE
	  find(unit_filters[n].to, to, nest + 1, work, found, found2);
#else /* TEST_COMPILE */
	  find(&(unit_filters[n].to), to, nest + 1, work, found, found2);
#endif /* TEST_COMPILE */
	}
      }
    }
  }
}

CCC_NAMESPACE_END(CCC);

CCC_NAMESPACE_USING_NAMESPACE(CCC);

int
main(int argc, char** argv)
{
#if CCC_ENDIAN == CCC_LITTLE_ENDIAN
  printf("#if CCC_ENDIAN == CCC_LITTLE_ENDIAN\n");
#elif CCC_ENDIAN == CCC_BIG_ENDIAN
  printf("#if CCC_ENDIAN == CCC_BIG_ENDIAN\n");
#endif /* CCC_ENDIAN */
  CompileIFilterPath* filter_path = new CompileIFilterPath();
  filter_path->findAll();
  delete filter_path;
  printf("#endif\n");
  return 0;
}

