﻿// $Id$

#include <stdio.h>
#include <ccc/iceman/jpcode.h>

CCC_NAMESPACE_START(CCC);

bool
cp932P(UInt8 c1, UInt8 c2)
{
  UInt16 c = ((UInt16)c1) << 8 | c2;
  return cp932P(c);
}

static
bool
checkCp932Tbl(const UInt16* tbl, UInt16 c)
{
  UInt16 index = c >> 4;
  UInt16 offset = c & 0x000f;
  if ((c >= 0x8100) && (c <= 0x9fff))
  {
    /* 0x8100 - 0x9fff */
    index -= 0x810;
  }
  else if (c >= 0xe000)
  {
    /* 0xe000 - 0xffff */
    index -= 0x810 + (0xe00 - 0xa00);
  }
  else
  {
    return false;
  }
  static UInt16 mask[16] = 
  {
    0x0001, 0x0002, 0x0004, 0x0008, 0x0010, 0x0020, 0x0040, 0x0080,
    0x0100, 0x0200, 0x0400, 0x0800, 0x1000, 0x2000, 0x4000, 0x8000,
  };
  UInt16 val = tbl[index];
  if ((val & mask[offset]) != 0)
  {
    return true;
  }
  else
  {
    return false;
  }
}

bool
cp932P(UInt16 c)
{
  static const UInt16 tbl[] =
  {
#include "cp932list.inc"
  };
  return checkCp932Tbl(tbl, c);
}

bool
cp932WithGaijiP(UInt8 c1, UInt8 c2)
{
  UInt16 c = ((UInt16)c1) << 8 | c2;
  return cp932WithGaijiP(c);
}

bool
cp932WithGaijiP(UInt16 c)
{
  static const UInt16 tbl[] =
  {
#include "cp932list-g.inc"
  };
  return checkCp932Tbl(tbl, c);
}

CCC_NAMESPACE_END(CCC);

#ifdef UNIT_TEST

struct Cp932Unicode
{
  unsigned short int cp932;
  unsigned short int unicode;
};

static Cp932Unicode tbl[] =
{
#include "map/cp932_uni.map"
  { 0, 0 },	// END
};

int
main()
{
  Cp932Unicode* x = tbl;
  Cp932Unicode* top = tbl;
  while ((x == top) || (x->cp932 != 0))
  {
    if (x->cp932 > 0xff)
    {
      if (CCC::cp932P(x->cp932) != true)
      {
	printf("ERROR: 0x%04x is not detected CP932 by CCC::cp932P(0x%04x)\n", x->cp932, x->cp932);
      }
      if (CCC::cp932WithGaijiP(x->cp932) != true)
      {
	printf("ERROR: 0x%04x is not detected CP932 by CCC::cp932WithGaijiP(0x%04x)\n", x->cp932, x->cp932);
      }
      unsigned short int c1 = x->cp932 >> 8;
      unsigned short int c2 = x->cp932 & 0xff;
      if (CCC::cp932P(c1, c2) != true)
      {
	printf("ERROR: 0x%02x%02x is not detected CP932 by CCC::cp932P(0x%02x, 0x%02x)\n", c1, c2, c1, c2);
      }
      if (CCC::cp932WithGaijiP(c1, c2) != true)
      {
	printf("ERROR: 0x%02x%02x is not detected CP932 by CCC::cp932WithGaijiP(0x%02x, 0x%02x)\n", c1, c2, c1, c2);
      }
#if 0
      else
      {
	printf("OK: 0x%04x is detected CP932\n", x->cp932);
      }
#endif
    }
    x++;
  }
  unsigned short int gaiji;
  for (gaiji = 0xf040; gaiji <= 0xf9fc; gaiji++)
  {
    if (CCC::cp932P(gaiji) != false)
    {
      printf("ERROR: 0x%04x is detected CP932 by CCC::cp932P(0x%04x)\n", gaiji, gaiji);
    }
    if (CCC::cp932WithGaijiP(gaiji) != true)
    {
      printf("ERROR: 0x%04x is not detected CP932 gaiji by CCC::cp932WithGaijiP(0x%04x)\n", gaiji, gaiji);
    }
    unsigned short int c1 = gaiji >> 8;
    unsigned short int c2 = gaiji & 0xff;
    if (CCC::cp932P(c1, c2) != false)
    {
      printf("ERROR: 0x%02x%02x is detected CP932 by CCC::cp932P(0x%02x, 0x%02x)\n", c1, c2, c1, c2);
    }
    if (CCC::cp932WithGaijiP(c1, c2) != true)
    {
      printf("ERROR: 0x%02x%02x is not detected CP932 by CCC::cp932WithGaijiP(0x%02x, 0x%02x)\n", c1, c2, c1, c2);
    }
  }
  /* undefined sample code */
  static const unsigned short int undefined_samples[] =
  {
    0x8100, 0x8101, 0x8200, 0x825f, 0x827f, 0x8280, 0x83d8, 0x8462,
    0x84bf, 0x8650, 0x877f, 0x879e, 0x8890, 0x889e, 0x88Fd, 0x897f,
    0x89Fd, 0x8A7f, 0x8A00, 0x8A3f, 0xa000, 0xafff, 0xdfff, 0xe000,
    0xe03f, 0xe07f, 0xe0fd, 0xEAA6, 0xEAB0, 0xEDFd, 0xEEEd, 0xEEEe,
    0xEF00, 0xFA30, 0xFB00, 0xFB30, 0xFC00, 0xFC30, 0xFC50, 0xFC60,
    0x0000,
  };
  const unsigned short int* p = undefined_samples;
  while (*p != 0x0000)
  {
    unsigned short int c = *p++;
    if (CCC::cp932P(c) != false)
    {
      printf("ERROR: 0x%04x is detected CP932 by CCC::cp932P(0x%04x)\n", c, c);
    }
    if (CCC::cp932WithGaijiP(c) != false)
    {
      printf("ERROR: 0x%04x is detected CP932 gaiji by CCC::cp932WithGaijiP(0x%04x)\n", c, c);
    }
    unsigned short int c1 = c >> 8;
    unsigned short int c2 = c & 0xff;
    if (CCC::cp932P(c1, c2) != false)
    {
      printf("ERROR: 0x%02x%02x is detected CP932 by CCC::cp932P(0x%02x, 0x%02x)\n", c1, c2, c1, c2);
    }
    if (CCC::cp932WithGaijiP(c1, c2) != false)
    {
      printf("ERROR: 0x%02x%02x is detected CP932 by CCC::cp932WithGaijiP(0x%02x, 0x%02x)\n", c1, c2, c1, c2);
    }
  }
  return 0;
}
#endif /* UNIT_TEST */

