﻿/*
 * CP932一覧のテキストファイルを生成します。
 */
#include <stdio.h>
#include <string.h>

struct Cp932Unicode
{
  unsigned short int cp932;
  unsigned short int unicode;
};

static Cp932Unicode tbl[] =
{
#include "map/cp932_uni.map"
  { 0, 0 },	// END
};

/*!
 * 一覧を生成します。
 * \param bit_pattern_p プログラムで利用するためのビットパターンで出力します。
 * \param with_gaiji_p 外字エリアも出力します。
 */
void
dumpList(bool bit_pattern_p, bool with_gaiji_p)
{
  bool cp932[0x10000];
  int i;
  for (i = 0; i < 0x10000; i++)
  {
    cp932[i] = false;
  }

  Cp932Unicode* x = tbl;
  Cp932Unicode* top = tbl;
  while ((x == top) || (x->cp932 != 0))
  {
    //printf("%04x\n", x->cp932);
    cp932[x->cp932] = true;
    x++;
  }

  if (with_gaiji_p)
  {
    /* 外字エリア: 0xf040〜0xf9fc */
    for (i = 0xf040; i <= 0xf9fc; i++)
    {
      cp932[i] = true;
    }
  }

  /*
   * データの出力範囲
   * 0x8100〜0x9fff
   * 0xe000〜0xffff
   */
  int m;
  for (m = 0; m < 2; m++)
  {
    static unsigned short int from[2] = { 0x810, 0xe00 };
    static unsigned short int to[2] = { 0x9ff, 0xfff };
    int j, k;
    for (j = from[m]; j <= to[m]; j++)
    {
      int l = j * 16;
      if (bit_pattern_p)
      {
	printf("/* %04x - %04x */ ", l, l + 15);
	unsigned short int pat = 0;
	for (k = 0; k < 16; k++)
	{
	  i = l + k;
	  if (cp932[i])
	  {
	    static unsigned short int patterns[] =
	    {
	      0x0001, 0x0002, 0x0004, 0x0008, 0x0010, 0x0020, 0x0040, 0x0080,
	      0x0100, 0x0200, 0x0400, 0x0800, 0x1000, 0x2000, 0x4000, 0x8000,
	    };
	    pat |= patterns[k];
	  }
	}
	printf("0x%04x,\n", pat);
      }
      else
      {
	printf("%04X : ", l);
	for (k = 0; k < 16; k++)
	{
	  i = l + k;
	  //printf("%04x\n", i);
	  // printf("%c ", cp932[i] ? '*' : '_');
	  if (cp932[i])
	  {
	    unsigned char c1 = (unsigned char)(i >> 8);
	    unsigned char c2 = (unsigned char)(i & 0xff);
	    printf("%c%c", c1, c2);
	  }
	  else
	  {
	    printf("--");
	  }
	}
	printf("\r\n");
      }
    }
  }
}

/*!
 * 引数:
 * -g 外字エリア付き (デフォルト外字無し)
 * -b ビットパターン出力 (デフォルト文字出力)
 */
int
main(int argc, char** argv)
{
  bool with_gaiji_p = false;
  bool bit_pattern_p = false;
  int i;
  for (i = 1; i < argc; i++)
  {
    if (strcmp(argv[i], "-g") == 0)
    {
      with_gaiji_p = true;
    }
    else if (strcmp(argv[i], "-b") == 0)
    {
      bit_pattern_p = true;
    }
    else
    {
      fprintf(stderr, "ERROR: unknown option(%s).\n", argv[i]);
      return -1;
    }
  }

  dumpList(bit_pattern_p, with_gaiji_p);
  return 0;
}

  
