﻿// @@DISTHDR@@
// $Id$

#include <assert.h>
#include <ccc/iceman/eucodeconv.h>
#include <ccc/iceman/ucs2to.h>
#include <ccc/iceman/Unicode.h>

CCC_NAMESPACE_START(CCC);

// ------------------------------------------------------------------------
// class FromCp1252ToUcs2

FromCp1252ToUcs2::FromCp1252ToUcs2()
{
}

FromCp1252ToUcs2::~FromCp1252ToUcs2()
{
}

UInt16
FromCp1252ToUcs2::getUInt16() CCC_RAISES(IOException)
{
  UInt16 ret;
  if (getQueueLength())
  {
    ret = pop();
    return ret;
  }
  UInt8 c = (UInt8)src->getInt8();
  if ((c < 0x20) || (c == 0x7f))
  {
    ret = (UInt16)c;
  }
  else
  {
    ret = convertFromCp1252ToUcs2((UInt16)c);
  }
  return ret;
}

IFilter*
FromCp1252ToUcs2::createIFilter()
{
  return new FromCp1252ToUcs2();
}

// ------------------------------------------------------------------------
// class FromUcs2ToCp1252

FromUcs2ToCp1252::FromUcs2ToCp1252()
{
}

FromUcs2ToCp1252::~FromUcs2ToCp1252()
{
}

Int8
FromUcs2ToCp1252::getInt8() CCC_RAISES(IOException)
{
  if (getQueueLength())
  {
    Int8 ret = pop();
    return ret;
  }

  for (;;)
  {
    UInt16 c = src->getUInt16();
    if ((c < 0x20) || (c == 0x7f))
    {
      return (Int8)c;
    }
    UInt16 w = convertFromUcs2ToCp1252(c);
    if (w != SPARSE_NOT_FOUND)
    {
      Int8 s2 = (Int8)(w & 0x00ffu);
      if (w > 0x00ffu)
      {
	push(s2);
	Int8 s1 = (Int8)(w >> 8);
	return s1;
      }
      else
      {
	return s2;
      }
    }
  }
}

IFilter*
FromUcs2ToCp1252::createIFilter()
{
  return new FromUcs2ToCp1252();
}

CCC_NAMESPACE_END(CCC);
