﻿// @@DISTHDR@@
// $Id$

#ifndef INCLUDE_ccc_iceman_i18ncode_h
#define INCLUDE_ccc_iceman_i18ncode_h

CCC_NAMESPACE_START(CCC);

// ASCII
enum Ascii
{
  ASCII_NULL = 0x00,
  ASCII_SOH = 0x01,
  ASCII_STH = 0x02,
  ASCII_ETH = 0x03,
  ASCII_EOT = 0x04,
  ASCII_ENQ = 0x05,
  ASCII_ACK = 0x06,
  ASCII_BEL = 0x07,
  ASCII_BS = 0x08,
  ASCII_HT = 0x09,
  ASCII_LF = 0x0a,
  ASCII_VT = 0x0b,
  ASCII_FF = 0x0c,
  ASCII_CR = 0x0d,
  ASCII_SO = 0x0e,
  ASCII_SI = 0x0f,
  ASCII_DLE = 0x10,
  ASCII_DC1 = 0x11,
  ASCII_DC2 = 0x12,
  ASCII_DC3 = 0x13,
  ASCII_DC4 = 0x14,
  ASCII_NAK = 0x15,
  ASCII_SYN = 0x16,
  ASCII_ETB = 0x17,
  ASCII_CAN = 0x18,
  ASCII_EM = 0x19,
  ASCII_SUB = 0x1a,
  ASCII_ESC = 0x1b,
  ASCII_FS = 0x1c,
  ASCII_GS = 0x1d,
  ASCII_RS = 0x1e,
  ASCII_US = 0x1f,
  ASCII_SP = 0x20,
  ASCII_DEL = 0x7f,
};
  
inline bool controlP(UInt8 c) { return c < ASCII_SP; }
inline bool asciiP(UInt8 c) { return (c >= ASCII_SP) && (c < ASCII_DEL); }
inline bool delP(UInt8 c) { return c == ASCII_DEL; }
 
// EUC (Extended Unix Code) Encodings
enum Euc
{
  EUC_SS2 = 0x8e,
  EUC_SS3 = 0x8f,
};
  
inline bool eucSs2P(UInt8 c) { return c == EUC_SS2; }
inline bool eucSs3P(UInt8 c) { return c == EUC_SS3; }

CCC_NAMESPACE_END(CCC);

#endif /* INCLUDE_ccc_iceman_i18ncode_h */
