﻿// @@DISTHDR@@
// $Id$

#include <ccc/iceman/iso8859conv.h>
#include <ccc/iceman/Unicode.h>
#include <ccc/iceman/ucs2to.h>

CCC_NAMESPACE_START(CCC);

#define MAP8859(m, u) u,

static UInt16 map8859_1[] =
{
#include "map/8859-1_uni.map"
};

static UInt16 map8859_2[] =
{
#include "map/8859-2_uni.map"
};

static UInt16 map8859_3[] =
{
#include "map/8859-3_uni.map"
};

static UInt16 map8859_4[] =
{
#include "map/8859-4_uni.map"
};

static UInt16 map8859_5[] =
{
#include "map/8859-5_uni.map"
};

static UInt16 map8859_6[] =
{
#include "map/8859-6_uni.map"
};

static UInt16 map8859_7[] =
{
#include "map/8859-7_uni.map"
};

static UInt16 map8859_8[] =
{
#include "map/8859-8_uni.map"
};
  
static UInt16 map8859_9[] =
{
#include "map/8859-9_uni.map"
};

static UInt16 map8859_10[] =
{
#include "map/8859-10_uni.map"
};

static UInt16 map8859_13[] =
{
#include "map/8859-13_uni.map"
};

static UInt16 map8859_14[] =
{
#include "map/8859-14_uni.map"
};

static UInt16 map8859_15[] =
{
#include "map/8859-15_uni.map"
};

// ------------------------------------------------------------------------
// From8859_xToUcs2

#define FROM8859_XTOUCS2_BODY(x) \
From8859_ ## x ## ToUcs2::From8859_ ## x ## ToUcs2()\
  : From8859ToUcs2(From8859ToUcs2::FROM_ISO8859_ ## x)\
{\
}\
\
From8859_ ## x ## ToUcs2::~From8859_## x ## ToUcs2()\
{\
}\
\
IFilter*\
From8859_ ## x ## ToUcs2::createIFilter()\
{\
  return new From8859_ ## x ## ToUcs2();\
}

FROM8859_XTOUCS2_BODY(1);
FROM8859_XTOUCS2_BODY(2);
FROM8859_XTOUCS2_BODY(3);
FROM8859_XTOUCS2_BODY(4);
FROM8859_XTOUCS2_BODY(5);
FROM8859_XTOUCS2_BODY(6);
FROM8859_XTOUCS2_BODY(7);
FROM8859_XTOUCS2_BODY(8);
FROM8859_XTOUCS2_BODY(9);
FROM8859_XTOUCS2_BODY(10);
FROM8859_XTOUCS2_BODY(13);
FROM8859_XTOUCS2_BODY(14);
FROM8859_XTOUCS2_BODY(15);

// ------------------------------------------------------------------------
// class From8859ToUcs2
From8859ToUcs2::From8859ToUcs2(From8859ToUcs2::From f)
{
  switch (f)
  {
   case From8859ToUcs2::FROM_ISO8859_1:
    tbl = map8859_1;
    break;
   case From8859ToUcs2::FROM_ISO8859_2:
    tbl = map8859_2;
    break;
   case From8859ToUcs2::FROM_ISO8859_3:
    tbl = map8859_3;
    break;
   case From8859ToUcs2::FROM_ISO8859_4:
    tbl = map8859_4;
    break;
   case From8859ToUcs2::FROM_ISO8859_5:
    tbl = map8859_5;
    break;
   case From8859ToUcs2::FROM_ISO8859_6:
    tbl = map8859_6;
    break;
   case From8859ToUcs2::FROM_ISO8859_7:
    tbl = map8859_7;
    break;
   case From8859ToUcs2::FROM_ISO8859_8:
    tbl = map8859_8;
    break;
   case From8859ToUcs2::FROM_ISO8859_9:
    tbl = map8859_9;
    break;
   case From8859ToUcs2::FROM_ISO8859_10:
    tbl = map8859_10;
    break;
   case From8859ToUcs2::FROM_ISO8859_13:
    tbl = map8859_13;
    break;
   case From8859ToUcs2::FROM_ISO8859_14:
    tbl = map8859_14;
    break;
   case From8859ToUcs2::FROM_ISO8859_15:
    tbl = map8859_15;
    break;
  }
}

From8859ToUcs2::~From8859ToUcs2()
{
}

UInt16 
From8859ToUcs2::getUInt16() CCC_RAISES(IOException)
{
  UInt16 ret;
  for (;;)
  {
    UInt8 c = (UInt8)src->getInt8();
    ret = tbl[c];
    if (ret != ICEMAN_UNICODE_SNC)
    {
      return ret;
    }
    else
    {
      // skip
    }
  }
}

// ------------------------------------------------------------------------
// class From8859_xToUsAscii

From8859_xToUsAscii::From8859_xToUsAscii()
{
}

From8859_xToUsAscii::~From8859_xToUsAscii()
{
}

IFilter*
From8859_xToUsAscii::createIFilter()
{
  return new From8859_xToUsAscii();
}

Int8
From8859_xToUsAscii::getInt8() CCC_RAISES(IOException)
{
  for (;;)
  {
    UInt8 c = (UInt8)src->getInt8();
    if (c < 0x80)
    {
      return c;
    }
    else
    {
      // skip
    }
  }
}

// ------------------------------------------------------------------------
// class FromUsAsciiTo8859_x

FromUsAsciiTo8859_x::FromUsAsciiTo8859_x()
{
}

FromUsAsciiTo8859_x::~FromUsAsciiTo8859_x()
{
}

IFilter*
FromUsAsciiTo8859_x::createIFilter()
{
  return new FromUsAsciiTo8859_x();
}

Int8
FromUsAsciiTo8859_x::getInt8() CCC_RAISES(IOException)
{
  for (;;)
  {
    UInt8 c = (UInt8)src->getInt8();
    if (c < 0x80)
    {
      return c;
    }
    else
    {
      // input error
      // skip
    }
  }
}

// ------------------------------------------------------------------------
// from FromUcs2To8859_ ## x

#if 0
FromUcs2To8859_1::FromUcs2To8859_1()
{
}

FromUcs2To8859_1::~FromUcs2To8859_1()
{
}

IFilter*
FromUcs2To8859_1::createIFilter()
{
  return new FromUcs2To8859_1();
}

Int8
FromUcs2To8859_1::getInt8() CCC_RAISES(IOException)
{
  UInt16 ret;
  for (;;)
  {
    UInt16 c = src->getUInt16();
    ret = convertFromUcs2ToIso8859_1(c);
    if (ret != ICEMAN_UNICODE_SNC)
    {
      return (Int8)ret;
    }
    else
    {
      /* no mapping */
      /* skip */
    }
  }
}
#endif

#define FROMUCS2TO8859_X_BODY(x)	\
	\
FromUcs2To8859_## x::FromUcs2To8859_## x()	\
{	\
}	\
    						\
FromUcs2To8859_## x::~FromUcs2To8859_## x()	\
{	\
}	\
  	\
IFilter*	\
FromUcs2To8859_## x::createIFilter()	\
{	\
  return new FromUcs2To8859_1();	\
}	\
  	\
Int8	\
FromUcs2To8859_## x::getInt8() CCC_RAISES(IOException)	\
{	\
  UInt16 ret;	\
  for (;;)	\
  {	\
    UInt16 c = src->getUInt16();	\
    ret = convertFromUcs2ToIso8859_## x(c);	\
    if (ret != ICEMAN_UNICODE_SNC)	\
    {	\
      return (Int8)ret;	\
    }	\
    else					\
    {	\
      /* no mapping */ 	\
      /* skip */ 	\
    }	\
  }	\
}

FROMUCS2TO8859_X_BODY(1);
FROMUCS2TO8859_X_BODY(2);
FROMUCS2TO8859_X_BODY(3);
FROMUCS2TO8859_X_BODY(4);
FROMUCS2TO8859_X_BODY(5);
FROMUCS2TO8859_X_BODY(6);
FROMUCS2TO8859_X_BODY(7);
FROMUCS2TO8859_X_BODY(8);
FROMUCS2TO8859_X_BODY(9);
FROMUCS2TO8859_X_BODY(10);
FROMUCS2TO8859_X_BODY(13);
FROMUCS2TO8859_X_BODY(14);
FROMUCS2TO8859_X_BODY(15);

CCC_NAMESPACE_END(CCC);
