﻿// @@DISTHDR@@
// $Id$

#ifndef INCLUDE_ccc_iceman_iso8859conv_h
#define INCLUDE_ccc_iceman_iso8859conv_h

#include <ccc/base/PushbackIFilter.h>
#include <ccc/iceman/Iceman.h>

CCC_NAMESPACE_START(CCC);

class From8859ToUcs2
  : public UInt16PushbackIFilter
{
  UInt16* tbl;
  
 public:
  enum From
  {
    FROM_ISO8859_1 = 1,
    FROM_ISO8859_2 = 2,
    FROM_ISO8859_3 = 3,
    FROM_ISO8859_4 = 4,
    FROM_ISO8859_5 = 5,
    FROM_ISO8859_6 = 6,
    FROM_ISO8859_7 = 7,
    FROM_ISO8859_8 = 8,
    FROM_ISO8859_9 = 9,
    FROM_ISO8859_10 = 10,
    FROM_ISO8859_13 = 13,
    FROM_ISO8859_14 = 14,
    FROM_ISO8859_15 = 15,
  };
    
 public:
  From8859ToUcs2(From f);
  ~From8859ToUcs2();
  virtual UInt16 getUInt16() CCC_RAISES(IOException);
};

#define FROM8859_XTOUCS2_DECL(x) \
class From8859_## x ##ToUcs2\
  : public From8859ToUcs2\
{\
 public:\
  From8859_## x ##ToUcs2();\
  ~From8859_## x ##ToUcs2();\
  static IFilter* createIFilter();\
}

FROM8859_XTOUCS2_DECL(1);
FROM8859_XTOUCS2_DECL(2);
FROM8859_XTOUCS2_DECL(3);
FROM8859_XTOUCS2_DECL(4);
FROM8859_XTOUCS2_DECL(5);
FROM8859_XTOUCS2_DECL(6);
FROM8859_XTOUCS2_DECL(7);
FROM8859_XTOUCS2_DECL(8);
FROM8859_XTOUCS2_DECL(9);
FROM8859_XTOUCS2_DECL(10);
FROM8859_XTOUCS2_DECL(13);
FROM8859_XTOUCS2_DECL(14);
FROM8859_XTOUCS2_DECL(15);

class From8859_xToUsAscii
  : public Int8PushbackIFilter
{
 public:
  From8859_xToUsAscii();
  ~From8859_xToUsAscii();
  static IFilter* createIFilter();
  virtual Int8 getInt8() CCC_RAISES(IOException);
};

class FromUsAsciiTo8859_x
  : public Int8PushbackIFilter
{
 public:
  FromUsAsciiTo8859_x();
  ~FromUsAsciiTo8859_x();
  static IFilter* createIFilter();
  virtual Int8 getInt8() CCC_RAISES(IOException);
};

#define FROMUCS2TO8859_X_DECL(x) \
  class FromUcs2To8859_## x \
  : public Int8PushbackIFilter\
{\
 public:\
  FromUcs2To8859_## x ();\
  ~FromUcs2To8859_## x ();\
  static IFilter* createIFilter();\
  virtual Int8 getInt8() CCC_RAISES(IOException); \
}

FROMUCS2TO8859_X_DECL(1);
FROMUCS2TO8859_X_DECL(2);
FROMUCS2TO8859_X_DECL(3);
FROMUCS2TO8859_X_DECL(4);
FROMUCS2TO8859_X_DECL(5);
FROMUCS2TO8859_X_DECL(6);
FROMUCS2TO8859_X_DECL(7);
FROMUCS2TO8859_X_DECL(8);
FROMUCS2TO8859_X_DECL(9);
FROMUCS2TO8859_X_DECL(10);
FROMUCS2TO8859_X_DECL(13);
FROMUCS2TO8859_X_DECL(14);
FROMUCS2TO8859_X_DECL(15);

CCC_NAMESPACE_END(CCC);

#endif /* INCLUDE_ccc_iceman_iso8859conv_h */
