﻿// @@DISTHDR@@
// $Id$

#ifndef MKTABLE
#include <ccc/base/base.h>
#include <ccc/iceman/jpcode.h>

CCC_NAMESPACE_START(CCC);

void
sjisToEucJp(UInt8 i1, UInt8 i2, UInt8* c1, UInt8* c2)
{
  if (i2 >= 0x9f)
  {
    if (i1 >= 0xe0)
    {
      *c1 = (unsigned short int)i1 * 2 - 0xe0;
    }
    else
    {
      *c1 = (unsigned short int)i1 * 2 - 0x60;
    }
    *c2 = i2 + 2;
  }
  else
  {
    if (i1 >= 0xe0)
    {
      *c1 = (unsigned short int)i1 * 2 - 0xe1;
    }
    else
    {
      *c1 = (unsigned short int)i1 * 2 - 0x61;
    }
    if (i2 >= 0x7f)
    {
      *c2 = i2 + 0x60;
    }
    else
    {
      *c2 = i2 +  0x61;
    }
  }
}

void
sjisToJis(UInt8 i1, UInt8 i2, UInt8* c1, UInt8* c2)
{
  if (i2 >= 0x9f)
  {
    *c1 = ((unsigned short int)i1 * 2 - ((i1 >= 0xe0) ? 0xe0 : 0x60)) & 0x7f;
    *c2 = i2 - 0x7e;
  }
  else
  {
    *c1 = ((unsigned short int)i1 * 2 - ((i1 >= 0xe0) ? 0xe1 : 0x61)) & 0x7f;
    *c2 = (i2 + ((i2 >= 0x7f) ? 0x60 : 0x61)) & 0x7f;
  }
}

void
eucJpToSjis(UInt8 i1, UInt8 i2, UInt8* c1, UInt8* c2)
{
  if (i1 & 1)
  {
    if (i1 < 0xdf)
    {
      *c1 = i1 / 2 + 0x31;
    }
    else
    {
      *c1 = i1 / 2 + 0x71;
    }
    if (i2 >= 0xe0)
    {
      *c2 = i2 - 0x60;
    }
    else
    {
      *c2 = i2 - 0x61;
    }
  }
  else
  {
    if (i1 < 0xdf)
    {
      *c1 = i1 / 2 + 0x30;
    }
    else
    {
      *c1 = i1 / 2 + 0x70;
    }
    *c2 = i2 - 2;
  }
}

void
eucJpToJis(UInt8 i1, UInt8 i2, UInt8* c1, UInt8* c2)
{
  *c1 = i1 - 0x80u;
  *c2 = i2 - 0x80u;
}

void
jisToSjis(UInt8 i1, UInt8 i2, UInt8* c1, UInt8* c2)
{
  i1 |= 0x80; i2 |= 0x80;
  if (i1 & 1)
  {
    *c1 = i1/2 + ((i1 < 0xdf) ? 0x31 : 0x71);
    *c2 = i2 - ((i2 >= 0xe0) ? 0x60 : 0x61);
  }
  else
  {
    *c1 = i1/2 + ((i1 < 0xdf) ? 0x30 : 0x70);
    *c2 = i2 - 2;
  }
}

void
jisToEucJp(UInt8 i1, UInt8 i2, UInt8* c1, UInt8* c2)
{
  *c1 = i1 + 0x80u;
  *c2 = i2 + 0x80u;
}

UInt8 iceman_jcode_table[256] =
{
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
  0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 
  0x10, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 
  0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 
  0x10, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 
  0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 
  0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 
  0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 
  0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 
  0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x04, 0x04, 0x00, 
};

#endif /* MKTABLE */

#ifdef MKTABLE
/*
 * for making table
 */
#include <stdio.h>

typedef unsigned char UInt8;

const UInt8 iceman_kanji_sjis = 1;
const UInt8 iceman_kanji_jis = 2;
const UInt8 iceman_kanji_euc = 4;
const UInt8 iceman_kanji_sjis_hankakukana = 8;
const UInt8 iceman_kanji_sjis_2ndbyte = 16;

UInt8 jcode_table[256];

void
init_jcode_table()
{
  unsigned int i;
  for (i = 0; i < 256; i++)
  {
    jcode_table[i] = 0;
  }
  for (i = 0x81; i <= 0x9f; i++)
  {
    jcode_table[i] |= iceman_kanji_sjis;
  }
  for (i = 0xe0; i <= 0xef; i++)
  {
    jcode_table[i] |= iceman_kanji_sjis;
  }
  for (i = 0x21; i < 0x7f; i++)
  {
    jcode_table[i] |= iceman_kanji_jis;
  }
  for (i = 0xa1; i < 0xff; i++)
  {
    jcode_table[i] |= iceman_kanji_euc;
  }
  for (i = 0xa1; i <= 0xdf; i++)
  {
    jcode_table[i] |= iceman_kanji_sjis_hankakukana;
  }
  for (i = 0x40; i <= 0x7f; i++)
  {
    jcode_table[i] |= iceman_kanji_sjis_2ndbyte;
  }
  for (i = 0x80; i <= 0xfc; i++)
  {
    jcode_table[i] |= iceman_kanji_sjis_2ndbyte;
  }
}

main()
{
  int i, j;
  init_jcode_table();
  for (i = 0; i < 16; i++)
  {
    printf("  ");
    for (j = 0; j < 16; j++)
    {
      printf("0x%02x, ", jcode_table[i * 16 + j]);
    }
    printf("\n");
  }
}
#endif /* MKTABLE */

CCC_NAMESPACE_END(CCC);
