﻿// @@DISTHDR@@
// $Id$

#ifndef INCLUDE_ccc_iceman_jpcode_h
#define INCLUDE_ccc_iceman_jpcode_h

#include <ccc/iceman/Iceman.h>
#include <ccc/iceman/i18ncode.h>

CCC_NAMESPACE_START(CCC);

// Kanji Check table
extern UInt8 iceman_jcode_table[256];
const UInt8 iceman_kanji_sjis = 1;
const UInt8 iceman_kanji_jis = 2;
const UInt8 iceman_kanji_euc = 4;
const UInt8 iceman_kanji_sjis_hankakukana = 8;
const UInt8 iceman_kanji_sjis_2ndbyte = 16;

inline bool sjisKanjiP(UInt8 c) { return !!(iceman_jcode_table[c] & iceman_kanji_sjis); }
inline bool jisKanjiP(UInt8 c) { return !!(iceman_jcode_table[c] & iceman_kanji_jis); }
inline bool eucKanjiP(UInt8 c) { return !!(iceman_jcode_table[c] & iceman_kanji_euc); }

/*!
 * check CP932 code
 * NOTE: This funciton returns false in case of ascii or hankaku kana.
 * \parm c1 1st byte
 * \param c2 2nd byte
 * \retval true is cp932
 * \retval false is not cp932
 */
bool cp932P(UInt8 c1, UInt8 c2);
/*!
 * check CP932 code
 * NOTE: This funciton returns false in case of ascii or hankaku kana.
 * \parm c character
 * \retval true is cp932
 * \retval false is not cp932
 */
bool cp932P(UInt16 c);
/*!
 * check CP932 code with gaiji
 * NOTE: This funciton returns false in case of ascii or hankaku kana.
 * \parm c1 1st byte
 * \param c2 2nd byte
 * \retval true is cp932
 * \retval false is not cp932
 */
bool cp932WithGaijiP(UInt8 c1, UInt8 c2);
/*!
 * check CP932 code with gaiji
 * NOTE: This funciton returns false in case of ascii or hankaku kana.
 * \parm c character
 * \retval true is cp932
 * \retval false is not cp932
 */
bool cp932WithGaijiP(UInt16 c);

// Kanji code conversion
void sjisToEucJp(UInt8 i1, UInt8 i2, UInt8* c1, UInt8* c2);
void sjisToJis(UInt8 i1, UInt8 i2, UInt8* c1, UInt8* c2);
void eucJpToSjis(UInt8 i1, UInt8 i2, UInt8* c1, UInt8* c2);
void eucJpToJis(UInt8 i1, UInt8 i2, UInt8* c1, UInt8* c2);
void jisToSjis(UInt8 i1, UInt8 i2, UInt8* c1, UInt8* c2);
void jisToEucJp(UInt8 i1, UInt8 i2, UInt8* c1, UInt8* c2);

// EUC-JP
//
// C0:	ASCII, JIS-0201 Roman
// C1:	JIS X 0208-1990
// C2:	Half-width katakana
// C3:	JIS X 0212-1990
inline bool eucJpJisx0208B1P(UInt8 c) { return (c >= 0xa1u) && (c <= 0xfeu); }
inline bool eucJpJisx0208B2P(UInt8 c) { return (c >= 0xa1u) && (c <= 0xfeu); }
inline bool eucJpKatakanaStartP(UInt8 c) { return eucSs2P(c); }
inline bool eucJpJisx0212StartP(UInt8 c) { return eucSs3P(c); }

// ISO-2022-JP: RFC1468
//
// Esc Seq    Character Set                  ISOREG
// ESC ( B    ASCII                             6
// ESC ( J    JIS X 0201-1976 ("Roman" set)    14
// ESC $ @    JIS X 0208-1978                  42
// ESC $ B    JIS X 0208-1983                  87

enum Iso2022JpStat
{
  ISO2022JPSTAT_ASCII = 1,
  ISO2022JPSTAT_JISX0201_1976,
  ISO2022JPSTAT_JISX0208_1978,
  ISO2022JPSTAT_JISX0208_1983,
};

Iso2022JpStat getIso2022JpFindStat(UInt8 esc1, UInt8 esc2);

// Shift_JIS: JIS X 0208:1997 supplementary note 1
//
// FIRST BYTE
// 0x00-0x1f	JISX0211 C0
// 0x20-0x7f
// 0x80		reserved
// 0x81-0x9f	2 byte char 1st byte
// 0xa0		reserved
// 0xa1-0xdf	hankaku kana
// 0xe0-0xef	2 byte char 1st byte
// 0xf0-0xff	reserved
//
// SECOND BYTE
// 0x00-0x3f	reserved
// 0x40-0x7e	2nd byte
// 0x7f		reserved
// 0x80-0xfc	2nd byte
// 0xfd-0xff	reserved

inline bool sjisHankakuKanaP(UInt8 c) { return !!(iceman_jcode_table[c] & iceman_kanji_sjis_hankakukana); }
inline bool sjisKanji1stByteP(UInt8 c) { return sjisKanjiP(c); }
inline bool sjisKanji2ndByteP(UInt8 c) { return !!(iceman_jcode_table[c] & iceman_kanji_sjis_2ndbyte); }

CCC_NAMESPACE_END(CCC);

#endif /* INCLUDE_ccc_iceman_jpcode_h */
