﻿// @@DISTHDR@@
// $Id$

#ifndef INCLUDE_ccc_iceman_jpcodeconv_h
#define INCLUDE_ccc_iceman_jpcodeconv_h

#include <ccc/base/PushbackIFilter.h>
#include <ccc/iceman/jpcode.h>

CCC_NAMESPACE_START(CCC);

class FromEucJpToSjis
  : public Int8PushbackIFilter
{
 public:
  FromEucJpToSjis();
  ~FromEucJpToSjis();
  virtual Int8 getInt8() CCC_RAISES(IOException);
  static IFilter* createIFilter();
};

class FromSjisToEucJp
  : public Int8PushbackIFilter
{
 public:
  FromSjisToEucJp();
  ~FromSjisToEucJp();
  virtual Int8 getInt8() CCC_RAISES(IOException);
  static IFilter* createIFilter();
};

class FromIso2022JpToSjis
  : Int8PushbackIFilter
{
  Iso2022JpStat status;

 private:
  void clear();
  
 public:
  FromIso2022JpToSjis();
  ~FromIso2022JpToSjis();
  virtual bool rewind();
  virtual Int8 getInt8() CCC_RAISES(IOException);
  static IFilter* createIFilter();
};

class FromEucJpToIso2022Jp
  : Int8PushbackIFilter
{
  Iso2022JpStat status;

 private:
  void clear();

 public:
  FromEucJpToIso2022Jp();
  ~FromEucJpToIso2022Jp();
  virtual bool rewind();
  virtual Int8 getInt8() CCC_RAISES(IOException);
  static IFilter* createIFilter();
};

class FromSjisToIso2022Jp
  : Int8PushbackIFilter
{
  Iso2022JpStat status;

 private:
  void clear();

 public:
  FromSjisToIso2022Jp();
  ~FromSjisToIso2022Jp();
  virtual bool rewind();
  virtual Int8 getInt8() CCC_RAISES(IOException);
  static IFilter* createIFilter();
};

class FromIso2022JpToEucJp
  : Int8PushbackIFilter
{
  Iso2022JpStat status;

 private:
  void clear();

 public:
  FromIso2022JpToEucJp();
  ~FromIso2022JpToEucJp();
  virtual bool rewind();
  virtual Int8 getInt8() CCC_RAISES(IOException);
  static IFilter* createIFilter();
};

class FromUcs2ToSjis
  : Int8PushbackIFilter
{
 public:
  FromUcs2ToSjis();
  ~FromUcs2ToSjis();
  virtual Int8 getInt8() CCC_RAISES(IOException);
  static IFilter* createIFilter();
};

class FromUcs2ToEucJp
  : Int8PushbackIFilter
{
 public:
  FromUcs2ToEucJp();
  ~FromUcs2ToEucJp();
  virtual Int8 getInt8() CCC_RAISES(IOException);
  static IFilter* createIFilter();
};

class FromUcs2ToIso2022Jp
  : Int8PushbackIFilter
{
  Iso2022JpStat status;

 private:
  void clear();
  
 public:
  FromUcs2ToIso2022Jp();
  ~FromUcs2ToIso2022Jp();
  virtual bool rewind();
  virtual Int8 getInt8() CCC_RAISES(IOException);
  static IFilter* createIFilter();
};

class FromSjisToUcs2
  : UInt16PushbackIFilter
{
 public:
  FromSjisToUcs2();
  ~FromSjisToUcs2();
  virtual UInt16 getUInt16() CCC_RAISES(IOException);
  static IFilter* createIFilter();
};

// TODO: 
//class FromEucJpToUcs2;
//class FromIso2022JpToUcs2;

class FromCp932ToUcs2
  : UInt16PushbackIFilter
{
 public:
  FromCp932ToUcs2();
  ~FromCp932ToUcs2();
  virtual UInt16 getUInt16() CCC_RAISES(IOException);
  static IFilter* createIFilter();
};

class FromUcs2ToCp932
  : Int8PushbackIFilter
{
 public:
  FromUcs2ToCp932();
  ~FromUcs2ToCp932();
  virtual Int8 getInt8() CCC_RAISES(IOException);
  static IFilter* createIFilter();
};

class FromEucJpMsToCp932
  : public FromEucJpToSjis
{
 public:
  FromEucJpMsToCp932();
  ~FromEucJpMsToCp932();
  //virtual Int8 getInt8() CCC_RAISES(IOException);
  static IFilter* createIFilter();
};

class FromCp932ToEucJpMs
  : public FromSjisToEucJp
{
 public:
  FromCp932ToEucJpMs();
  ~FromCp932ToEucJpMs();
  //virtual Int8 getInt8() CCC_RAISES(IOException);
  static IFilter* createIFilter();
};

CCC_NAMESPACE_END(CCC);

#endif /* INCLUDE_ccc_iceman_jpcodeconv_h */
