﻿// @@DISTHDR@@
// $Id$

#include <ccc/iceman/Iceman.h>

CCC_NAMESPACE_START(CCC);

UInt8
toLower(UInt8 c)
{
  if ((c >= 'A') && (c <= 'Z'))
  {
    return c += 'a' - 'A';
  }
  return c;
}

UInt8
toUpper(UInt8 c)
{
  if ((c >= 'a') && (c <= 'z'))
  {
    return c -= 'a' - 'A';
  }
  return c;
}

#ifndef HAVE_STRCASECMP
extern "C" int
strcasecmp(const char* s1, const char* s2)
{
  const UInt8 *us1 = (const UInt8 *)s1;
  const UInt8 *us2 = (const UInt8 *)s2;
  while (toLower(*us1) == toLower(*us2++))
  {
    if (*us1++ == '\0')
    {
      return 0;
    }
  }
  return (toLower(*us1) - toLower(*--us2));
}
#endif /* HAVE_STRCASECMP */

CCC_NAMESPACE_END(CCC);
