﻿// @@DISTHDR@@
// $Id$

#include <stdio.h>
#include <assert.h>
#include <ccc/iceman/sparsearray.h>

CCC_NAMESPACE_USING_NAMESPACE(CCC);

struct FromToMap
{
  UInt16 from;
  UInt16 to;
};

static FromToMap from_to_map[] =
{
#ifdef UCS2TOJISX0208
#  include "map/jisx0208_uni.map"
#  define INVERT
#endif /* UCS2TOJISX0208 */
#ifdef UCS2TOSJIS
#  include "map/sjis_uni.map"
#  define INVERT
#endif /* UCS2TOSJIS */
#ifdef SJISTOUCS2
#  include "map/sjis_uni.map"
#endif /* SJISTOUCS2 */
#ifdef CP932TOUCS2
#  include "map/cp932_uni.map"
#endif /* CP932TOUCS2 */
#ifdef UCS2TOCP932
#  include "map/cp932_uni.map"
#  define INVERT
#endif /* UCS2TOCP932 */
#ifdef CP1252TOUCS2
#  include "map/cp1252_uni.map"
#endif /* CP1252TOUCS2 */
#ifdef UCS2TOCP1252
#  include "map/cp1252_uni.map"
#  define INVERT
#endif /* UCS2TOCP1252 */
#ifdef UCS2TOISO2022JP
#  define NHALFWIDHKANA
#  include "map/jisx0201_uni.map"
#  include "map/jisx0208_uni.map"
#  define INVERT
#endif /* UCS2TOISO2022JP */
#ifdef UCS2TOISO8859_1
#  define MAP8859(m, u) { m, u, },
#  include "map/8859-1_uni.map"
#  define INVERT
#endif /* UCS2TOISO8859_1 */
#ifdef UCS2TOISO8859_2
#  define MAP8859(m, u) { m, u, },
#  include "map/8859-2_uni.map"
#  define INVERT
#endif /* UCS2TOISO8859_2 */
#ifdef UCS2TOISO8859_3
#  define MAP8859(m, u) { m, u, },
#  include "map/8859-3_uni.map"
#  define INVERT
#endif /* UCS2TOISO8859_3 */
#ifdef UCS2TOISO8859_4
#  define MAP8859(m, u) { m, u, },
#  include "map/8859-4_uni.map"
#  define INVERT
#endif /* UCS2TOISO8859_4 */
#ifdef UCS2TOISO8859_5
#  define MAP8859(m, u) { m, u, },
#  include "map/8859-5_uni.map"
#  define INVERT
#endif /* UCS2TOISO8859_5 */
#ifdef UCS2TOISO8859_6
#  define MAP8859(m, u) { m, u, },
#  include "map/8859-6_uni.map"
#  define INVERT
#endif /* UCS2TOISO8859_6 */
#ifdef UCS2TOISO8859_7
#  define MAP8859(m, u) { m, u, },
#  include "map/8859-7_uni.map"
#  define INVERT
#endif /* UCS2TOISO8859_7 */
#ifdef UCS2TOISO8859_8
#  define MAP8859(m, u) { m, u, },
#  include "map/8859-8_uni.map"
#  define INVERT
#endif /* UCS2TOISO8859_8 */
#ifdef UCS2TOISO8859_9
#  define MAP8859(m, u) { m, u, },
#  include "map/8859-9_uni.map"
#  define INVERT
#endif /* UCS2TOISO8859_9 */
#ifdef UCS2TOISO8859_10
#  define MAP8859(m, u) { m, u, },
#  include "map/8859-10_uni.map"
#  define INVERT
#endif /* UCS2TOISO8859_10 */
#ifdef UCS2TOISO8859_13
#  define MAP8859(m, u) { m, u, },
#  include "map/8859-13_uni.map"
#  define INVERT
#endif /* UCS2TOISO8859_13 */
#ifdef UCS2TOISO8859_14
#  define MAP8859(m, u) { m, u, },
#  include "map/8859-14_uni.map"
#  define INVERT
#endif /* UCS2TOISO8859_14 */
#ifdef UCS2TOISO8859_15
#  define MAP8859(m, u) { m, u, },
#  include "map/8859-15_uni.map"
#  define INVERT
#endif /* UCS2TOISO8859_15 */
  { 0, 0 },	// EOF
};

static UInt16 bit[16] = 
{
  0x0001, 0x0002, 0x0004, 0x0008,
  0x0010, 0x0020, 0x0040, 0x0080,
  0x0100, 0x0200, 0x0400, 0x0800,
  0x1000, 0x2000, 0x4000, 0x8000,
};

int
main()
{
  static UInt16 to[0x10000];
  
  int i;
  for (i = 0; i <= 0xffff; i++)
  {
    to[i] = 0xffff;
  }

  FromToMap* p = from_to_map;
  while (p->from || p == from_to_map)
  {
#ifdef INVERT
    to[p->to] = p->from;
#else /* INVERT */
    to[p->from] = p->to;
#endif /* INVERT */
    p++;
  }

  int x;
#ifdef DEBUG  
  x = 0;
  printf("\n//  0000: ");
  for (i = 0; i <= 0xffff; i++)
  {
    printf("%04X, ", to[i]);
    if (++x == 16)
    {
      printf("\n//  %04X: ", i + 1);
      x = 0;
    }
  }
  printf("\n");
#endif

  static Sparse16Map map1[0x1000];
  static Sparse16Map map2[0x100];

  printf("#include <ccc/iceman/sparsearray.h>\n");
  printf("#include <ccc/iceman/ucs2to.h>\n");

  printf("\n");
  printf("CCC_NAMESPACE_START(CCC);\n");
  printf("\n");

  // print map0
  printf("// map0\n");
  printf("static UInt16 map0[] =\n");
  printf("{\n");
  printf("  ");
  x = 0;
  for (i = 0; i <= 0xffff; i++)
  {
    if (to[i] != 0xffff)
    {
      printf("0x%04X, ", to[i]);
      x++;
    }
    if (x == 8)
    {
      printf("\n  ");
      x = 0;
    }
  }
  printf("\n};\n\n");

  // print map1
  printf("// map1\n");
  printf("static Sparse16Map map1[] =\n");
  printf("{\n");

  UInt16 offset = 0;
  for (i = 0; i <= 0xfff; i++)
  {
    UInt16 map = 0;
    int n = 0;
    for (int j = 0; j <= 0xf; j++)
    {
      if (to[i * 0x10 + j] != 0xffff)
      {
	//printf("%d:0x%04X, ", j, to[i * 0x10 + j]);
	map |= bit[j];
	n++;
      }
    }
    assert(i <= 0xfff);
    map1[i].map = map;
    map1[i].offset = offset;
    if (map)
    {
      printf("  { 0x%04X, %d },", map, offset);
      printf("\t// 0x%03X0\n", i);
    }
    offset += n;
  }
  printf("};\n\n");

  // print map2
  printf("// map2\n");
  printf("static Sparse16Map map2[] =\n");
  printf("{\n");

  offset = 0;
  for (i = 0; i <= 0xff; i++)
  {
    UInt16 map = 0;
    int n = 0;
    for (int j = 0; j <= 0xf; j++)
    {
      if (map1[i * 0x10 + j].map)
      {
	//printf("0x%03X0\n", i * 0x10 + j);
	map |= bit[j];
	n++;
      }
    }
    assert(i <= 0xff);
    map2[i].map = map;
    map2[i].offset = offset;
    //if (map)
    {
      printf("  { 0x%04X, %d },", map, offset);
      printf("\t// 0x%02X00\n", i);
    }
    offset += n;
  }
  printf("};\n\n");

  // print convert func
  printf("UInt16\n");
#ifdef UCS2TOJISX0208
  printf("convertFromUcs2ToJisX0208(UInt16 from)\n");
#endif /* UCS2TOJISX0208 */
#ifdef UCS2TOSJIS
  printf("convertFromUcs2ToSjis(UInt16 from)\n");
#endif /* UCS2TOSJIS */
#ifdef SJISTOUCS2
  printf("convertFromSjisToUcs2(UInt16 from)\n");
#endif /* SJISTOUCS2 */
#ifdef CP932TOUCS2
  printf("convertFromCp932ToUcs2(UInt16 from)\n");
#endif /* CP932TOUCS2 */
#ifdef UCS2TOCP932
  printf("convertFromUcs2ToCp932(UInt16 from)\n");
#endif /* UCS2TOCP932 */
#ifdef CP1252TOUCS2
  printf("convertFromCp1252ToUcs2(UInt16 from)\n");
#endif /* CP1252TOUCS2 */
#ifdef UCS2TOCP1252
  printf("convertFromUcs2ToCp1252(UInt16 from)\n");
#endif /* UCS2TOCP1252 */
#ifdef UCS2TOISO2022JP
  printf("convertFromUcs2ToIso2022jp(UInt16 from)\n");
#endif /* UCS2TOISO2022JP */
#ifdef UCS2TOISO8859_1
  printf("convertFromUcs2ToIso8859_1(UInt16 from)\n");
#endif /* UCS2TOISO8859_1 */
#ifdef UCS2TOISO8859_2
  printf("convertFromUcs2ToIso8859_2(UInt16 from)\n");
#endif /* UCS2TOISO8859_2 */
#ifdef UCS2TOISO8859_3
  printf("convertFromUcs2ToIso8859_3(UInt16 from)\n");
#endif /* UCS2TOISO8859_3 */
#ifdef UCS2TOISO8859_4
  printf("convertFromUcs2ToIso8859_4(UInt16 from)\n");
#endif /* UCS2TOISO8859_4 */
#ifdef UCS2TOISO8859_5
  printf("convertFromUcs2ToIso8859_5(UInt16 from)\n");
#endif /* UCS2TOISO8859_5 */
#ifdef UCS2TOISO8859_6
  printf("convertFromUcs2ToIso8859_6(UInt16 from)\n");
#endif /* UCS2TOISO8859_6 */
#ifdef UCS2TOISO8859_7
  printf("convertFromUcs2ToIso8859_7(UInt16 from)\n");
#endif /* UCS2TOISO8859_7 */
#ifdef UCS2TOISO8859_8
  printf("convertFromUcs2ToIso8859_8(UInt16 from)\n");
#endif /* UCS2TOISO8859_8 */
#ifdef UCS2TOISO8859_9
  printf("convertFromUcs2ToIso8859_9(UInt16 from)\n");
#endif /* UCS2TOISO8859_9 */
#ifdef UCS2TOISO8859_10
  printf("convertFromUcs2ToIso8859_10(UInt16 from)\n");
#endif /* UCS2TOISO8859_10 */
#ifdef UCS2TOISO8859_13
  printf("convertFromUcs2ToIso8859_13(UInt16 from)\n");
#endif /* UCS2TOISO8859_13 */
#ifdef UCS2TOISO8859_14
  printf("convertFromUcs2ToIso8859_14(UInt16 from)\n");
#endif /* UCS2TOISO8859_14 */
#ifdef UCS2TOISO8859_15
  printf("convertFromUcs2ToIso8859_15(UInt16 from)\n");
#endif /* UCS2TOISO8859_15 */
  printf("{\n");
  printf("  return accessSarceArray(from, map0, map1, map2);\n");
  printf("}\n");
  
  printf("\n");
  printf("CCC_NAMESPACE_END(CCC);\n");

  return 0;
}

