﻿// @@DISTHDR@@
// sparse array
// $Id$

//#include <stdio.h>
#include <ccc/iceman/sparsearray.h>

CCC_NAMESPACE_START(CCC);

// bit number table
//
// NOTE: This data is generated by following code.
//
// int
// bit_num(int b)
// {
//   int i;
//   int n = 0;
//   for (i = 0; i < 8; i++)
//   {
//     if (b & 0x01)
//     {
//       n++;
//     }
//     b >>= 1;
//   }
//   return n;
// }
//
// int
// main()
// {
//   int i;
//   for (i = 0x00; i <= 0xff; i++)
//   {
//     printf("%d, ", bit_num(i));
//   }
// }
static unsigned char bit_num[] =
{
  0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4,
  1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5,
  1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
  1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 
};

static unsigned short int bit_bit[] =
{
  0x0001,
  0x0002,
  0x0004,
  0x0008,
  0x0010,
  0x0020,
  0x0040,
  0x0080,
  0x0100,
  0x0200,
  0x0400,
  0x0800,
  0x1000,
  0x2000,
  0x4000,
  0x8000,
};

static unsigned short int bit_mask[] =
{
  0x0001,
  0x0003,
  0x0007,
  0x000f,
  0x001f,
  0x003f,
  0x007f,
  0x00ff,
  0x01ff,
  0x03ff,
  0x07ff,
  0x0fff,
  0x1fff,
  0x3fff,
  0x7fff,
  0xffff,
};

UInt16
getSparseOffset(Sparse16Map* table, UInt16 n)
{
  n &= 0x000f;
  UInt16 map = table->map;
  // printf("table_map:%04X table_offset:%04X n:%04X ", map, table->offset, n);
  if (!(map & bit_bit[n]))
  {
    return SPARSE_NOT_FOUND;
  }
  map &= bit_mask[n];
  UInt16 offset = bit_num[map & 0xff];
  offset += bit_num[map >> 8];
  // printf("offset:%04x ", offset - 1);
  return offset - 1 + table->offset;
}

UInt16
accessSarceArray(UInt16 index, UInt16* map0, Sparse16Map* map1, Sparse16Map* map2)
{
  UInt16 map2_index = index >> 8;
  if (!map2[map2_index].map)
  {
    return SPARSE_NOT_FOUND;
  }
  // printf("index:%04X ", index);
  UInt16 map1_index = getSparseOffset(&map2[map2_index], index >> 4);
  if (map1_index == SPARSE_NOT_FOUND)
  {
    return SPARSE_NOT_FOUND;
  }
  //  printf("index:%04x map1_index:%04x\n", index, map1_index);
  UInt16 map0_index = getSparseOffset(&map1[map1_index], index);
  if (map0_index == SPARSE_NOT_FOUND)
  {
    return SPARSE_NOT_FOUND;
  }
  return map0[map0_index];
}

CCC_NAMESPACE_END(CCC);

