﻿#include <ccc/iceman/sparsearray.h>
#include <ccc/iceman/ucs2to.h>

CCC_NAMESPACE_START(CCC);

// map0
static UInt16 map0[] =
{
  0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007, 
  0x0008, 0x0009, 0x000A, 0x000B, 0x000C, 0x000D, 0x000E, 0x000F, 
  0x0010, 0x0011, 0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017, 
  0x0018, 0x0019, 0x001A, 0x001B, 0x001C, 0x001D, 0x001E, 0x001F, 
  0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027, 
  0x0028, 0x0029, 0x002A, 0x002B, 0x002C, 0x002D, 0x002E, 0x002F, 
  0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 
  0x0038, 0x0039, 0x003A, 0x003B, 0x003C, 0x003D, 0x003E, 0x003F, 
  0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 
  0x0048, 0x0049, 0x004A, 0x004B, 0x004C, 0x004D, 0x004E, 0x004F, 
  0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 
  0x0058, 0x0059, 0x005A, 0x005B, 0x005C, 0x005D, 0x005E, 0x005F, 
  0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 
  0x0068, 0x0069, 0x006A, 0x006B, 0x006C, 0x006D, 0x006E, 0x006F, 
  0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 
  0x0078, 0x0079, 0x007A, 0x007B, 0x007C, 0x007D, 0x007E, 0x007F, 
  0x0080, 0x0081, 0x0082, 0x0083, 0x0084, 0x0085, 0x0086, 0x0087, 
  0x0088, 0x0089, 0x008A, 0x008B, 0x008C, 0x008D, 0x008E, 0x008F, 
  0x0090, 0x0091, 0x0092, 0x0093, 0x0094, 0x0095, 0x0096, 0x0097, 
  0x0098, 0x0099, 0x009A, 0x009B, 0x009C, 0x009D, 0x009E, 0x009F, 
  0x00A0, 0x00A3, 0x00A7, 0x00A9, 0x00AD, 0x00AE, 0x00B6, 0x00C0, 
  0x00C1, 0x00C2, 0x00C3, 0x00C4, 0x00C5, 0x00C6, 0x00C7, 0x00C8, 
  0x00C9, 0x00CA, 0x00CB, 0x00CC, 0x00CD, 0x00CE, 0x00CF, 0x00D1, 
  0x00D2, 0x00D3, 0x00D4, 0x00D5, 0x00D6, 0x00D8, 0x00D9, 0x00DA, 
  0x00DB, 0x00DC, 0x00DD, 0x00DF, 0x00E0, 0x00E1, 0x00E2, 0x00E3, 
  0x00E4, 0x00E5, 0x00E6, 0x00E7, 0x00E8, 0x00E9, 0x00EA, 0x00EB, 
  0x00EC, 0x00ED, 0x00EE, 0x00EF, 0x00F1, 0x00F2, 0x00F3, 0x00F4, 
  0x00F5, 0x00F6, 0x00F8, 0x00F9, 0x00FA, 0x00FB, 0x00FC, 0x00FD, 
  0x00FF, 0x00A4, 0x00A5, 0x00B2, 0x00B3, 0x00D0, 0x00F0, 0x00DE, 
  0x00FE, 0x00AF, 0x00A1, 0x00A2, 0x00A6, 0x00AB, 0x00B0, 0x00B1, 
  0x00B4, 0x00B5, 0x00B7, 0x00B9, 0x00BB, 0x00BF, 0x00D7, 0x00F7, 
  0x00A8, 0x00B8, 0x00AA, 0x00BA, 0x00BD, 0x00BE, 0x00AC, 0x00BC, 
  
};

// map1
static Sparse16Map map1[] =
{
  { 0xFFFF, 0 },	// 0x0000
  { 0xFFFF, 16 },	// 0x0010
  { 0xFFFF, 32 },	// 0x0020
  { 0xFFFF, 48 },	// 0x0030
  { 0xFFFF, 64 },	// 0x0040
  { 0xFFFF, 80 },	// 0x0050
  { 0xFFFF, 96 },	// 0x0060
  { 0xFFFF, 112 },	// 0x0070
  { 0xFFFF, 128 },	// 0x0080
  { 0xFFFF, 144 },	// 0x0090
  { 0x6289, 160 },	// 0x00A0
  { 0x0040, 166 },	// 0x00B0
  { 0xFFFF, 167 },	// 0x00C0
  { 0xBF7E, 183 },	// 0x00D0
  { 0xFFFF, 196 },	// 0x00E0
  { 0xBF7E, 212 },	// 0x00F0
  { 0x0C00, 225 },	// 0x0100
  { 0x0003, 227 },	// 0x0120
  { 0x01F0, 229 },	// 0x0170
  { 0x0C0C, 234 },	// 0x1E00
  { 0xC000, 238 },	// 0x1E10
  { 0x0003, 240 },	// 0x1E40
  { 0x00C0, 242 },	// 0x1E50
  { 0x0C03, 244 },	// 0x1E60
  { 0x003F, 248 },	// 0x1E80
  { 0x000C, 254 },	// 0x1EF0
};

// map2
static Sparse16Map map2[] =
{
  { 0xFFFF, 0 },	// 0x0000
  { 0x0085, 16 },	// 0x0100
  { 0x0000, 19 },	// 0x0200
  { 0x0000, 19 },	// 0x0300
  { 0x0000, 19 },	// 0x0400
  { 0x0000, 19 },	// 0x0500
  { 0x0000, 19 },	// 0x0600
  { 0x0000, 19 },	// 0x0700
  { 0x0000, 19 },	// 0x0800
  { 0x0000, 19 },	// 0x0900
  { 0x0000, 19 },	// 0x0A00
  { 0x0000, 19 },	// 0x0B00
  { 0x0000, 19 },	// 0x0C00
  { 0x0000, 19 },	// 0x0D00
  { 0x0000, 19 },	// 0x0E00
  { 0x0000, 19 },	// 0x0F00
  { 0x0000, 19 },	// 0x1000
  { 0x0000, 19 },	// 0x1100
  { 0x0000, 19 },	// 0x1200
  { 0x0000, 19 },	// 0x1300
  { 0x0000, 19 },	// 0x1400
  { 0x0000, 19 },	// 0x1500
  { 0x0000, 19 },	// 0x1600
  { 0x0000, 19 },	// 0x1700
  { 0x0000, 19 },	// 0x1800
  { 0x0000, 19 },	// 0x1900
  { 0x0000, 19 },	// 0x1A00
  { 0x0000, 19 },	// 0x1B00
  { 0x0000, 19 },	// 0x1C00
  { 0x0000, 19 },	// 0x1D00
  { 0x8173, 19 },	// 0x1E00
  { 0x0000, 26 },	// 0x1F00
  { 0x0000, 26 },	// 0x2000
  { 0x0000, 26 },	// 0x2100
  { 0x0000, 26 },	// 0x2200
  { 0x0000, 26 },	// 0x2300
  { 0x0000, 26 },	// 0x2400
  { 0x0000, 26 },	// 0x2500
  { 0x0000, 26 },	// 0x2600
  { 0x0000, 26 },	// 0x2700
  { 0x0000, 26 },	// 0x2800
  { 0x0000, 26 },	// 0x2900
  { 0x0000, 26 },	// 0x2A00
  { 0x0000, 26 },	// 0x2B00
  { 0x0000, 26 },	// 0x2C00
  { 0x0000, 26 },	// 0x2D00
  { 0x0000, 26 },	// 0x2E00
  { 0x0000, 26 },	// 0x2F00
  { 0x0000, 26 },	// 0x3000
  { 0x0000, 26 },	// 0x3100
  { 0x0000, 26 },	// 0x3200
  { 0x0000, 26 },	// 0x3300
  { 0x0000, 26 },	// 0x3400
  { 0x0000, 26 },	// 0x3500
  { 0x0000, 26 },	// 0x3600
  { 0x0000, 26 },	// 0x3700
  { 0x0000, 26 },	// 0x3800
  { 0x0000, 26 },	// 0x3900
  { 0x0000, 26 },	// 0x3A00
  { 0x0000, 26 },	// 0x3B00
  { 0x0000, 26 },	// 0x3C00
  { 0x0000, 26 },	// 0x3D00
  { 0x0000, 26 },	// 0x3E00
  { 0x0000, 26 },	// 0x3F00
  { 0x0000, 26 },	// 0x4000
  { 0x0000, 26 },	// 0x4100
  { 0x0000, 26 },	// 0x4200
  { 0x0000, 26 },	// 0x4300
  { 0x0000, 26 },	// 0x4400
  { 0x0000, 26 },	// 0x4500
  { 0x0000, 26 },	// 0x4600
  { 0x0000, 26 },	// 0x4700
  { 0x0000, 26 },	// 0x4800
  { 0x0000, 26 },	// 0x4900
  { 0x0000, 26 },	// 0x4A00
  { 0x0000, 26 },	// 0x4B00
  { 0x0000, 26 },	// 0x4C00
  { 0x0000, 26 },	// 0x4D00
  { 0x0000, 26 },	// 0x4E00
  { 0x0000, 26 },	// 0x4F00
  { 0x0000, 26 },	// 0x5000
  { 0x0000, 26 },	// 0x5100
  { 0x0000, 26 },	// 0x5200
  { 0x0000, 26 },	// 0x5300
  { 0x0000, 26 },	// 0x5400
  { 0x0000, 26 },	// 0x5500
  { 0x0000, 26 },	// 0x5600
  { 0x0000, 26 },	// 0x5700
  { 0x0000, 26 },	// 0x5800
  { 0x0000, 26 },	// 0x5900
  { 0x0000, 26 },	// 0x5A00
  { 0x0000, 26 },	// 0x5B00
  { 0x0000, 26 },	// 0x5C00
  { 0x0000, 26 },	// 0x5D00
  { 0x0000, 26 },	// 0x5E00
  { 0x0000, 26 },	// 0x5F00
  { 0x0000, 26 },	// 0x6000
  { 0x0000, 26 },	// 0x6100
  { 0x0000, 26 },	// 0x6200
  { 0x0000, 26 },	// 0x6300
  { 0x0000, 26 },	// 0x6400
  { 0x0000, 26 },	// 0x6500
  { 0x0000, 26 },	// 0x6600
  { 0x0000, 26 },	// 0x6700
  { 0x0000, 26 },	// 0x6800
  { 0x0000, 26 },	// 0x6900
  { 0x0000, 26 },	// 0x6A00
  { 0x0000, 26 },	// 0x6B00
  { 0x0000, 26 },	// 0x6C00
  { 0x0000, 26 },	// 0x6D00
  { 0x0000, 26 },	// 0x6E00
  { 0x0000, 26 },	// 0x6F00
  { 0x0000, 26 },	// 0x7000
  { 0x0000, 26 },	// 0x7100
  { 0x0000, 26 },	// 0x7200
  { 0x0000, 26 },	// 0x7300
  { 0x0000, 26 },	// 0x7400
  { 0x0000, 26 },	// 0x7500
  { 0x0000, 26 },	// 0x7600
  { 0x0000, 26 },	// 0x7700
  { 0x0000, 26 },	// 0x7800
  { 0x0000, 26 },	// 0x7900
  { 0x0000, 26 },	// 0x7A00
  { 0x0000, 26 },	// 0x7B00
  { 0x0000, 26 },	// 0x7C00
  { 0x0000, 26 },	// 0x7D00
  { 0x0000, 26 },	// 0x7E00
  { 0x0000, 26 },	// 0x7F00
  { 0x0000, 26 },	// 0x8000
  { 0x0000, 26 },	// 0x8100
  { 0x0000, 26 },	// 0x8200
  { 0x0000, 26 },	// 0x8300
  { 0x0000, 26 },	// 0x8400
  { 0x0000, 26 },	// 0x8500
  { 0x0000, 26 },	// 0x8600
  { 0x0000, 26 },	// 0x8700
  { 0x0000, 26 },	// 0x8800
  { 0x0000, 26 },	// 0x8900
  { 0x0000, 26 },	// 0x8A00
  { 0x0000, 26 },	// 0x8B00
  { 0x0000, 26 },	// 0x8C00
  { 0x0000, 26 },	// 0x8D00
  { 0x0000, 26 },	// 0x8E00
  { 0x0000, 26 },	// 0x8F00
  { 0x0000, 26 },	// 0x9000
  { 0x0000, 26 },	// 0x9100
  { 0x0000, 26 },	// 0x9200
  { 0x0000, 26 },	// 0x9300
  { 0x0000, 26 },	// 0x9400
  { 0x0000, 26 },	// 0x9500
  { 0x0000, 26 },	// 0x9600
  { 0x0000, 26 },	// 0x9700
  { 0x0000, 26 },	// 0x9800
  { 0x0000, 26 },	// 0x9900
  { 0x0000, 26 },	// 0x9A00
  { 0x0000, 26 },	// 0x9B00
  { 0x0000, 26 },	// 0x9C00
  { 0x0000, 26 },	// 0x9D00
  { 0x0000, 26 },	// 0x9E00
  { 0x0000, 26 },	// 0x9F00
  { 0x0000, 26 },	// 0xA000
  { 0x0000, 26 },	// 0xA100
  { 0x0000, 26 },	// 0xA200
  { 0x0000, 26 },	// 0xA300
  { 0x0000, 26 },	// 0xA400
  { 0x0000, 26 },	// 0xA500
  { 0x0000, 26 },	// 0xA600
  { 0x0000, 26 },	// 0xA700
  { 0x0000, 26 },	// 0xA800
  { 0x0000, 26 },	// 0xA900
  { 0x0000, 26 },	// 0xAA00
  { 0x0000, 26 },	// 0xAB00
  { 0x0000, 26 },	// 0xAC00
  { 0x0000, 26 },	// 0xAD00
  { 0x0000, 26 },	// 0xAE00
  { 0x0000, 26 },	// 0xAF00
  { 0x0000, 26 },	// 0xB000
  { 0x0000, 26 },	// 0xB100
  { 0x0000, 26 },	// 0xB200
  { 0x0000, 26 },	// 0xB300
  { 0x0000, 26 },	// 0xB400
  { 0x0000, 26 },	// 0xB500
  { 0x0000, 26 },	// 0xB600
  { 0x0000, 26 },	// 0xB700
  { 0x0000, 26 },	// 0xB800
  { 0x0000, 26 },	// 0xB900
  { 0x0000, 26 },	// 0xBA00
  { 0x0000, 26 },	// 0xBB00
  { 0x0000, 26 },	// 0xBC00
  { 0x0000, 26 },	// 0xBD00
  { 0x0000, 26 },	// 0xBE00
  { 0x0000, 26 },	// 0xBF00
  { 0x0000, 26 },	// 0xC000
  { 0x0000, 26 },	// 0xC100
  { 0x0000, 26 },	// 0xC200
  { 0x0000, 26 },	// 0xC300
  { 0x0000, 26 },	// 0xC400
  { 0x0000, 26 },	// 0xC500
  { 0x0000, 26 },	// 0xC600
  { 0x0000, 26 },	// 0xC700
  { 0x0000, 26 },	// 0xC800
  { 0x0000, 26 },	// 0xC900
  { 0x0000, 26 },	// 0xCA00
  { 0x0000, 26 },	// 0xCB00
  { 0x0000, 26 },	// 0xCC00
  { 0x0000, 26 },	// 0xCD00
  { 0x0000, 26 },	// 0xCE00
  { 0x0000, 26 },	// 0xCF00
  { 0x0000, 26 },	// 0xD000
  { 0x0000, 26 },	// 0xD100
  { 0x0000, 26 },	// 0xD200
  { 0x0000, 26 },	// 0xD300
  { 0x0000, 26 },	// 0xD400
  { 0x0000, 26 },	// 0xD500
  { 0x0000, 26 },	// 0xD600
  { 0x0000, 26 },	// 0xD700
  { 0x0000, 26 },	// 0xD800
  { 0x0000, 26 },	// 0xD900
  { 0x0000, 26 },	// 0xDA00
  { 0x0000, 26 },	// 0xDB00
  { 0x0000, 26 },	// 0xDC00
  { 0x0000, 26 },	// 0xDD00
  { 0x0000, 26 },	// 0xDE00
  { 0x0000, 26 },	// 0xDF00
  { 0x0000, 26 },	// 0xE000
  { 0x0000, 26 },	// 0xE100
  { 0x0000, 26 },	// 0xE200
  { 0x0000, 26 },	// 0xE300
  { 0x0000, 26 },	// 0xE400
  { 0x0000, 26 },	// 0xE500
  { 0x0000, 26 },	// 0xE600
  { 0x0000, 26 },	// 0xE700
  { 0x0000, 26 },	// 0xE800
  { 0x0000, 26 },	// 0xE900
  { 0x0000, 26 },	// 0xEA00
  { 0x0000, 26 },	// 0xEB00
  { 0x0000, 26 },	// 0xEC00
  { 0x0000, 26 },	// 0xED00
  { 0x0000, 26 },	// 0xEE00
  { 0x0000, 26 },	// 0xEF00
  { 0x0000, 26 },	// 0xF000
  { 0x0000, 26 },	// 0xF100
  { 0x0000, 26 },	// 0xF200
  { 0x0000, 26 },	// 0xF300
  { 0x0000, 26 },	// 0xF400
  { 0x0000, 26 },	// 0xF500
  { 0x0000, 26 },	// 0xF600
  { 0x0000, 26 },	// 0xF700
  { 0x0000, 26 },	// 0xF800
  { 0x0000, 26 },	// 0xF900
  { 0x0000, 26 },	// 0xFA00
  { 0x0000, 26 },	// 0xFB00
  { 0x0000, 26 },	// 0xFC00
  { 0x0000, 26 },	// 0xFD00
  { 0x0000, 26 },	// 0xFE00
  { 0x0000, 26 },	// 0xFF00
};

UInt16
convertFromUcs2ToIso8859_14(UInt16 from)
{
  return accessSarceArray(from, map0, map1, map2);
}

CCC_NAMESPACE_END(CCC);
