﻿// @@DISTHDR@@
// $Id$

#ifndef INCLUDE_ccc_iceman_unicodeconv_h
#define INCLUDE_ccc_iceman_unicodeconv_h

#include <ccc/base/UInt16SwapEndianIFilter.h>
#include <ccc/base/UInt32SwapEndianIFilter.h>
#include <ccc/base/PushbackIFilter.h>
#include <ccc/iceman/Iceman.h>

CCC_NAMESPACE_START(CCC);

#if CCC_ENDIAN == CCC_LITTLE_ENDIAN
// convert from ucs2 native endian into ucs2-be
class FromUcs2ToUcs2Be
  : UInt16SwapEndianIFilter
{
 public:
  FromUcs2ToUcs2Be();
  ~FromUcs2ToUcs2Be();
  static IFilter* createIFilter();
};

// convert from ucs4 native endian into ucs4-be
class FromUcs4ToUcs4Be
  : UInt32SwapEndianIFilter
{
 public:
  FromUcs4ToUcs4Be();
  ~FromUcs4ToUcs4Be();
  static IFilter* createIFilter();
};

// convert from ucs2-be into ucs2 native endian
class FromUcs2BeToUcs2
  : UInt16SwapEndianIFilter
{
 public:
  FromUcs2BeToUcs2();
  ~FromUcs2BeToUcs2();
  static IFilter* createIFilter();
};

// convert from ucs4-be into ucs4 native endian
class FromUcs4BeToUcs4
  : UInt32SwapEndianIFilter
{
 public:
  FromUcs4BeToUcs4();
  ~FromUcs4BeToUcs4();
  static IFilter* createIFilter();
};

#elif CCC_ENDIAN == CCC_BIG_ENDIAN

// convert from ucs2 native endian into ucs2-le
class FromUcs2ToUcs2Le
  : UInt16SwapEndianIFilter
{
 public:
  FromUcs2ToUcs2Le();
  ~FromUcs2ToUcs2Le();
  static IFilter* createIFilter();
};

// convert from ucs4 native endian into ucs4-le
class FromUcs4ToUcs4Le
  : UInt32SwapEndianIFilter
{
 public:
  FromUcs4ToUcs4Le();
  ~FromUcs4ToUcs4Le();
  static IFilter* createIFilter();
};

// convert from ucs2-le into ucs2 native endian
class FromUcs2LeToUcs2
  : UInt16SwapEndianIFilter
{
 public:
  FromUcs2LeToUcs2();
  ~FromUcs2LeToUcs2();
  static IFilter* createIFilter();
};

// convert from ucs4-le into ucs4 native endian
class FromUcs4LeToUcs4
  : UInt32SwapEndianIFilter
{
 public:
  FromUcs4LeToUcs4();
  ~FromUcs4LeToUcs4();
  static IFilter* createIFilter();
};

#endif /* CCC_ENDIAN */

class FromUsAsciiToUcs2
  : public IFilter
{
 public:
  FromUsAsciiToUcs2();
  ~FromUsAsciiToUcs2();
  virtual UInt16 getUInt16() CCC_RAISES(IOException);
  virtual IOType getIOType();
  static IFilter* createIFilter();
};

class FromUsAsciiToUcs4
  : public IFilter
{
 public:
  FromUsAsciiToUcs4();
  ~FromUsAsciiToUcs4();
  virtual UInt32 getUInt32() CCC_RAISES(IOException);
  virtual IOType getIOType();
  static IFilter* createIFilter();
};

class FromUcs4ToUsAscii
  : public IFilter
{
 public:
  FromUcs4ToUsAscii();
  ~FromUcs4ToUsAscii();
  virtual Int8 getInt8() CCC_RAISES(IOException);
  virtual IOType getIOType();
  static IFilter* createIFilter();
};

class FromUtf8NToUtf8
  : public Int8PushbackIFilter
{
 public:
  FromUtf8NToUtf8();
  ~FromUtf8NToUtf8();
  virtual Int8 getInt8() CCC_RAISES(IOException);
  static IFilter* createIFilter();
};

class FromUtf8ToUtf8N
  : public Int8PushbackIFilter
{
 public:
  FromUtf8ToUtf8N();
  ~FromUtf8ToUtf8N();
  virtual Int8 getInt8() CCC_RAISES(IOException);
  static IFilter* createIFilter();
};
  
class FromUcs2ToUtf8N
  : public Int8PushbackIFilter
{
 public:
  FromUcs2ToUtf8N();
  ~FromUcs2ToUtf8N();
  virtual Int8 getInt8() CCC_RAISES(IOException);
  static IFilter* createIFilter();
};

class FromUtf8NToUcs2
  : public IFilter
{
 public:
  FromUtf8NToUcs2();
  ~FromUtf8NToUcs2();
  virtual UInt16 getUInt16() CCC_RAISES(IOException);
  virtual IOType getIOType();
  static IFilter* createIFilter();
};

class FromUtf7ToUcs2
  : public UInt16PushbackIFilter
{
  bool b64_p;
  bool has_unencoded_p;
  UInt8 unencoded;

 private:
  void clear();

 public:
  FromUtf7ToUcs2();
  ~FromUtf7ToUcs2();
  virtual bool rewind();
  virtual UInt16 getUInt16() CCC_RAISES(IOException);
  static IFilter* createIFilter();
};

class FromUcs2ToUtf7
  : public Int8PushbackIFilter
{
  bool b64_p;
  bool has_undecoded_p;
  UInt8 undecoded;

 private:
  void clear();
 public:
  FromUcs2ToUtf7();
  ~FromUcs2ToUtf7();
  virtual bool rewind();
  virtual Int8 getInt8() CCC_RAISES(IOException);
  static IFilter* createIFilter();
};

class FromUcs2ToUcs4
  : public UInt32PushbackIFilter
{
 public:
  FromUcs2ToUcs4();
  ~FromUcs2ToUcs4();
  virtual UInt32 getUInt32() CCC_RAISES(IOException);
  static IFilter* createIFilter();
};

class FromUcs4ToUcs2
  : public UInt16PushbackIFilter
{
 public:
  FromUcs4ToUcs2();
  ~FromUcs4ToUcs2();
  virtual UInt16 getUInt16() CCC_RAISES(IOException);
  static IFilter* createIFilter();
};

class FromUtf16NToUcs4
  : public UInt32PushbackIFilter
{
 public:
  FromUtf16NToUcs4();
  ~FromUtf16NToUcs4();
  virtual UInt32 getUInt32() CCC_RAISES(IOException);
  static IFilter* createIFilter();
};
  
class FromUcs4ToUtf16N
  : public UInt16PushbackIFilter
{
 public:
  FromUcs4ToUtf16N();
  ~FromUcs4ToUtf16N();
  virtual UInt16 getUInt16() CCC_RAISES(IOException);
  static IFilter* createIFilter();
};

class FromUtf16NToUtf16Be
#if CCC_ENDIAN == CCC_LITTLE_ENDIAN
  : public UInt16SwapEndianIFilter
#elif CCC_ENDIAN == CCC_BIG_ENDIAN
  : public UInt16PushbackIFilter
#endif /* CCC_ENDIAN */
{
 public:
  FromUtf16NToUtf16Be();
  ~FromUtf16NToUtf16Be();
  virtual UInt16 getUInt16() CCC_RAISES(IOException);
  static IFilter* createIFilter();
};
  
class FromUtf16NToUtf16Le
#if CCC_ENDIAN == CCC_LITTLE_ENDIAN
  : public UInt16PushbackIFilter
#elif CCC_ENDIAN == CCC_BIG_ENDIAN
  : public UInt16SwapEndianIFilter
#endif /* CCC_ENDIAN */
{
 public:
  FromUtf16NToUtf16Le();
  ~FromUtf16NToUtf16Le();
  virtual UInt16 getUInt16() CCC_RAISES(IOException);
  static IFilter* createIFilter();
};

class FromUtf16BeToUtf16N
#if CCC_ENDIAN == CCC_LITTLE_ENDIAN
  : public UInt16SwapEndianIFilter
#elif CCC_ENDIAN == CCC_BIG_ENDIAN
  : public UInt16PushbackIFilter
#endif /* CCC_ENDIAN */
{
 public:
  FromUtf16BeToUtf16N();
  ~FromUtf16BeToUtf16N();
  virtual UInt16 getUInt16() CCC_RAISES(IOException);
  static IFilter* createIFilter();
};

class FromUtf16LeToUtf16N
#if CCC_ENDIAN == CCC_LITTLE_ENDIAN
  : public UInt16PushbackIFilter
#elif CCC_ENDIAN == CCC_BIG_ENDIAN
  : public UInt16SwapEndianIFilter
#endif /* CCC_ENDIAN */
{
 public:
  FromUtf16LeToUtf16N();
  ~FromUtf16LeToUtf16N();
  virtual UInt16 getUInt16() CCC_RAISES(IOException);
  static IFilter* createIFilter();
};

class FromUtf32NToUcs4
  : public UInt32PushbackIFilter
{
 public:
  FromUtf32NToUcs4();
  ~FromUtf32NToUcs4();
  virtual UInt32 getUInt32() CCC_RAISES(IOException);
  static IFilter* createIFilter();
};
  
class FromUcs4ToUtf32N
  : public UInt32PushbackIFilter
{
 public:
  FromUcs4ToUtf32N();
  ~FromUcs4ToUtf32N();
  virtual UInt32 getUInt32() CCC_RAISES(IOException);
  static IFilter* createIFilter();
};
  
class FromUtf32NToUtf32Be
#if CCC_ENDIAN == CCC_LITTLE_ENDIAN
  : public UInt32SwapEndianIFilter
#elif CCC_ENDIAN == CCC_BIG_ENDIAN
  : public UInt32PushbackIFilter
#endif /* CCC_ENDIAN */
{
 public:
  FromUtf32NToUtf32Be();
  ~FromUtf32NToUtf32Be();
  virtual UInt32 getUInt32() CCC_RAISES(IOException);
  static IFilter* createIFilter();
};

class FromUtf32NToUtf32Le
#if CCC_ENDIAN == CCC_LITTLE_ENDIAN
  : public UInt32PushbackIFilter
#elif CCC_ENDIAN == CCC_BIG_ENDIAN
  : public UInt32SwapEndianIFilter
#endif /* CCC_ENDIAN */
{
 public:
  FromUtf32NToUtf32Le();
  ~FromUtf32NToUtf32Le();
  virtual UInt32 getUInt32() CCC_RAISES(IOException);
  static IFilter* createIFilter();
};

class FromUtf32BeToUtf32N
#if CCC_ENDIAN == CCC_LITTLE_ENDIAN
  : public UInt32SwapEndianIFilter
#elif CCC_ENDIAN == CCC_BIG_ENDIAN
  : public UInt32PushbackIFilter
#endif /* CCC_ENDIAN */
{
 public:
  FromUtf32BeToUtf32N();
  ~FromUtf32BeToUtf32N();
  virtual UInt32 getUInt32() CCC_RAISES(IOException);
  static IFilter* createIFilter();
};

class FromUtf32LeToUtf32N
#if CCC_ENDIAN == CCC_LITTLE_ENDIAN
  : public UInt32PushbackIFilter
#elif CCC_ENDIAN == CCC_BIG_ENDIAN
  : public UInt32SwapEndianIFilter
#endif /* CCC_ENDIAN */
{
 public:
  FromUtf32LeToUtf32N();
  ~FromUtf32LeToUtf32N();
  virtual UInt32 getUInt32() CCC_RAISES(IOException);
  static IFilter* createIFilter();
};

class FromUtf32NToUtf16N
  : public UInt16PushbackIFilter
{
 public:
  FromUtf32NToUtf16N();
  ~FromUtf32NToUtf16N();
  virtual UInt16 getUInt16() CCC_RAISES(IOException);
  static IFilter* createIFilter();
};

class FromUtf16NToUtf32N
  : public UInt32PushbackIFilter
{
 public:
  FromUtf16NToUtf32N();
  ~FromUtf16NToUtf32N();
  virtual UInt32 getUInt32() CCC_RAISES(IOException);
  static IFilter* createIFilter();
};

class FromUtf16NToUtf8
  : public Int8PushbackIFilter
{
 public:
  FromUtf16NToUtf8();
  ~FromUtf16NToUtf8();
  virtual Int8 getInt8() CCC_RAISES(IOException);
  static IFilter* createIFilter();
};
  
class FromUtf16NToUtf8N
  : public Int8PushbackIFilter
{
 public:
  FromUtf16NToUtf8N();
  ~FromUtf16NToUtf8N();
  virtual Int8 getInt8() CCC_RAISES(IOException);
  static IFilter* createIFilter();
};
  
class FromUtf8ToUtf16N
  : public UInt16PushbackIFilter
{
 public:
  FromUtf8ToUtf16N();
  ~FromUtf8ToUtf16N();
  virtual UInt16 getUInt16() CCC_RAISES(IOException);
  static IFilter* createIFilter();
};

class FromUtf16NToUtf16
  : public UInt16PushbackIFilter
{
 public:
  FromUtf16NToUtf16();
  ~FromUtf16NToUtf16();
  virtual UInt16 getUInt16() CCC_RAISES(IOException);
  static IFilter* createIFilter();
};

class FromUtf16ToUtf16N
  : public UInt16PushbackIFilter
{
  bool swap_p;
 public:
  FromUtf16ToUtf16N();
  ~FromUtf16ToUtf16N();
  virtual UInt16 getUInt16() CCC_RAISES(IOException);
  static IFilter* createIFilter();
};

class FromUtf32NToUtf32
  : public UInt32PushbackIFilter
{
 public:
  FromUtf32NToUtf32();
  ~FromUtf32NToUtf32();
  virtual UInt32 getUInt32() CCC_RAISES(IOException);
  static IFilter* createIFilter();
};

class FromUtf32ToUtf32N
  : public UInt32PushbackIFilter
{
  bool swap_p;
 public:
  FromUtf32ToUtf32N();
  ~FromUtf32ToUtf32N();
  virtual UInt32 getUInt32() CCC_RAISES(IOException);
  static IFilter* createIFilter();
};

class FromUcs2ToUtf16N
  : public UInt16PushbackIFilter
{
 public:
  FromUcs2ToUtf16N();
  ~FromUcs2ToUtf16N();
  virtual UInt16 getUInt16() CCC_RAISES(IOException);
  static IFilter* createIFilter();
};

class FromUtf16BeToUtf16BeBom
  : public UInt16PushbackIFilter
{
 public:
  FromUtf16BeToUtf16BeBom();
  ~FromUtf16BeToUtf16BeBom();
  virtual UInt16 getUInt16() CCC_RAISES(IOException);
  static IFilter* createIFilter();
};

class FromUtf16LeToUtf16LeBom
  : public UInt16PushbackIFilter
{
 public:
  FromUtf16LeToUtf16LeBom();
  ~FromUtf16LeToUtf16LeBom();
  virtual UInt16 getUInt16() CCC_RAISES(IOException);
  static IFilter* createIFilter();
};

class FromUtf16BeBomToUtf16Be
  : public UInt16PushbackIFilter
{
 public:
  FromUtf16BeBomToUtf16Be();
  ~FromUtf16BeBomToUtf16Be();
  virtual UInt16 getUInt16() CCC_RAISES(IOException);
  static IFilter* createIFilter();
};

class FromUtf16LeBomToUtf16Le
  : public UInt16PushbackIFilter
{
 public:
  FromUtf16LeBomToUtf16Le();
  ~FromUtf16LeBomToUtf16Le();
  virtual UInt16 getUInt16() CCC_RAISES(IOException);
  static IFilter* createIFilter();
};

class FromUtf32BeToUtf32BeBom
  : public UInt32PushbackIFilter
{
 public:
  FromUtf32BeToUtf32BeBom();
  ~FromUtf32BeToUtf32BeBom();
  virtual UInt32 getUInt32() CCC_RAISES(IOException);
  static IFilter* createIFilter();
};

class FromUtf32LeToUtf32LeBom
  : public UInt32PushbackIFilter
{
 public:
  FromUtf32LeToUtf32LeBom();
  ~FromUtf32LeToUtf32LeBom();
  virtual UInt32 getUInt32() CCC_RAISES(IOException);
  static IFilter* createIFilter();
};

class FromUtf32BeBomToUtf32Be
  : public UInt32PushbackIFilter
{
 public:
  FromUtf32BeBomToUtf32Be();
  ~FromUtf32BeBomToUtf32Be();
  virtual UInt32 getUInt32() CCC_RAISES(IOException);
  static IFilter* createIFilter();
};

class FromUtf32LeBomToUtf32Le
  : public UInt32PushbackIFilter
{
 public:
  FromUtf32LeBomToUtf32Le();
  ~FromUtf32LeBomToUtf32Le();
  virtual UInt32 getUInt32() CCC_RAISES(IOException);
  static IFilter* createIFilter();
};

CCC_NAMESPACE_END(CCC);

#endif /* INCLUDE_ccc_iceman_unicodeconv_h */
