﻿// @@DISTHDR@@
// $Id$

#include <ccc/iceman/Iceman.h>
#include <ccc/iceman/CenDictionary.h>
#include <ccc/iceman/unitfilter.h>
#include <ccc/iceman/unicodeconv.h>
#include <ccc/iceman/jpcodeconv.h>
#include <ccc/iceman/iso8859conv.h>
#include <ccc/iceman/eucodeconv.h>

#ifdef COMPILE_FILTERPATH
#define ICEMAN_UNIT_FILTER(from, to, lost, func) { from, to, lost }
#else /* COMPILE_FILTERPATH */
#define ICEMAN_UNIT_FILTER(from, to, lost, func) { from, to, lost, func }
#endif /* COMPILE_FILTERPATH */

CCC_NAMESPACE_START(CCC);

UnitIFilterEntry unit_filters[] =
{
  ICEMAN_UNIT_FILTER(CEID_USASCII, CEID_UCS2, 0, &FromUsAsciiToUcs2::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_USASCII, CEID_UCS4, 0, &FromUsAsciiToUcs4::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UCS4, CEID_USASCII, -1, &FromUcs4ToUsAscii::createIFilter),
  // UCS2, UCS4
  ICEMAN_UNIT_FILTER(CEID_UCS2, CEID_UCS4, 0, &FromUcs2ToUcs4::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UCS4, CEID_UCS2, -1, &FromUcs4ToUcs2::createIFilter),
#if CCC_ENDIAN == CCC_LITTLE_ENDIAN
  ICEMAN_UNIT_FILTER(CEID_UCS2, CEID_UCS2_BE, 0, &FromUcs2ToUcs2Be::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UCS4, CEID_UCS4_BE, 0, &FromUcs4ToUcs4Be::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UCS2_BE, CEID_UCS2, 0, &FromUcs2BeToUcs2::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UCS4_BE, CEID_UCS4, 0, &FromUcs4BeToUcs4::createIFilter),
#elif CCC_ENDIAN == CCC_BIG_ENDIAN
  ICEMAN_UNIT_FILTER(CEID_UCS2, CEID_UCS2_LE, 0, &FromUcs2ToUcs2Le::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UCS4, CEID_UCS4_LE, 0, &FromUcs4ToUcs4Le::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UCS2_LE, CEID_UCS2, 0, &FromUcs2LeToUcs2::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UCS4_LE, CEID_UCS4, 0, &FromUcs4LeToUcs4::createIFilter),
#else
#  error "CCC_ENDIAN should be CCC_LITTLE_ENDIAN or CCC_BIG_ENDIAN"
#endif /* CCC_ENDIAN */
  // UTF7
  ICEMAN_UNIT_FILTER(CEID_UCS2, CEID_UTF7, 0, &FromUcs2ToUtf7::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UTF7, CEID_UCS2, 0, &FromUtf7ToUcs2::createIFilter),

  // UTF8N
  ICEMAN_UNIT_FILTER(CEID_UTF8N, CEID_UCS2, -1, &FromUtf8NToUcs2::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UCS2, CEID_UTF8N, 0, &FromUcs2ToUtf8N::createIFilter),

  // UTF8
  ICEMAN_UNIT_FILTER(CEID_UTF8, CEID_UTF8N, 0, &FromUtf8ToUtf8N::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UTF8N, CEID_UTF8, 0, &FromUtf8NToUtf8::createIFilter),

  // UTF16N
  ICEMAN_UNIT_FILTER(CEID_UTF16N, CEID_UCS4, 0, &FromUtf16NToUcs4::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UCS4, CEID_UTF16N, -1, &FromUcs4ToUtf16N::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UTF16N, CEID_UTF16_BE, 0, &FromUtf16NToUtf16Be::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UTF16N, CEID_UTF16_LE, 0, &FromUtf16NToUtf16Le::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UTF16_BE, CEID_UTF16N, 0, &FromUtf16BeToUtf16N::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UTF16_LE, CEID_UTF16N, 0, &FromUtf16LeToUtf16N::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UTF16N, CEID_UTF8, 0, &FromUtf16NToUtf8::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UTF16N, CEID_UTF8N, 0, &FromUtf16NToUtf8N::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UTF8, CEID_UTF16N, 0, &FromUtf8ToUtf16N::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UCS2, CEID_UTF16N, 0, &FromUcs2ToUtf16N::createIFilter),

  // UTF16
  ICEMAN_UNIT_FILTER(CEID_UTF16N, CEID_UTF16, 0, &FromUtf16NToUtf16::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UTF16, CEID_UTF16N, 0, &FromUtf16ToUtf16N::createIFilter),

  // UTF16X+BOM
  ICEMAN_UNIT_FILTER(CEID_UTF16_BE, CEID_UTF16_BE_BOM, 0, &FromUtf16BeToUtf16BeBom::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UTF16_LE, CEID_UTF16_LE_BOM, 0, &FromUtf16LeToUtf16LeBom::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UTF16_BE_BOM, CEID_UTF16_BE, 0, &FromUtf16BeBomToUtf16Be::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UTF16_LE_BOM, CEID_UTF16_LE, 0, &FromUtf16LeBomToUtf16Le::createIFilter),

  // UTF32N
  ICEMAN_UNIT_FILTER(CEID_UTF32N, CEID_UCS4, 0, &FromUtf32NToUcs4::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UTF32N, CEID_UTF16N, 0, &FromUtf32NToUtf16N::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UTF16N, CEID_UTF32N, 0, &FromUtf16NToUtf32N::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UCS4, CEID_UTF32N, -1, &FromUcs4ToUtf32N::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UTF32N, CEID_UTF32_BE, 0, &FromUtf32NToUtf32Be::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UTF32N, CEID_UTF32_LE, 0, &FromUtf32NToUtf32Le::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UTF32_BE, CEID_UTF32N, 0, &FromUtf32BeToUtf32N::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UTF32_LE, CEID_UTF32N, 0, &FromUtf32LeToUtf32N::createIFilter),

  // UTF32
  ICEMAN_UNIT_FILTER(CEID_UTF32N, CEID_UTF32, 0, &FromUtf32NToUtf32::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UTF32, CEID_UTF32N, 0, &FromUtf32ToUtf32N::createIFilter),

  // UTF32X+BOM
  ICEMAN_UNIT_FILTER(CEID_UTF32_BE, CEID_UTF32_BE_BOM, 0, &FromUtf32BeToUtf32BeBom::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UTF32_LE, CEID_UTF32_LE_BOM, 0, &FromUtf32LeToUtf32LeBom::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UTF32_BE_BOM, CEID_UTF32_BE, 0, &FromUtf32BeBomToUtf32Be::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UTF32_LE_BOM, CEID_UTF32_LE, 0, &FromUtf32LeBomToUtf32Le::createIFilter),

  // Japanese charset encodings
  ICEMAN_UNIT_FILTER(CEID_EUCJP, CEID_SJIS, -1, &FromEucJpToSjis::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_SJIS, CEID_EUCJP, 0, &FromSjisToEucJp::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_ISO2022JP, CEID_SJIS, 0, &FromIso2022JpToSjis::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_EUCJP, CEID_ISO2022JP, -1, &FromEucJpToIso2022Jp::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_SJIS, CEID_ISO2022JP, -1, &FromSjisToIso2022Jp::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_ISO2022JP, CEID_EUCJP, 0, &FromIso2022JpToEucJp::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UCS2, CEID_SJIS, -1, &FromUcs2ToSjis::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UCS2, CEID_EUCJP, -1, &FromUcs2ToEucJp::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UCS2, CEID_ISO2022JP, -1, &FromUcs2ToIso2022Jp::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_SJIS, CEID_UCS2, 0, &FromSjisToUcs2::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_CP932, CEID_UCS2, 0, &FromCp932ToUcs2::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UCS2, CEID_CP932, -1, &FromUcs2ToCp932::createIFilter),

  // ISO8859-x
  ICEMAN_UNIT_FILTER(CEID_ISO8859_1, CEID_UCS2, 0, &From8859_1ToUcs2::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_ISO8859_2, CEID_UCS2, 0, &From8859_2ToUcs2::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_ISO8859_3, CEID_UCS2, 0, &From8859_3ToUcs2::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_ISO8859_4, CEID_UCS2, 0, &From8859_4ToUcs2::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_ISO8859_5, CEID_UCS2, 0, &From8859_5ToUcs2::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_ISO8859_6, CEID_UCS2, 0, &From8859_6ToUcs2::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_ISO8859_7, CEID_UCS2, 0, &From8859_7ToUcs2::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_ISO8859_8, CEID_UCS2, 0, &From8859_8ToUcs2::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_ISO8859_9, CEID_UCS2, 0, &From8859_9ToUcs2::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_ISO8859_10, CEID_UCS2, 0, &From8859_10ToUcs2::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_ISO8859_13, CEID_UCS2, 0, &From8859_13ToUcs2::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_ISO8859_14, CEID_UCS2, 0, &From8859_14ToUcs2::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_ISO8859_15, CEID_UCS2, 0, &From8859_15ToUcs2::createIFilter),

  ICEMAN_UNIT_FILTER(CEID_ISO8859_1, CEID_USASCII, -1, &From8859_xToUsAscii::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_ISO8859_2, CEID_USASCII, -1, &From8859_xToUsAscii::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_ISO8859_3, CEID_USASCII, -1, &From8859_xToUsAscii::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_ISO8859_4, CEID_USASCII, -1, &From8859_xToUsAscii::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_ISO8859_5, CEID_USASCII, -1, &From8859_xToUsAscii::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_ISO8859_6, CEID_USASCII, -1, &From8859_xToUsAscii::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_ISO8859_7, CEID_USASCII, -1, &From8859_xToUsAscii::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_ISO8859_8, CEID_USASCII, -1, &From8859_xToUsAscii::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_ISO8859_9, CEID_USASCII, -1, &From8859_xToUsAscii::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_ISO8859_10, CEID_USASCII, -1, &From8859_xToUsAscii::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_ISO8859_13, CEID_USASCII, -1, &From8859_xToUsAscii::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_ISO8859_14, CEID_USASCII, -1, &From8859_xToUsAscii::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_ISO8859_15, CEID_USASCII, -1, &From8859_xToUsAscii::createIFilter),

  ICEMAN_UNIT_FILTER(CEID_USASCII, CEID_ISO8859_1, 0, &FromUsAsciiTo8859_x::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_USASCII, CEID_ISO8859_2, 0, &FromUsAsciiTo8859_x::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_USASCII, CEID_ISO8859_3, 0, &FromUsAsciiTo8859_x::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_USASCII, CEID_ISO8859_4, 0, &FromUsAsciiTo8859_x::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_USASCII, CEID_ISO8859_5, 0, &FromUsAsciiTo8859_x::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_USASCII, CEID_ISO8859_6, 0, &FromUsAsciiTo8859_x::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_USASCII, CEID_ISO8859_7, 0, &FromUsAsciiTo8859_x::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_USASCII, CEID_ISO8859_8, 0, &FromUsAsciiTo8859_x::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_USASCII, CEID_ISO8859_9, 0, &FromUsAsciiTo8859_x::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_USASCII, CEID_ISO8859_10, 0, &FromUsAsciiTo8859_x::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_USASCII, CEID_ISO8859_13, 0, &FromUsAsciiTo8859_x::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_USASCII, CEID_ISO8859_14, 0, &FromUsAsciiTo8859_x::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_USASCII, CEID_ISO8859_15, 0, &FromUsAsciiTo8859_x::createIFilter),

  ICEMAN_UNIT_FILTER(CEID_UCS2, CEID_ISO8859_1, -1, &FromUcs2To8859_1::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UCS2, CEID_ISO8859_2, -1, &FromUcs2To8859_2::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UCS2, CEID_ISO8859_3, -1, &FromUcs2To8859_3::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UCS2, CEID_ISO8859_4, -1, &FromUcs2To8859_4::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UCS2, CEID_ISO8859_5, -1, &FromUcs2To8859_5::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UCS2, CEID_ISO8859_6, -1, &FromUcs2To8859_6::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UCS2, CEID_ISO8859_7, -1, &FromUcs2To8859_7::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UCS2, CEID_ISO8859_8, -1, &FromUcs2To8859_8::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UCS2, CEID_ISO8859_9, -1, &FromUcs2To8859_9::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UCS2, CEID_ISO8859_10, -1, &FromUcs2To8859_10::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UCS2, CEID_ISO8859_13, -1, &FromUcs2To8859_13::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UCS2, CEID_ISO8859_14, -1, &FromUcs2To8859_14::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UCS2, CEID_ISO8859_15, -1, &FromUcs2To8859_15::createIFilter),

  // for EUC-JP-MS
  ICEMAN_UNIT_FILTER(CEID_EUCJPMS, CEID_CP932, -1, &FromEucJpMsToCp932::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_CP932, CEID_EUCJPMS, -1, &FromCp932ToEucJpMs::createIFilter),

  // for windows-1252
  ICEMAN_UNIT_FILTER(CEID_CP1252, CEID_UCS2, 0, &FromCp1252ToUcs2::createIFilter),
  ICEMAN_UNIT_FILTER(CEID_UCS2, CEID_CP1252, -1, &FromUcs2ToCp1252::createIFilter),

#if 0
  // TODO:
  ICEMAN_UNIT_FILTER(CEID_EUCJP, CEID_UCS2, 0, 0),
  ICEMAN_UNIT_FILTER(CEID_ISO2022JP, CEID_UCS2, 0, 0),
#endif

  ICEMAN_UNIT_FILTER(CEID_NULL, CEID_NULL, 0, 0),	// end of table
};

CCC_NAMESPACE_END(CCC);
