﻿// @@DISTHDR@@
// $Id$

#include <assert.h>
#include <ccc/iceman/utility.h>
#include <ccc/iceman/Unicode.h>
#include <ccc/iceman/i18ncode.h>

CCC_NAMESPACE_START(CCC);

// ------------------------------------------------------------------------
// class Utility

Utility::Utility()
  : IFilter(IOTYPE_ANY, IOTYPE_ANY)
{
}

Utility::~Utility()
{
}

// ------------------------------------------------------------------------
// class GroupUtility

GroupUtility::GroupUtility()
  : IFilter(IOTYPE_ANY, IOTYPE_ANY)
{
}

GroupUtility::~GroupUtility()
{
}

// ------------------------------------------------------------------------
// class CompositUtility

CompositUtility::CompositUtility()
  : CompositIFilter(IOTYPE_ANY, IOTYPE_ANY)
{
}

CompositUtility::~CompositUtility()
{
}

CeId
CompositUtility::getFromCeId()
{
  assert(list.tail());
  Utility* util = (Utility*)list.tail();
  if (!util)
  {
    return CEID_NULL;
  }
  return util->getFromCeId();
}

CeId
CompositUtility::getToCeId()
{
  assert(list.head());
  Utility* util = (Utility*)list.head();
  if (!util)
  {
    return CEID_NULL;
  }
  return util->getToCeId();
}

void
CompositUtility::setSrc(IFlow* src)
{
  CompositIFilter::setSrc(src);
}

void
CompositUtility::add(IFilter* filter)
{
  assert(false);
}

bool
CompositUtility::add(Utility* filter)
{
  Utility* last = (Utility*)list.head();
  if (last)
  {
    if (last->getToCeId() != filter->getFromCeId())
    {
      return false;
    }
  }
  CompositIFilter::add(filter);
  return true;
}

Int8
CompositUtility::getInt8() CCC_RAISES(IOException)
{
  return CompositIFilter::getInt8();
}

UInt16
CompositUtility::getUInt16() CCC_RAISES(IOException)
{
  return CompositIFilter::getUInt16();
}

UInt32
CompositUtility::getUInt32() CCC_RAISES(IOException)
{
  return CompositIFilter::getUInt32();
}

IOType
CompositUtility::getIOType()
{
  return CompositIFilter::getIOType();
}

bool
CompositUtility::rewind()
{
  return CompositIFilter::rewind();
}

// ------------------------------------------------------------------------
// class CompositGroupUtility

CompositGroupUtility::CompositGroupUtility()
  : CompositIFilter(IOTYPE_ANY, IOTYPE_ANY)
{
}

CompositGroupUtility::~CompositGroupUtility()
{
}

CeGId
CompositGroupUtility::getFromToCeGId()
{
  assert(list.head());
  GroupUtility* gutil = (GroupUtility*)list.head();
  if (!gutil)
  {
    return CEGID_NOGROUP;
  }
  return gutil->getFromToCeGId();
}

void
CompositGroupUtility::setSrc(IFlow* src)
{
  CompositIFilter::setSrc(src);
}

void
CompositGroupUtility::add(IFilter* filter)
{
  assert(false);
}

bool
CompositGroupUtility::add(GroupUtility* filter)
{
  GroupUtility* gutil = (GroupUtility*)list.head();
  if (gutil)
  {
    if (gutil->getFromToCeGId() != filter->getFromToCeGId())
    {
      return false;
    }
  }
  CompositIFilter::add(filter);
  return true;
}

Int8
CompositGroupUtility::getInt8() CCC_RAISES(IOException)
{
  return CompositIFilter::getInt8();
}

UInt16
CompositGroupUtility::getUInt16() CCC_RAISES(IOException)
{
  return CompositIFilter::getUInt16();
}

UInt32
CompositGroupUtility::getUInt32() CCC_RAISES(IOException)
{
  return CompositIFilter::getUInt32();
}

IOType
CompositGroupUtility::getIOType()
{
  return CompositIFilter::getIOType();
}

bool
CompositGroupUtility::rewind()
{
  return CompositIFilter::rewind();
}

// ------------------------------------------------------------------------
// class U16Bom

U16Bom::U16Bom()
{
  clear();
}

U16Bom::~U16Bom()
{
}

void
U16Bom::clear()
{
  top_p = true;
}

bool
U16Bom::rewind()
{
  clear();
  return GroupUtility::rewind();
}

UInt16
U16Bom::getUInt16() CCC_RAISES(IOException)
{
  if (top_p)
  {
    top_p = false;
    return ICEMAN_UNICODE_ZWNBSP;
  }
  for (;;)
  {
    UInt16 c = src->getUInt16();
    if (c != ICEMAN_UNICODE_ZWNBSP)
    {
      return c;
    }
  }
}

CeGId
U16Bom::getFromToCeGId()
{
  return CEGID_16BIT_NE;
}

IOType
U16Bom::getIOType()
{
  return IOTYPE_UINT16;
}

// ------------------------------------------------------------------------
// class U32Bom

U32Bom::U32Bom()
{
  clear();
}

U32Bom::~U32Bom()
{
}

void
U32Bom::clear()
{
  top_p = true;
}

bool
U32Bom::rewind()
{
  clear();
  return GroupUtility::rewind();
}

UInt32
U32Bom::getUInt32() CCC_RAISES(IOException)
{
  if (top_p)
  {
    top_p = false;
    return ICEMAN_UNICODE_ZWNBSP;
  }
  for (;;)
  {
    UInt32 c = src->getUInt32();
    if (c != ICEMAN_UNICODE_ZWNBSP)
    {
      return c;
    }
  }
}

CeGId
U32Bom::getFromToCeGId()
{
  return CEGID_32BIT_NE;
}

IOType
U32Bom::getIOType()
{
  return IOTYPE_UINT32;
}

// ------------------------------------------------------------------------
// class Cr2Lf

Int8
Cr2Lf::getInt8() CCC_RAISES(IOException)
{
  Int8 c = src->getInt8();
  if (c == ASCII_CR)
  {
    c = ASCII_LF;
  }
  return c;
}

UInt16
Cr2Lf::getUInt16() CCC_RAISES(IOException)
{
  UInt16 c = src->getUInt16();
  if (c == ASCII_CR)
  {
    c = ASCII_LF;
  }
  return c;
}

UInt32
Cr2Lf::getUInt32() CCC_RAISES(IOException)
{
  UInt32 c = src->getUInt32();
  if (c == ASCII_CR)
  {
    c = ASCII_LF;
  }
  return c;
}

// ------------------------------------------------------------------------
// class Lf2Cr

Int8
Lf2Cr::getInt8() CCC_RAISES(IOException)
{
  Int8 c = src->getInt8();
  if (c == ASCII_CR)
  {
    c = ASCII_LF;
  }
  return c;
}

UInt16
Lf2Cr::getUInt16() CCC_RAISES(IOException)
{
  UInt16 c = src->getUInt16();
  if (c == ASCII_CR)
  {
    c = ASCII_LF;
  }
  return c;
}

UInt32
Lf2Cr::getUInt32() CCC_RAISES(IOException)
{
  UInt32 c = src->getUInt32();
  if (c == ASCII_CR)
  {
    c = ASCII_LF;
  }
  return c;
}

// ------------------------------------------------------------------------
// class CrLf2Lf

void
CrLf2Lf::clear()
{
  spool_p = false;
}

CrLf2Lf::CrLf2Lf()
{
  clear();
}

bool
CrLf2Lf::rewind()
{
  clear();
  return GroupUtility::rewind();
}

Int8
CrLf2Lf::getInt8() CCC_RAISES(IOException)
{
  if (spool_p)
  {
    spool_p = false;
    return c8;
  }
  
  Int8 c = src->getInt8();
  if (c == ASCII_CR)
  {
    c8 = src->getInt8();
    if (c8 == ASCII_LF)
    {
      return ASCII_LF;
    }
    else
    {
      spool_p = true;
    }
  }
  return c;
}

UInt16
CrLf2Lf::getUInt16() CCC_RAISES(IOException)
{
  if (spool_p)
  {
    spool_p = false;
    return c16;
  }
  
  UInt16 c = src->getUInt16();
  if (c == ASCII_CR)
  {
    c16 = src->getUInt16();
    if (c16 == ASCII_LF)
    {
      return ASCII_LF;
    }
    else
    {
      spool_p = true;
    }
  }
  return c;
}

UInt32
CrLf2Lf::getUInt32() CCC_RAISES(IOException)
{
  if (spool_p)
  {
    spool_p = false;
    return c32;
  }
  
  UInt32 c = src->getUInt32();
  if (c == ASCII_CR)
  {
    c32 = src->getUInt32();
    if (c32 == ASCII_LF)
    {
      return ASCII_LF;
    }
    else
    {
      spool_p = true;
    }
  }
  return c;
}

// ------------------------------------------------------------------------
// class CrLf2Cr

void
CrLf2Cr::clear()
{
  spool_p = false;
}

CrLf2Cr::CrLf2Cr()
{
  clear();
}

bool
CrLf2Cr::rewind()
{
  clear();
  return GroupUtility::rewind();
}

Int8
CrLf2Cr::getInt8() CCC_RAISES(IOException)
{
  if (spool_p)
  {
    spool_p = false;
    return c8;
  }
  
  Int8 c = src->getInt8();
  if (c == ASCII_CR)
  {
    c8 = src->getInt8();
    if (c8 == ASCII_LF)
    {
      return ASCII_CR;
    }
    else
    {
      spool_p = true;
    }
  }
  return c;
}

UInt16
CrLf2Cr::getUInt16() CCC_RAISES(IOException)
{
  if (spool_p)
  {
    spool_p = false;
    return c16;
  }
  
  UInt16 c = src->getUInt16();
  if (c == ASCII_CR)
  {
    c16 = src->getUInt16();
    if (c16 == ASCII_LF)
    {
      return ASCII_CR;
    }
    else
    {
      spool_p = true;
    }
  }
  return c;
}

UInt32
CrLf2Cr::getUInt32() CCC_RAISES(IOException)
{
  if (spool_p)
  {
    spool_p = false;
    return c32;
  }
  
  UInt32 c = src->getUInt32();
  if (c == ASCII_CR)
  {
    c32 = src->getUInt32();
    if (c32 == ASCII_LF)
    {
      return ASCII_CR;
    }
    else
    {
      spool_p = true;
    }
  }
  return c;
}

// ------------------------------------------------------------------------
// class Lf2CrLf 

void
Lf2CrLf::clear()
{
  spool_p = false;
}

Lf2CrLf::Lf2CrLf()
{
  clear();
}

bool
Lf2CrLf::rewind()
{
  clear();
  return GroupUtility::rewind();
}

Int8
Lf2CrLf::getInt8() CCC_RAISES(IOException)
{
  if (spool_p)
  {
    spool_p = false;
    return ASCII_LF;
  }
  Int8 c = src->getInt8();
  if (c == ASCII_LF)
  {
    spool_p = true;
    return ASCII_CR;
  }
  return c;
}

UInt16
Lf2CrLf::getUInt16() CCC_RAISES(IOException)
{
  if (spool_p)
  {
    spool_p = false;
    return ASCII_LF;
  }
  UInt16 c = src->getUInt16();
  if (c == ASCII_LF)
  {
    spool_p = true;
    return ASCII_CR;
  }
  return c;
}

UInt32
Lf2CrLf::getUInt32() CCC_RAISES(IOException)
{
  if (spool_p)
  {
    spool_p = false;
    return ASCII_LF;
  }
  UInt32 c = src->getUInt32();
  if (c == ASCII_LF)
  {
    spool_p = true;
    return ASCII_CR;
  }
  return c;
}

// ------------------------------------------------------------------------
// class Cr2CrLf

void
Cr2CrLf::clear()
{
  spool_p = false;
}

Cr2CrLf::Cr2CrLf()
{
  clear();
}

bool
Cr2CrLf::rewind()
{
  clear();
  return GroupUtility::rewind();
}

Int8
Cr2CrLf::getInt8() CCC_RAISES(IOException)
{
  if (spool_p)
  {
    spool_p = false;
    return ASCII_LF;
  }
  Int8 c = src->getInt8();
  if (c == ASCII_CR)
  {
    spool_p = true;
    return ASCII_CR;
  }
  return c;
}

UInt16
Cr2CrLf::getUInt16() CCC_RAISES(IOException)
{
  if (spool_p)
  {
    spool_p = false;
    return ASCII_LF;
  }
  UInt16 c = src->getUInt16();
  if (c == ASCII_CR)
  {
    spool_p = true;
    return ASCII_CR;
  }
  return c;
}

UInt32
Cr2CrLf::getUInt32() CCC_RAISES(IOException)
{
  if (spool_p)
  {
    spool_p = false;
    return ASCII_LF;
  }
  UInt32 c = src->getUInt32();
  if (c == ASCII_CR)
  {
    spool_p = true;
    return ASCII_CR;
  }
  return c;
}

// ------------------------------------------------------------------------
// class Auto2NewLine

Auto2NewLine::Auto2NewLine(NLConv nlc)
{
  Auto2NewLine::nlc = nlc;
  clear();
}

Auto2NewLine::~Auto2NewLine()
{
}

void
Auto2NewLine::clear()
{
  Auto2NewLine::nlc = nlc;
  spooled_size = 0;
  unget_p = false;
}

bool
Auto2NewLine::rewind()
{
  clear();
  return GroupUtility::rewind();
}

UInt32
Auto2NewLine::nlOut()
{
  UInt32 ret;
  switch (nlc)
  {
   case NLCONV_AUTO2CR:
    ret = ASCII_CR;
    break;
   case NLCONV_AUTO2LF:
    ret = ASCII_LF;
    break;
   case NLCONV_AUTO2CRLF:
    spool[spooled_size++] = ASCII_LF;
    ret = ASCII_CR;
    break;
   default:
    assert(false);
    break;
  }
  return ret;
}

void
Auto2NewLine::unget(UInt32 c)
{
  unget_data = c;
  unget_p = true;
}

Int8
Auto2NewLine::getInt8() CCC_RAISES(IOException)
{
  if (spooled_size)
  {
    return (Int8)spool[--spooled_size];
  }
  Int8 c;
  if (unget_p)
  {
    c = (Int8)unget_data;
    unget_p = false;
  }
  else
  {
    c = src->getInt8();
  }
  switch (c)
  {
   case ASCII_CR:
    {
      try
      {
	Int8 c2 = src->getInt8();
	switch (c2)
	{
	 case ASCII_LF:
	  // CR + LF -> NL
	  c = (Int8)nlOut();
	  break;

	 case ASCII_CR:
	 default:
	  // CR, ? -> NL
	  unget((UInt32)((UInt8)c2));
	  c = (Int8)nlOut();
	  break;
	}
      }
      catch (IOException& ioe)
      {
	if (ioe.errorNum() == IOException::READ_BEYOND_THE_EOF)
	{
	  return (Int8)nlOut();
	}
	throw ioe;
      }
    }
    break;
    
   case ASCII_LF:
    // LF -> NL
    c = (Int8)nlOut();
    break;
    
   default:
    break;
  }
  return c;
}

UInt16
Auto2NewLine::getUInt16() CCC_RAISES(IOException)
{
  if (spooled_size)
  {
    return (UInt16)spool[--spooled_size];
  }
  UInt16 c;
  if (unget_p)
  {
    c = (UInt16)unget_data;
    unget_p = false;
  }
  else
  {
    c = src->getUInt16();
  }
  switch (c)
  {
   case ASCII_CR:
    {
      UInt16 c2 = src->getUInt16();
      switch (c2)
      {
       case ASCII_LF:
	// CR + LF -> NL
	c = (UInt16)nlOut();

       case ASCII_CR:
       default:
	// CR, ? -> NL
	unget((UInt32)c2);
	c = (UInt16)nlOut();
      }
    }
    break;
    
   case ASCII_LF:
    // LF -> NL
    c = (UInt16)nlOut();
    break;
    
   default:
    break;
  }
  return c;
}

UInt32
Auto2NewLine::getUInt32() CCC_RAISES(IOException)
{
  if (spooled_size)
  {
    return spool[--spooled_size];
  }
  UInt32 c;
  if (unget_p)
  {
    c = unget_data;
    unget_p = false;
  }
  else
  {
    c = src->getUInt32();
  }
  switch (c)
  {
   case ASCII_CR:
    {
      UInt32 c2 = src->getUInt32();
      switch (c2)
      {
       case ASCII_LF:
	// CR + LF -> NL
	c = nlOut();

       case ASCII_CR:
       default:
	// CR, ? -> NL
	unget(c2);
	c = nlOut();
      }
    }
    break;
    
   case ASCII_LF:
    // LF -> NL
    c = nlOut();
    break;
    
   default:
    break;
  }
  return c;
}

// ------------------------------------------------------------------------
// class Auto2NewLine8

Auto2NewLine8::Auto2NewLine8(NLConv nlc)
  : Auto2NewLine(nlc)
{
}

Auto2NewLine8::~Auto2NewLine8()
{
}

CeGId
Auto2NewLine8::getFromToCeGId()
{
  return CEGID_8BIT;
}

IOType
Auto2NewLine8::getIOType()
{
  return IOTYPE_INT8;
}

// ------------------------------------------------------------------------
// class Auto2NewLine16

Auto2NewLine16::Auto2NewLine16(NLConv nlc)
  : Auto2NewLine(nlc)
{
}

Auto2NewLine16::~Auto2NewLine16()
{
}

CeGId
Auto2NewLine16::getFromToCeGId()
{
  return CEGID_16BIT_NE;
}

IOType
Auto2NewLine16::getIOType()
{
  return IOTYPE_UINT16;
}

// ------------------------------------------------------------------------
// class Auto2NewLine32

Auto2NewLine32::Auto2NewLine32(NLConv nlc)
  : Auto2NewLine(nlc)
{
}

Auto2NewLine32::~Auto2NewLine32()
{
}

CeGId
Auto2NewLine32::getFromToCeGId()
{
  return CEGID_32BIT_NE;
}

IOType
Auto2NewLine32::getIOType()
{
  return IOTYPE_UINT32;
}

// ------------------------------------------------------------------------

GroupUtility*
createNLConvGroupUtility(NLConv nlc, CeGId gid)
{
  GroupUtility* gu = 0;
  switch (nlc)
  {
   case NLCONV_NONE:
    break;
    
   case NLCONV_LF2CR:
    switch (gid)
    {
     case CEGID_8BIT:
      gu = new Lf2Cr8();
      break;
     case CEGID_16BIT_NE:
      gu = new Lf2Cr16();
      break;
     case CEGID_32BIT_NE:
      gu = new Lf2Cr32();
      break;
     default:
      assert(false);
      break;
    }
    break;

   case NLCONV_CR2LF:
    switch (gid)
    {
     case CEGID_8BIT:
      gu = new Cr2Lf8();
      break;
     case CEGID_16BIT_NE:
      gu = new Cr2Lf16();
      break;
     case CEGID_32BIT_NE:
      gu = new Cr2Lf32();
      break;
     default:
      assert(false);
      break;
    }
    break;

   case NLCONV_CRLF2LF:
    switch (gid)
    {
     case CEGID_8BIT:
      gu = new CrLf2Lf8();
      break;
     case CEGID_16BIT_NE:
      gu = new CrLf2Lf16();
      break;
     case CEGID_32BIT_NE:
      gu = new CrLf2Lf32();
      break;
     default:
      assert(false);
      break;
    }
    break;

   case NLCONV_CRLF2CR:
    switch (gid)
    {
     case CEGID_8BIT:
      gu = new CrLf2Cr8();
      break;
     case CEGID_16BIT_NE:
      gu = new CrLf2Cr16();
      break;
     case CEGID_32BIT_NE:
      gu = new CrLf2Cr32();
      break;
     default:
      assert(false);
      break;
    }
    break;

   case NLCONV_LF2CRLF:
    switch (gid)
    {
     case CEGID_8BIT:
      gu = new Lf2CrLf8();
      break;
     case CEGID_16BIT_NE:
      gu = new Lf2CrLf16();
      break;
     case CEGID_32BIT_NE:
      gu = new Lf2CrLf32();
      break;
     default:
      assert(false);
      break;
    }
    break;

   case NLCONV_CR2CRLF:
    switch (gid)
    {
     case CEGID_8BIT:
      gu = new Cr2CrLf8();
      break;
     case CEGID_16BIT_NE:
      gu = new Cr2CrLf16();
      break;
     case CEGID_32BIT_NE:
      gu = new Cr2CrLf32();
      break;
     default:
      assert(false);
      break;
    }
    break;

   case NLCONV_AUTO2CR:
   case NLCONV_AUTO2LF:
   case NLCONV_AUTO2CRLF:
    switch (gid)
    {
     case CEGID_8BIT:
      gu = new Auto2NewLine8(nlc);
      break;
     case CEGID_16BIT_NE:
      gu = new Auto2NewLine16(nlc);
      break;
     case CEGID_32BIT_NE:
      gu = new Auto2NewLine32(nlc);
      break;
     default:
      assert(false);
      break;
    }
    break;
  }
  return gu;
}

CCC_NAMESPACE_END(CCC);

