﻿// @@DISTHDR@@
// $Id$

#ifndef INCLUDE_ccc_iceman_utility_h
#define INCLUDE_ccc_iceman_utility_h

#include <ccc/base/IFilter.h>
#include <ccc/base/CompositIFilter.h>
#include <ccc/iceman/Iceman.h>

CCC_NAMESPACE_START(CCC);

class Utility
  : public IFilter
{
 public:
  Utility();
  ~Utility();
  virtual CeId getFromCeId() = 0;
  virtual CeId getToCeId() = 0;
};

class CompositUtility
  : public CompositIFilter, public Utility
{
 public:
  CompositUtility();
  ~CompositUtility();
  virtual CeId getFromCeId();
  virtual CeId getToCeId();
  virtual void setSrc(IFlow* src);
  virtual void add(IFilter* filter);	// This method always returns false.
  virtual bool add(Utility* filter);
  virtual Int8 getInt8() CCC_RAISES(IOException);
  virtual UInt16 getUInt16() CCC_RAISES(IOException);
  virtual UInt32 getUInt32() CCC_RAISES(IOException);
  virtual IOType getIOType();
  virtual bool rewind();
};

class GroupUtility
  : public IFilter
{
 public:
  GroupUtility();
  ~GroupUtility();
  virtual CeGId getFromToCeGId() = 0;
};

class CompositGroupUtility
  : public CompositIFilter, public GroupUtility
{
 public:
  CompositGroupUtility();
  ~CompositGroupUtility();
  virtual CeGId getFromToCeGId();
  virtual void setSrc(IFlow* src);
  virtual void add(IFilter* filter);	// This method always returns false.
  virtual bool add(GroupUtility* filter);
  virtual Int8 getInt8() CCC_RAISES(IOException);
  virtual UInt16 getUInt16() CCC_RAISES(IOException);
  virtual UInt32 getUInt32() CCC_RAISES(IOException);
  virtual IOType getIOType();
  virtual bool rewind();
};

//! add Unicode BOM (zero width no-break space)
class U16Bom
  : public GroupUtility
{
  bool top_p;
  
 private:
  void clear();

 public:
  U16Bom();
  ~U16Bom();
  virtual bool rewind();
  virtual UInt16 getUInt16() CCC_RAISES(IOException);
  virtual CeGId getFromToCeGId();
  virtual IOType getIOType();
};

//! add Unicode BOM (zero width no-break space)
class U32Bom
  : public GroupUtility
{
  bool top_p;
  
 private:
  void clear();

 public:
  U32Bom();
  ~U32Bom();
  virtual bool rewind();
  virtual UInt32 getUInt32() CCC_RAISES(IOException);
  virtual CeGId getFromToCeGId();
  virtual IOType getIOType();
};

//! CR -> LF
class Cr2Lf
  : public GroupUtility
{
 public:
  virtual Int8 getInt8() CCC_RAISES(IOException);
  virtual UInt16 getUInt16() CCC_RAISES(IOException);
  virtual UInt32 getUInt32() CCC_RAISES(IOException);
};

class Cr2Lf8
  : public Cr2Lf
{
 public:
  virtual CeGId getFromToCeGId() { return CEGID_8BIT; }
  virtual IOType getIOType() { return IOTYPE_INT8; }
};

class Cr2Lf16
  : public Cr2Lf
{
 public:
  virtual CeGId getFromToCeGId() { return CEGID_16BIT_NE; }
  virtual IOType getIOType() { return IOTYPE_UINT16; }
};
  
class Cr2Lf32
  : public Cr2Lf
{
 public:
  virtual CeGId getFromToCeGId() { return CEGID_32BIT_NE; }
  virtual IOType getIOType() { return IOTYPE_UINT32; }
};
  
//! LF -> CR
class Lf2Cr
  : public GroupUtility
{
 public:
  virtual Int8 getInt8() CCC_RAISES(IOException);
  virtual UInt16 getUInt16() CCC_RAISES(IOException);
  virtual UInt32 getUInt32() CCC_RAISES(IOException);
};

class Lf2Cr8
  : public Lf2Cr
{
 public:
  virtual CeGId getFromToCeGId() { return CEGID_8BIT; }
  virtual IOType getIOType() { return IOTYPE_INT8; }
};

class Lf2Cr16
  : public Lf2Cr
{
 public:
  virtual CeGId getFromToCeGId() { return CEGID_16BIT_NE; }
  virtual IOType getIOType() { return IOTYPE_UINT16; }
};
  
class Lf2Cr32
  : public Lf2Cr
{
 public:
  virtual CeGId getFromToCeGId() { return CEGID_32BIT_NE; }
  virtual IOType getIOType() { return IOTYPE_UINT32; }
};

//! CR + LF -> LF
class CrLf2Lf
  : public GroupUtility
{
  bool spool_p;
  Int8 c8;
  UInt16 c16;
  UInt32 c32;
  
  void clear();
 public:
  CrLf2Lf();
  virtual bool rewind();
  virtual Int8 getInt8() CCC_RAISES(IOException);
  virtual UInt16 getUInt16() CCC_RAISES(IOException);
  virtual UInt32 getUInt32() CCC_RAISES(IOException);
};

class CrLf2Lf8
  : public CrLf2Lf
{
 public:
  virtual CeGId getFromToCeGId() { return CEGID_8BIT; }
  virtual IOType getIOType() { return IOTYPE_INT8; }
};

class CrLf2Lf16
  : public CrLf2Lf
{
 public:
  virtual CeGId getFromToCeGId() { return CEGID_16BIT_NE; }
  virtual IOType getIOType() { return IOTYPE_UINT16; }
};
  
class CrLf2Lf32
  : public CrLf2Lf
{
 public:
  virtual CeGId getFromToCeGId() { return CEGID_32BIT_NE; }
  virtual IOType getIOType() { return IOTYPE_UINT32; }
};

//! CR + LF -> CR
class CrLf2Cr
  : public GroupUtility
{
  bool spool_p;
  Int8 c8;
  UInt16 c16;
  UInt32 c32;
  
  void clear();
 public:
  CrLf2Cr();
  virtual bool rewind();
  virtual Int8 getInt8() CCC_RAISES(IOException);
  virtual UInt16 getUInt16() CCC_RAISES(IOException);
  virtual UInt32 getUInt32() CCC_RAISES(IOException);
};

class CrLf2Cr8
  : public CrLf2Cr
{
 public:
  virtual CeGId getFromToCeGId() { return CEGID_8BIT; }
  virtual IOType getIOType() { return IOTYPE_INT8; }
};

class CrLf2Cr16
  : public CrLf2Cr
{
 public:
  virtual CeGId getFromToCeGId() { return CEGID_16BIT_NE; }
  virtual IOType getIOType() { return IOTYPE_UINT16; }
};
  
class CrLf2Cr32
  : public CrLf2Cr
{
 public:
  virtual CeGId getFromToCeGId() { return CEGID_32BIT_NE; }
  virtual IOType getIOType() { return IOTYPE_UINT32; }
};

//! LF -> CR + LF
class Lf2CrLf
  : public GroupUtility
{
  bool spool_p;
  void clear();
 public:
  Lf2CrLf();
  virtual bool rewind();
  virtual Int8 getInt8() CCC_RAISES(IOException);
  virtual UInt16 getUInt16() CCC_RAISES(IOException);
  virtual UInt32 getUInt32() CCC_RAISES(IOException);
};

class Lf2CrLf8
  : public Lf2CrLf
{
 public:
  virtual CeGId getFromToCeGId() { return CEGID_8BIT; }
  virtual IOType getIOType() { return IOTYPE_INT8; }
};

class Lf2CrLf16
  : public Lf2CrLf
{
 public:
  virtual CeGId getFromToCeGId() { return CEGID_16BIT_NE; }
  virtual IOType getIOType() { return IOTYPE_UINT16; }
};
  
class Lf2CrLf32
  : public Lf2CrLf
{
 public:
  virtual CeGId getFromToCeGId() { return CEGID_32BIT_NE; }
  virtual IOType getIOType() { return IOTYPE_UINT32; }
};

//! CR -> CR + LF
class Cr2CrLf
  : public GroupUtility
{
  bool spool_p;
  void clear();
 public:
  Cr2CrLf();
  virtual bool rewind();
  virtual Int8 getInt8() CCC_RAISES(IOException);
  virtual UInt16 getUInt16() CCC_RAISES(IOException);
  virtual UInt32 getUInt32() CCC_RAISES(IOException);
};
  
class Cr2CrLf8
  : public Cr2CrLf
{
 public:
  virtual CeGId getFromToCeGId() { return CEGID_8BIT; }
  virtual IOType getIOType() { return IOTYPE_INT8; }
};

class Cr2CrLf16
  : public Cr2CrLf
{
 public:
  virtual CeGId getFromToCeGId() { return CEGID_16BIT_NE; }
  virtual IOType getIOType() { return IOTYPE_UINT16; }
};
  
class Cr2CrLf32
  : public Cr2CrLf
{
 public:
  virtual CeGId getFromToCeGId() { return CEGID_32BIT_NE; }
  virtual IOType getIOType() { return IOTYPE_UINT32; }
};

class Auto2NewLine
  : public GroupUtility
{
  NLConv nlc;
  Size spooled_size;
#ifdef _WIN32_WCE
  enum
  {
    max_spooled_size = 4,
  };
#else /* _WIN32_WCE */
#if (_MSC_VER == 1200)
  enum
  {
    max_spooled_size = 4,
  };
#else
  const static Size max_spooled_size = 4;
#endif
#endif /* _WIN32_WCE */
  UInt32 spool[max_spooled_size];
  bool unget_p;
  UInt32 unget_data;
  
 private:
  UInt32 nlOut();
  void unget(UInt32 c);
 public:
  Auto2NewLine(NLConv nlc);
  ~Auto2NewLine();
  void clear();
  virtual bool rewind();
  virtual Int8 getInt8() CCC_RAISES(IOException);
  virtual UInt16 getUInt16() CCC_RAISES(IOException);
  virtual UInt32 getUInt32() CCC_RAISES(IOException);
};

class Auto2NewLine8
  : public Auto2NewLine
{
 public:
  Auto2NewLine8(NLConv nlc);
  ~Auto2NewLine8();
  virtual CeGId getFromToCeGId();
  virtual IOType getIOType();
};

class Auto2NewLine16
  : public Auto2NewLine
{
 public:
  Auto2NewLine16(NLConv nlc);
  ~Auto2NewLine16();
  virtual CeGId getFromToCeGId();
  virtual IOType getIOType();
};

class Auto2NewLine32
  : public Auto2NewLine
{
 public:
  Auto2NewLine32(NLConv nlc);
  ~Auto2NewLine32();
  virtual CeGId getFromToCeGId();
  virtual IOType getIOType();
};

GroupUtility* createNLConvGroupUtility(NLConv nl, CeGId gid);

CCC_NAMESPACE_END(CCC);

#endif /* INCLUDE_ccc_iceman_utility_h */
