﻿// usgf: UNICODE String Generate Filter
// Copyright (C) 2001-2002 CYPAC, All rights reserved.
// by Tomoyuki Kudou <kudou@cypac.co.jp>

// $Id$

#ifndef INCLUDE_USGF_H
#define INCLUDE_USGF_H

#include <stdio.h>
#include <ccc/base/MemOFlow.h>
#include <ccc/base/FixedMemIFlow.h>
#include <ccc/base/CompositIFilter.h>
#include <ccc/base/Conveyer.h>
#include <ccc/app/Application.h>
#include <ccc/iceman/Iceman.h>

class UsgfApplication
  : public CCC::Application
{
  enum Option
  {
    OPT_NORMAL = 0,
    OPT_VERSION,
    OPT_HELP,
    OPT_DEBUG,
    OPT_VERBOSE,
    OPT_SOURCE,
    OPT_OUTPUT,
    OPT_SUPPRESS_LINE,
    OPT_SUPPRESS_ORG_COMMENT,
    OPT_ONLY_REMOVE_U,
    OPT_INPUT_CHARSET,
    OPT_OUTPUT_CHARSET,
    OPT_OLD_OUTPUT_FORMAT,
    OPT_SHOW_CHARSET,
    OPT_ENCODE_BY_INPUT_CHARSET,
    OPT_OUTPUT_CODING_COMMENT,
    OPT_OUTPUT_LF,
    OPT_OUTPUT_CR,
    OPT_OUTPUT_CRLF,
  };

  Option mode;
  bool verbose_p;
  bool debug_p;
  bool suppress_line_p;
  bool suppress_org_comment;
  bool only_remove_u_p;
  bool encode_by_input_charset;
  bool output_coding_comment;

  char* source_filename;
  char* output_filename;
  FILE* source;
  FILE* output;

  bool new_output_format;
  const char* input_charset;
  const char* output_charset;
  CCC::CeId input_ceid;
  CCC::CeId output_ceid;
  const char* nl;	/* newline string */

  static const char* version;

 protected:
  void showVersion();
  void showHelp();
  CCC::AppArg* getAppArg();
  bool checkArgument(int n, char* arg, char* opt, bool& opt_used_p);
  void convert();
  void oldEncodeParser();
  void encodeString(CCC::BString* out);
  void encodeSingleQuoted(CCC::BString* out);
  void outputHex(CCC::BString* out, int c);
  void outputHex(CCC::BString* out, int c, int c2);
  void outputHex2(CCC::BString* out, int c);
  void outputHex2(CCC::BString* out, int c, int c2);
  void removeUParser();
  void generateOutputFileName();
  void noEncodeString(CCC::BString* out);

  void encodeParser();
  //void icemanEncodeString(CCC::CompositIFilter* cf, char delim);
  void encodeString(CCC::BString* out, CCC::CompositIFilter* cf, char delim);
  void encodePut(CCC::BString* out, void* data, CCC::Size length);
  void encodeHexPut(CCC::BString* out, void* data, CCC::Size length);
  void showCharset();
 public:
  UsgfApplication(int argc, char** argv);
  ~UsgfApplication();
  int run();
  bool initialize();
  int clearAway(int ret);
};

#endif /* INCLUDE_USGF_H */
