﻿// $Id$

#ifndef INCLUDE_ccc_xml_AtomTable_h
#define INCLUDE_ccc_xml_AtomTable_h

#include <ccc/base/base.h>
#include <ccc/xml/config.h>

CCC_NAMESPACE_START(CCC);

/*!
 * (CODEX original)<br>
 * 文字列をアトムとして取り扱うために辞書として使用するクラスです。<br>
 * AVLDictクラスから継承したクラスです。辞書の検索や登録にはAVLDict
 * クラスのメソッドを使用してください。
 */
class AtomTable
  : public AVLDict<DOMString, DOMString>
{
  /*!
   * 登録要素からキーを返します。
   * \param element 登録要素
   * \return キー
   */
  virtual const DOMString* getKey(const DOMString* element) const;
  /*!
   * 2つのキーを比較します。
   * \param key1 キー1
   * \param key2 キー2
   * \retval 0 同一
   * \retval マイナス値 キー1の方が小さい
   * \retval プラス値 キー1の方が大きい
   */
  virtual int compare(const DOMString* key1, const DOMString* key2) const;
 public:
  /*!
   * コンストラクタ
   */
  AtomTable();
  /*!
   * デストラクタ<br>
   * 登録されているatomはデストラクタの呼び出しによって破棄されます。
   */
  ~AtomTable();
  /*!
   * DOMCharの文字列で辞書を検索します。
   * \param s 検索を行なう文字列
   * \return 検索結果, 0が返った場合には見つからなかったことを示します。
   */
  DOMString* searchWithDOMCharString(const DOMChar* s) const;
};

CCC_NAMESPACE_END(CCC);

#endif /* INCLUDE_ccc_xml_AtomTable_h */
