﻿// $Id$

#include <ccc/xml/dom.h>

using namespace CCC;

const DOMString*
Attr::getValue() const CCC_RAISES(DOMException)
{
  return &node_value;
}

Node*
Attr::cloneNode(CCC_IN bool deep) const CCC_RAISES(DOMException)
{
  Attr* node = new Attr(*this);
  return node;
}

void
Attr::setValue(const DOMString* new_value)
{
  node_value.assign(*new_value);
}

void
Attr::setValue(const DOMChar* new_value)
{
  node_value.assign(new_value);
}

void
Attr::setValue(const DOMString& new_value)
{
  node_value.assign(new_value);
}

Attr::Attr(Document* document_, CCC_IN const DOMString* name, CCC_IN const DOMString* value)
 : Node(document_, 0, Node::ATTRIBUTE_NODE)
{
  setNodeName(name);
  if (value)
  {
    node_value.assign(*value);
  }
  specified = true;
}

Attr::Attr(Document* document_, CCC_IN const DOMString& name, CCC_IN const DOMString& value)
 : Node(document_, 0, Node::ATTRIBUTE_NODE)
{
  setNodeName(name);
  node_value.assign(value);
  specified = true;
}

Attr::Attr(Document* document_, CCC_IN const DOMString* namespace_uri_, CCC_IN const DOMString* qualified_name_, const DOMString* value)
 : Node(document_, 0, Node::ATTRIBUTE_NODE)
{
  setNodeNameNS(namespace_uri_, qualified_name_);
  if (value)
  {
    node_value.assign(*value);
  }
  specified = true;
}

Attr::Attr(Document* document_, CCC_IN const DOMString& namespace_uri_, CCC_IN const DOMString& qualified_name_, const DOMString& value)
 : Node(document_, 0, Node::ATTRIBUTE_NODE)
{
  setNodeNameNS(namespace_uri_, qualified_name_);
  node_value.assign(value);
  specified = true;
}

Attr::Attr(const Attr& attr)
 : Node(attr)
{
  specified = attr.specified;
}

Attr::~Attr()
{
}

int
Attr::getIntValue() const CCC_RAISES(DOMException)
{
  Size size = node_value.getLength();
  DOMChar* p = node_value.getStartPtr();
  if (!p || size == 0)
  {
    return 0;
  }

  // NOTE: this code is for ANSI and UNICODE
  int n = 0;
  bool neg = false;
  if (*p == '-')
  {
    neg = true;
    p++;
    size--;
  }
  else if (*p == '+')
  {
    p++;
    size--;
  }
  
  for (Size i = 0; i < size; i++)
  {
    switch (*p++)
    {
     case '0':
      n = n * 10;
      break;
     case '1':
      n = n * 10 + 1;
      break;
     case '2':
      n = n * 10 + 2;
      break;
     case '3':
      n = n * 10 + 3;
      break;
     case '4':
      n = n * 10 + 4;
      break;
     case '5':
      n = n * 10 + 5;
      break;
     case '6':
      n = n * 10 + 6;
      break;
     case '7':
      n = n * 10 + 7;
      break;
     case '8':
      n = n * 10 + 8;
      break;
     case '9':
      n = n * 10 + 9;
      break;

     default:
      i = size;	// END
      break;
    }
  }
  if (neg)
  {
    n = -n;
  }
  return n;
}
