﻿// $Id$

#ifndef INCLUDE_ccc_xml_Attr_h
#define INCLUDE_ccc_xml_Attr_h

#include <ccc/base/base.h>
#include <ccc/xml/config.h>

CCC_NAMESPACE_START(CCC);

/*!
 * The Attr interface represents an attribute in an Element object.
 * Typically the allowable values for the attribute are defined in
 * a document type definition.
 *
 * Attr objects inherit the Node interface, but since they are not
 * actually child nodes of the element they describe, the DOM does not
 * consider them part of the document tree. Thus, the Node attributes
 * parentNode, previousSibling, and nextSibling have a null value for
 * Attr objects. The DOM takes the view that attributes are properties
 * of elements rather than having a separate identity from the elements
 * they are associated with; this should make it more efficient to
 * implement such features as default attributes associated with all
 * elements of a given type. Furthermore, Attr nodes may not be
 * immediate children of a DocumentFragment. However, they can be
 * associated with Element nodes contained within a DocumentFragment.
 * In short, users and implementors of the DOM need to be aware that
 * Attr nodes have some things in common with other objects inheriting
 * the Node interface, but they also are quite distinct.
 *
 * The attribute's effective value is determined as follows: if this
 * attribute has been explicitly assigned any value, that value is the
 * attribute's effective value; otherwise, if there is a declaration for
 * this attribute, and that declaration includes a default value, then
 * that default value is the attribute's effective value; otherwise, the
 * attribute does not exist on this element in the structure model until
 * it has been explicitly added. Note that the nodeValue attribute on
 * the Attr instance can also be used to retrieve the string version of
 * the attribute's value(s).
 *
 * In XML, where the value of an attribute can contain entity
 * references, the child nodes of the Attr node may be either Text or
 * EntityReference nodes (when these are in use; see the description of
 * EntityReference for discussion). Because the DOM Core is not aware of
 * attribute types, it treats all attribute values as simple strings,
 * even if the DTD or schema declares them as having tokenized types.
 */
class Attr
  : public Node
{
  /*!
   * If this attribute was explicitly given a value in the original
   * document, this is true; otherwise, it is false. Note that the
   * implementation is in charge of this attribute, not the user. If the
   * user changes the value of the attribute (even if it ends up having
   * the same value as the default value) then the specified flag is
   * automatically flipped to true. To re-specify the attribute as the
   * default value from the DTD, the user must delete the attribute.
   * The implementation will then make a new attribute available with
   * specified set to false and the default value (if one exists).<br>
   * In summary:
   * - If the attribute has an assigned value in the document then
   *	specified is true, and the value is the assigned value.
   * - If the attribute has no assigned value in the document and has
   *	a default value in the DTD, then specified is false, and the
   *	value is the default value in the DTD.
   * - If the attribute has no assigned value in the document and has
   *	a value of #IMPLIED in the DTD, then the attribute does not
   *	appear in the structure model of the document.
   * - If the ownerElement attribute is null (i.e. because it was
   *	just created or was set to null by the various removal and
   *	cloning operations) specified is true.
   */
  bool specified;
  /*!
   * Introduced in DOM Level 2:
   *
   * The Element node this attribute is attached to or null if this
   * attribute is not in use.
   */
  Node* owner_element;
 public:
  /*!
   * (CODEX original)<br>
   * コンストラクタ<br>
   * DOM Level 1のメソッドにより利用されます。
   * \param document Document
   * \param name ノード名
   * \param value 属性値
   */
  Attr(Document* document, CCC_IN const DOMString* name, CCC_IN const DOMString* value);
  Attr(Document* document, CCC_IN const DOMString& name, CCC_IN const DOMString& value);
  /*!
   * (CODEX original)<br>
   * コンストラクタ<br>
   * DOM Level 2のメソッドにより利用されます。
   * \param document Document
   * \param namespace_uri 名前空間URI
   * \param qualified_name 修飾名
   * \param value 属性値
   */
  Attr(Document* document, CCC_IN const DOMString* namespace_uri, CCC_IN const DOMString* qualified_name, const DOMString* value);
  Attr(Document* document, CCC_IN const DOMString& namespace_uri, CCC_IN const DOMString& qualified_name, const DOMString& value);
  /*!
   * (CODEX original)<br>
   * コピーコンストラクタ
   * \param attr コピー元
   */
  Attr(const Attr& attr);
  /*!
   * (CODEX original)<br>
   * デストラクタ
   */
  ~Attr();
  /*!
   * Returns the name of this attribute.
   */
  const DOMString* getName() const { return node_name; }
  /*!
   * On retrieval, the value of the attribute is returned as a string.
   * Character and general entity references are replaced with their
   * values. See also the method getAttribute on the Element interface.
   * On setting, this creates a Text node with the unparsed contents of
   * the string. I.e. any characters that an XML processor would
   * recognize as markup are instead treated as literal text. See also
   * the method setAttribute on the Element interface.
   */
  const DOMString* getValue() const CCC_RAISES(DOMException);
  /*!
   * (CODEX original)<br>
   * ノードを複製します。
   * \param deep deep copyするかどうかのフラグ
   * \return 複製されたノード
   */
  virtual Node* cloneNode(CCC_IN bool deep) const CCC_RAISES(DOMException);
  /*!
   * (CODEX original)<br>
   * \exception NO_MODIFICATION_ALLOWED_ERR Raised when the node is readonly.
   */
  void setValue(const DOMString* new_value);
  void setValue(const DOMString& new_value);
  void setValue(const DOMChar* new_value);
  /*!
   * (CODEX original)<br>
   * XMLをストリームに書き出します。
   * \param xo 出力先
   */
  virtual void writeXml(XMLOutputter* xo) const CCC_RAISES(IOException);
  /*!
   * (CODEX original)<br>
   * 符合と数字から成る属性値文字列を整数値に変換して取り出します。
   * \return 整数値
   */
  int getIntValue() const CCC_RAISES(DOMException);
  /*!
   * (CODEX original)<br>
   * specifiedフラグの値を得ます。
   * \return specifiedフラグの値
   */
  bool getSpecified() const { return specified; }
  /*!
   * Introduced in DOM Level 2:
   *
   * The Element node this attribute is attached to or null if this
   * attribute is not in use.
   *
   * 注: DOM Level 2の定義ではElement*を返しますが,CODEXではElement以外の
   * 所有ノードがあり得るため、Node*を返します。
   * \return the attached element.
   */
  Node* getOwnerElement() { return owner_element; }
 private:
  friend class XMLParser;
  /*!
   * (CODEX original)<br>
   * specifiedフラグの値をセットします。
   * XMLパーサによって使用されるメソッドです。
   */
  void setSpecified(bool p) { specified = p; }
 private:
  friend class NamedNodeMap;
  /*!
   * (CODEX original)<br>
   * この属性を所有するElementを設定します。
   * \param owner この属性を所有するElement
   */
  void setOwnerElement(Node* owner) { owner_element = owner; }
};

CCC_NAMESPACE_END(CCC);

#endif /* INCLUDE_ccc_xml_Attr_h */
