﻿// $Id$

#include <ccc/xml/dom.h>

using namespace CCC;

#ifndef CODEX_PURE_DOM

BufferPointer::~BufferPointer()
{
}

void
BufferPointer::clear()
{
  node = 0;
  offset = 0;
}

#if 0
Size
BufferPointer::getNodeNumber()
{
  const Node* top = node;
  const Node* n;
  for (n = node; n; n = n->getParentNode())
  {
    top = n;
  }
  if (!top)
  {
    return 0;
  }
  Size num = 1;
  ConstNodeIterator ni(top);
  while (n = ni.next())
  {
    if (n == node)
    {
      break;
    }
    num++;
  }
  return num;
}
#endif

// return plus value in case of bp1 is after than bp2.
int
BufferPointer::compare(BufferPointer* bp1, BufferPointer* bp2)
{
  if (bp1->node == bp2->node)
  {
    return ((int)bp1->offset) - ((int)bp2->offset);
  }
  else
  {
#if 1
    NodeAddress na1(bp1->getNode());
    NodeAddress na2(bp2->getNode());
    Size n = getMin(na1.getSize(), na2.getSize());
    Size i;
    for (i = 1; i < n; i++)
    {
      Size n1 = na1.getAddress(i);
      Size n2 = na2.getAddress(i);
      if (n1 > n2)
      {
	return 1;
      }
      if (n1 < n2)
      {
	return -1;
      }
    }
    if (na1.getSize() > na2.getSize()) 
    {
      return 1;
    }
    return -1;
#else
    Size bp1_num = bp1->getNodeNumber();
    Size bp2_num = bp2->getNodeNumber();
    return ((int)bp1_num) - ((int)bp2_num);
#endif
  }
}

DOMChar*
BufferPointer::getStr() const
{
  return (DOMChar*)node->getNodeValue()->getStartPtr() + offset;
}

// ------------------------------------------------------------
// class NodeAddress

NodeAddress::NodeAddress(Size n)
{
  address = new Size[n];
  size = n;
}

NodeAddress::NodeAddress(Node* node)
{
  Size n = 0;
  Node* p = node;
  while (p)
  {
    n++;
    p = p->getParentNode();
  }
  address = new Size[n];
  size = n;

  // setup node address
  Node* parent;
  const NodeList* nl;
  p = node;
  while (p)
  {
    parent = p->getParentNode();
    if (parent)
    {
      nl = parent->getChildNodes();
      address[--n] = nl->getPosition(p);
    }
    p = parent;
  }
  address[0] = 0;
}

NodeAddress::~NodeAddress()
{
  delete address;
}

Size 
NodeAddress::getAddress(Size n)
{
  assert(n < size);
  return address[n];
}

void
NodeAddress::setAddress(Size n, Size adr)
{
  assert(n < size);
  address[n] = adr;
}

#endif /* CODEX_PURE_DOM */

