﻿// $Id$

#ifndef INCLUDE_ccc_xml_BufferPointer_h
#define INCLUDE_ccc_xml_BufferPointer_h

#include <ccc/xml/config.h>

#ifndef CODEX_PURE_DOM

CCC_NAMESPACE_START(CCC);

/*!
 * (CODEX original)<br>
 * 特定のノードのオフセット情報を表現するためのクラスです。
 * 主としてTextを対象に使用することを想定していますが、
 * 別の目的で利用することも可能です。
 * ノードには、BufferPointerのリストが存在します。
 * ノードにBufferPointerを登録するとノードがそのBufferPointer
 * の管理を行ない、ノードが無効になったときに適切に値をクリア
 * します。ノードのデストラクタの呼びだしに伴い、BufferPointer
 * のデストラクタが自動的に呼び出される訳ではないのに注意して
 * ください。
 */
class BufferPointer
{
  /*!
   * 対象のノード
   */
  Node* node;
  /*!
   * オフセット値
   */
  Size offset;
 public:
  /*!
   * コンストラクタ
   */
  BufferPointer() { node = 0; offset = 0; }
  /*!
   * コンストラクタ
   * \param bp 複製する対象
   */
  BufferPointer(BufferPointer* bp) { node = bp->node; offset = bp->offset; }
  /*!
   * コンストラクタ
   * \param node_ ノード
   * \param offset_ オフセット値
   */
  BufferPointer(Node* node_, Size offset_) { node = node_; offset = offset_; }
  /*!
   * デストラクタ
   */
  virtual ~BufferPointer();
  /*!
   * 値を設定します。
   * \param node_ ノード
   * \param offset_ オフセット値
   */
  void set(Node* node_, Size offset_ = 0) { node = node_; offset = offset_; }
  /*!
   * オフセット値を設定します。
   * \param offset_ オフセット値
   */
  void set(Size offset_) { offset = offset_; }
  /*!
   * ノードを得ます。
   * \return ノード
   */
  Node* getNode() const { return node; }
  /*!
   * オフセット値を得ます。
   * \return オフセット値
   */
  Size getOffset() const { return offset; }
  /*!
   * 値をクリアします。<br>
   * ノードに登録されたBufferPointerは、ノードのデストラクタの
   * 呼びだしにより、このメソッドが呼び出されます。また、
   * ノードから登録解除されたBufferPointerは同様にこのメソッド
   * が呼び出されます。
   */
  void clear();
  // obsolete method
  //Size getNodeNumber();
  /*!
   * BufferPointの値により、大小を比較します。
   * \retval 0 同一位置
   * \retval マイナス値 bp1の方が小さい
   * \retval プラス値 bp1の方が大きい
   */
  static int compare(BufferPointer* bp1, BufferPointer* bp2);
  /*!
   * NodeValueのoffset位置の文字へのポインタを返します。
   * オフセット値が有効かどうかのチェックは行ないません。
   * \return NodeValueのoffset位置の文字へのポインタ
   */
  DOMChar* getStr() const;
};

/*!
 * BufferPointerのリスト
 */
typedef LinkList<BufferPointer> BPList;
/*!
 * BufferPointerのイタレータ
 */
typedef Iterator<BufferPointer> BPListIterator;

CCC_NAMESPACE_END(CCC);

#endif /* CODEX_PURE_DOM */

#endif /* INCLUDE_ccc_xml_BufferPointer_h */
