﻿// $Id$

#ifndef INCLUDE_ccc_xml_CDATASection_h
#define INCLUDE_ccc_xml_CDATASection_h

#include <ccc/base/base.h>
#include <ccc/xml/config.h>

CCC_NAMESPACE_START(CCC);

/*!
 * CDATA sections are used to escape blocks of text containing characters
 * that would otherwise be regarded as markup.  The only delimiter that is
 * recognized in a CDATA section is the "]]>" string that ends the CDATA
 * section.  CDATA sections cannot be nested.  Their primary purpose is for
 * including material such as XML fragments, without needing to escape all
 * the delimiters.
 *
 * The DOMString attribute of the Text node holds the text that is contained
 * by the CDATA section.  Note that this may contain characters that need to
 * be escaped outside of CDATA sections and that, depending on the character
 * encoding ("charset") chosen for serialization, it may be impossible to
 * write out some characters as part of a CDATA section.
 *
 * The CDATASection interface inherits from the CharacterData interface
 * through the Text interface.  Adjacent CDATASection nodes are not merged
 * by use of the normalize method of the Node interface.
 *
 * Note: Because no markup is recognized within a CDATASection, character
 * numeric references cannot be used as an escape mechanism when
 * serializing.  Therefore, action needs to be taken when serializing a
 * CDATASection with a character encoding where some of the contained
 * characters cannot be represented.  Failure to do so would not produce
 * well-formed XML.  One potential solution in the serialization process is
 * to end the CDATA section before the character, output the character using
 * a character reference or entity reference, and open a new CDATA section
 * for any further characters in the text node. Note, however, that some
 * code conversion libraries at the time of writing do not return an error
 * or exception when a character is missing from the encoding, making the
 * task of ensuring that data is not corrupted on serialization more
 * difficult.
 */
class CDATASection
  : public Text
{
 public:
  /*!
   * (CODEX original)<br>
   * ノードを複製します。
   * \param deep deep copyするかどうかのフラグ
   * \return 複製されたノード
   */
  virtual Node* cloneNode(CCC_IN bool deep) const CCC_RAISES(DOMException);
  /*!
   * (CODEX original)<br>
   * コンストラクタ
   * \param document Document
   * \param parent 親ノード
   * \param value ノード値
   */
  CDATASection(Document* document, Node* parent, CCC_IN const DOMString* value);
  CDATASection(Document* document, Node* parent, CCC_IN const DOMString& value);
  /*!
   * (CODEX original)<br>
   * コピーコンストラクタ
   * \param cdatasection コピー元
   */
  CDATASection(const CDATASection& cdatasection);
  /*!
   * (CODEX original)<br>
   * デストラクタ
   */
  ~CDATASection();
  /*!
   * (CODEX original)<br>
   * XMLをストリームに書き出します。
   * \param xo 出力先
   */
  virtual void writeXml(XMLOutputter* xo) const CCC_RAISES(IOException);
};

CCC_NAMESPACE_END(CCC);

#endif /* INCLUDE_ccc_xml_CDATASection_h */
