﻿// $Id$

#include <string.h>
#include <ccc/file/FileIFlow.h>
#include <ccc/base/TextReader.h>
#include <ccc/xml/Catalog.h>

CCC_NAMESPACE_START(CCC);

// ------------------------------------------------------------------------
// class Catalog

Catalog::Catalog()
{
}

Catalog::~Catalog()
{
  CatalogUnit* u;
  while ((u = catalog_units.pop()))
  {
    delete u;
  }
}

const char*
Catalog::getPath(CatalogUnit::UnitType ut, char* id)
{
  Iterator<CatalogUnit>* itr = catalog_units.createIterator();
  CatalogUnit* cu;
  while ((cu = itr->next()))
  {
    if ((cu->getUnitType() == ut) &&
	!strcmp(id, cu->getId()))
    {
      break;
    }
  }
  delete itr;
  if (cu)
  {
    return cu->getPath();
  }
  return 0;
}

const char*
Catalog::getPublicIdPath(char* public_id)
{
  return getPath(CatalogUnit::UT_PUBLIC, public_id);
}

const char*
Catalog::getSystemIdPath(char* system_id)
{
  return getPath(CatalogUnit::UT_SYSTEM, system_id);
}

bool
Catalog::readCatalog(char* catalog_path)
{
  FileIFlow in;
  if (!in.open(catalog_path))
  {
    return false;
  }
  TextReader<char> reader(&in);
  try
  {
    static const char* delim1[] = { " ", "\t", "\r", "\n", 0 };
    TString<char>* s;
    TString<char>* s2;
    CatalogUnit* cu;
    for (;;)
    {
      if (reader.readString("--"))
      {
	s = reader.readDelimitedString("--");
	//printf("COMMENT: [%s]\n", s->getCString());
	cu = new CatalogUnit(CatalogUnit::UT_COMMENT, s->getCString());
	catalog_units.push(cu);
	delete s;
      }
      else if (reader.readString("OVERRIDE"))
      {
	reader.skipCandidates(" \t\n\r");
	if (reader.readString("YES"))
	{
	  //printf("OVERRIDE: [YES]\n");
	  cu = new CatalogUnit(CatalogUnit::UT_OVERRIDE, "YES");
	  catalog_units.push(cu);
	}
	else if (reader.readString("NO"))
	{
	  //printf("OVERRIDE: [NO]\n");
	  cu = new CatalogUnit(CatalogUnit::UT_OVERRIDE, "NO");
	  catalog_units.push(cu);
	}
	else
	{
	  // error
	}
      }
      else if (reader.readString("SGMLDECL"))
      {
	reader.skipCandidates(" \t\n\r");
	if (reader.readChar('"'))
	{
	  s = reader.readDelimitedCharString('"');
	}
	else
	{
	  s = reader.readDelimitedString(delim1);
	}
	cu = new CatalogUnit(CatalogUnit::UT_SGMLDECL, 0, s->getCString());
	catalog_units.push(cu);
	//printf("SGMLDECL: [%s]\n", s->getCString());
	delete s;
      }
      else if (reader.readString("PUBLIC"))
      {
	reader.skipCandidates(" \t\n\r");
	if (!reader.readChar('"'))
	{
	  //printf("error\n");
	  return false;
	}
	s = reader.readDelimitedCharString('"');
	reader.skipCandidates(" \t\n\r");
	if (reader.readChar('"'))
	{
	  s2 = reader.readDelimitedCharString('"');
	}
	else
	{
	  s2 = reader.readDelimitedString(delim1);
	}
	//printf("PUBLIC: [%s] [%s]\n", s->getCString(), s2->getCString());
	cu = new CatalogUnit(CatalogUnit::UT_PUBLIC, s->getCString(), s2->getCString());
	catalog_units.push(cu);
	delete s;
	delete s2;
      }
      else if (reader.readString("SYSTEM"))
      {
	reader.skipCandidates(" \t\n\r");
	if (!reader.readChar('"'))
	{
	  //printf("error\n");
	  return false;
	}
	s = reader.readDelimitedCharString('"');
	reader.skipCandidates(" \t\n\r");
	if (reader.readChar('"'))
	{
	  s2 = reader.readDelimitedCharString('"');
	}
	else
	{
	  s2 = reader.readDelimitedString(delim1);
	}
	//printf("SYSTEM: [%s] [%s]\n", s->getCString(), s2->getCString());
	cu = new CatalogUnit(CatalogUnit::UT_SYSTEM, s->getCString(), s2->getCString());
	catalog_units.push(cu);
	delete s;
	delete s2;
      }
      else if (reader.readString("DTDDECL"))
      {
	reader.skipCandidates(" \t\n\r");
	if (!reader.readChar('"'))
	{
	  //printf("error\n");
	  return false;
	}
	s = reader.readDelimitedCharString('"');
	reader.skipCandidates(" \t\n\r");
	if (reader.readChar('"'))
	{
	  s2 = reader.readDelimitedCharString('"');
	}
	else
	{
	  s2 = reader.readDelimitedString(delim1);
	}
	//printf("PUBLIC: [%s] [%s]\n", s->getCString(), s2->getCString());
	cu = new CatalogUnit(CatalogUnit::UT_DTDDECL, s->getCString(), s2->getCString());
	catalog_units.push(cu);
	delete s;
	delete s2;
      }
      else 
      {
	s = reader.skipCandidates(" \t\n\r");
	if (s->getLength() > 0)
	{
	  // SPACE
	}
	else
	{
	  // error
	  /* char c = */ reader.getChar();
	  //printf("UNKNOWN: [%c]\n", c);
	  return false;
	}
      }
    }
  }
  catch (IOException ioe)
  {
    if (ioe.errorNum() != IOException::READ_BEYOND_THE_EOF)
    {
      //fprintf(stderr, "%s", ioe.getErrorString());
      return false;
    }
  }
  return true;
}

CCC_NAMESPACE_END(CCC);

#if 0
// ------------------------------------------------------------------------
// Catalog parser

#include <ccc/base/fileflow.h>
#include <ccc/base/textfilter.h>

using namespace CCC;

// catalog =: EMPTY
//         | item catalog
// item =: space* 
//	| -- comment --
//	| OVERRIDE (YES | NO)
//	| SGMLDECL space* "? PATH "?
//	| PUBLIC space* " PUBID " space* "? PATH "?
//	| SYSTEM space* " SYSID " space* "? PATH "?
//	| DTDDECL space* " PUBID " space* "? PATH "?
// space =: ' ' | TAB | NL

bool parseCatalog(char* path);

int
main()
{
  char* path[] = 
  {
    "./sgml-lib/catalog",
    "./sgml-lib/mod/catalog",
    "./sgml-lib/CR-MathML2-20001113/catalog",
    "./sgml-lib/old/mod/1996-01/catalog",
    "./sgml-lib/old/catalog",
    "./sgml-lib/old/older/catalog",
    "./sgml-lib/pro/html/dtds/catalog",
    0,
  };
  for (char** x = path; *x; x++)
  {
    printf("PARSE: %s\n", *x);
    parseCatalog(*x);
  }
  return 0;
}

bool
parseCatalog(char* path)
{
  FileIFlow in;
  if (!in.open(path))
  {
    return false;
  }
  
  TextReader<char> reader(&in);
  try
  {
    static const char* delim1[] = { " ", "\t", "\r", "\n", 0 };
    TString<char>* s;
    TString<char>* s2;
    for (;;)
    {
      if (reader.readString("--"))
      {
	s = reader.readDelimitedString("--");
	printf("COMMENT: [%s]\n", s->getCString());
	delete s;
      }
      else if (reader.readString("OVERRIDE"))
      {
	reader.skipCandidates(" \t\n\r");
	if (reader.readString("YES"))
	{
	  printf("OVERRIDE: [YES]\n");
	}
	else if (reader.readString("NO"))
	{
	  printf("OVERRIDE: [NO]\n");
	}
	else
	{
	  // error
	}
      }
      else if (reader.readString("SGMLDECL"))
      {
	reader.skipCandidates(" \t\n\r");
	if (reader.readChar('"'))
	{
	  s = reader.readDelimitedCharString('"');
	}
	else
	{
	  s = reader.readDelimitedString(delim1);
	}
	printf("SGMLDECL: [%s]\n", s->getCString());
	delete s;
      }
      else if (reader.readString("PUBLIC"))
      {
	reader.skipCandidates(" \t\n\r");
	if (!reader.readChar('"'))
	{
	  printf("error\n");
	}
	s = reader.readDelimitedCharString('"');
	reader.skipCandidates(" \t\n\r");
	if (reader.readChar('"'))
	{
	  s2 = reader.readDelimitedCharString('"');
	}
	else
	{
	  s2 = reader.readDelimitedString(delim1);
	}
	printf("PUBLIC: [%s] [%s]\n", s->getCString(), s2->getCString());
	delete s;
	delete s2;
      }
      else if (reader.readString("SYSTEM"))
      {
	reader.skipCandidates(" \t\n\r");
	if (!reader.readChar('"'))
	{
	  printf("error\n");
	}
	s = reader.readDelimitedCharString('"');
	reader.skipCandidates(" \t\n\r");
	if (reader.readChar('"'))
	{
	  s2 = reader.readDelimitedCharString('"');
	}
	else
	{
	  s2 = reader.readDelimitedString(delim1);
	}
	printf("SYSTEM: [%s] [%s]\n", s->getCString(), s2->getCString());
	delete s;
	delete s2;
      }
      else if (reader.readString("DTDDECL"))
      {
	reader.skipCandidates(" \t\n\r");
	if (!reader.readChar('"'))
	{
	  printf("error\n");
	}
	s = reader.readDelimitedCharString('"');
	reader.skipCandidates(" \t\n\r");
	if (reader.readChar('"'))
	{
	  s2 = reader.readDelimitedCharString('"');
	}
	else
	{
	  s2 = reader.readDelimitedString(delim1);
	}
	printf("PUBLIC: [%s] [%s]\n", s->getCString(), s2->getCString());
	delete s;
	delete s2;
      }
      else 
      {
	s = reader.skipCandidates(" \t\n\r");
	if (s->getLength() > 0)
	{
	  // SPACE
	}
	else
	{
	  // error
	  char c = reader.getChar();
	  printf("UNKNOWN: [%c]\n", c);
	}
      }
    }
  }
  catch (IOException ioe)
  {
    if (ioe.errorNum() != IOException::READ_BEYOND_THE_EOF)
    {
      fprintf(stderr, "%s", ioe.getErrorString());
      return false;
    }
  }
  return true;
}
#endif
