﻿// $Id$

#ifndef INCLUDE_ccc_xml_Catalog_h
#define INCLUDE_ccc_xml_Catalog_h

#include <ccc/base/LinkList.h>
#include <ccc/xml/CatalogUnit.h>

CCC_NAMESPACE_START(CCC);

/* ------------------------------------------------------------------------
 * NOTE:
 *
 * OASIS "Open Catalog" standard
 * http://oasis-open.org/committees/entity/spec-2001-08-06.html
 * にてXMLでカタログを記載する方法が規定されています。
 * いずれはこの形式のカタログもサポートする予定です。
 * ------------------------------------------------------------------------ */

/* Catalogファイルの構文(BNF)
 *
 * catalog =: EMPTY
 *         | item catalog
 * item =: space* 
 *	| -- comment --
 *	| OVERRIDE (YES | NO)
 *	| SGMLDECL space* "? PATH "?
 *	| PUBLIC space* " PUBID " space* "? PATH "?
 *	| SYSTEM space* " SYSID " space* "? PATH "?
 *	| DTDDECL space* " PUBID " space* "? PATH "?
 * space =: ' ' | TAB | NL
 */

class Catalog
{
  /*!
   * カタログ情報
   */
  LinkList<CatalogUnit> catalog_units;
 public:
  /*!
   * コンストラクタ
   */
  Catalog();
  /*!
   * デストラクタ
   */
  ~Catalog();
  /*!
   * 指定のカタログ単位形式で、指定idにマッチするパスを得ます。
   * \param ut カタログ単位形式
   * \param id ID
   * \return パス, 見つからない場合には0が返ります。
   */
  const char* getPath(CatalogUnit::UnitType ut, char* id);
  /*!
   * 指定したPUBLIC IDにマッチするパスを得ます。
   * \param public_id ID
   * \return パス, 見つからない場合には0が返ります。
   */
  const char* getPublicIdPath(char* public_id);
  /*!
   * 指定したSYSTEM IDにマッチするパスを得ます。
   * \param system_id ID
   * \return パス, 見つからない場合には0が返ります。
   */
  const char* getSystemIdPath(char* system_id);
  /*!
   * Catalogファイルを読み込みます。
   * \param catalog_path カタログファイルのパス
   * \return 正常に読み込めた場合にはtrueを返します。
   */
  bool readCatalog(char* catalog_path);
};

CCC_NAMESPACE_END(CCC);

#endif /* INCLUDE_ccc_xml_Catalog_h */
